/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.rpc;

import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.channel.ChannelRequest;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.types.State;
import org.openhab.binding.intellihouse.rpc.ThingRpcService;

public abstract class ChannelRpcService<REQ extends ChannelRequest<RES>, RES extends Response>
extends ThingRpcService<REQ, RES> {
    private ItemChannelLinkRegistry itemChannelLinkRegistry;

    protected ItemChannelLinkRegistry getItemChannelLinkRegistry() {
        if (this.itemChannelLinkRegistry == null) {
            this.itemChannelLinkRegistry = this.getServiceOrFail(ItemChannelLinkRegistry.class);
        }
        return this.itemChannelLinkRegistry;
    }

    protected Set<ChannelUID> getChannelUIDs(ThingTypeUID thingTypeUID, REQ request) {
        Objects.requireNonNull(thingTypeUID, "thingTypeUID");
        Objects.requireNonNull(request, "request");
        LinkedHashSet<ChannelUID> channelUids = new LinkedHashSet<ChannelUID>();
        Set<Thing> things = this.getThings(thingTypeUID, request);
        for (Thing thing : things) {
            ChannelUID channelUID = new ChannelUID(thing.getUID(), request.getChannelId());
            channelUids.add(channelUID);
        }
        return channelUids;
    }

    protected void stateUpdated(ChannelUID channelUID, State state) {
        Objects.requireNonNull(channelUID, "channelUID");
        Objects.requireNonNull(state, "state");
        Set items = this.getItemChannelLinkRegistry().getLinkedItems((UID)channelUID);
        for (Item item : items) {
            State acceptedState = ItemUtil.convertToAcceptedState((State)state, (Item)item);
            this.getEventPublisher().post((Event)ItemEventFactory.createStateEvent((String)item.getName(), (State)acceptedState, (String)channelUID.toString()));
        }
    }
}

