/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.rpc;

import house.intelli.core.rpc.AbstractRpcService;
import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.openhab.binding.intellihouse.IntelliHouseActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class ThingRpcService<REQ extends Request<RES>, RES extends Response>
extends AbstractRpcService<REQ, RES> {
    private ThingRegistry thingRegistry;
    private EventPublisher eventPublisher;

    protected ThingRegistry getThingRegistry() {
        if (this.thingRegistry == null) {
            this.thingRegistry = this.getServiceOrFail(ThingRegistry.class);
        }
        return this.thingRegistry;
    }

    protected EventPublisher getEventPublisher() {
        if (this.eventPublisher == null) {
            this.eventPublisher = this.getServiceOrFail(EventPublisher.class);
        }
        return this.eventPublisher;
    }

    protected Set<Thing> getThings(ThingTypeUID thingTypeUID, REQ request) {
        Objects.requireNonNull(request, "request");
        return this.getThings(thingTypeUID, Objects.requireNonNull(request.getClientHostId(), "request.clientHostId"));
    }

    protected Set<Thing> getThings(ThingTypeUID thingTypeUID, HostId hostId) {
        Objects.requireNonNull(hostId, "hostId");
        ThingRegistry thingRegistry = this.getThingRegistry();
        LinkedHashSet<Thing> result = new LinkedHashSet<Thing>();
        String hostIdStr = hostId.toString();
        for (Thing thing : thingRegistry.getAll()) {
            String hid;
            if (thingTypeUID != null && !thingTypeUID.equals((Object)thing.getThingTypeUID()) || !hostIdStr.equals(hid = (String)thing.getConfiguration().get("hostId"))) continue;
            result.add(thing);
        }
        return result;
    }

    public BundleContext getBundleContext() {
        return IntelliHouseActivator.getInstance().getBundleContext();
    }

    protected <S> S getServiceOrFail(Class<S> serviceClass) {
        Objects.requireNonNull(serviceClass, "serviceClass");
        BundleContext bundleContext = Objects.requireNonNull(this.getBundleContext(), "bundleContext");
        ServiceReference serviceReference = bundleContext.getServiceReference(serviceClass);
        if (serviceReference == null) {
            throw new IllegalStateException("No ServiceReference found for: " + serviceClass.getName());
        }
        Object service = bundleContext.getService(serviceReference);
        if (service == null) {
            throw new IllegalStateException("ServiceReference did not point to existing service: " + serviceReference);
        }
        return (S)service;
    }
}

