/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.rpc.echo;

import house.intelli.core.rpc.echo.EchoRequest;
import house.intelli.core.rpc.echo.EchoResponse;
import house.intelli.core.rpc.echo.EchoRpcService;
import java.util.Objects;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiEchoRpcService
extends EchoRpcService {
    private final Logger logger = LoggerFactory.getLogger(OsgiEchoRpcService.class);
    protected ItemRegistry itemRegistry;

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    public OsgiEchoRpcService() {
        this.logger.debug("<init>");
    }

    public int getPriority() {
        return super.getPriority() + 1;
    }

    public EchoResponse process(EchoRequest request) throws Exception {
        this.logger.info("process");
        Objects.requireNonNull(this.itemRegistry, "itemRegistry");
        EchoResponse response = super.process(request);
        response.setPayload("OSGi: " + request.getPayload());
        return response;
    }
}

