/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.rpc.pv;

import house.intelli.core.rpc.VoidResponse;
import house.intelli.core.rpc.pv.PvStatus;
import house.intelli.core.rpc.pv.PvStatusEventRequest;
import house.intelli.jdo.Entity;
import house.intelli.jdo.IntelliHouseTransaction;
import house.intelli.jdo.model.PvStatusDao;
import house.intelli.jdo.model.PvStatusEntity;
import java.util.Objects;
import org.openhab.binding.intellihouse.jdo.JdoPersistenceService;
import org.openhab.binding.intellihouse.rpc.ThingRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PvStatusEventRpcService
extends ThingRpcService<PvStatusEventRequest, VoidResponse> {
    private final Logger logger = LoggerFactory.getLogger(PvStatusEventRpcService.class);
    private JdoPersistenceService jdoPersistenceService;

    public PvStatusEventRpcService() {
        this.logger.info("<init>");
    }

    public VoidResponse process(PvStatusEventRequest request) throws Exception {
        this.logger.debug("process: request={}", (Object)request);
        JdoPersistenceService jps = Objects.requireNonNull(this.jdoPersistenceService, "jdoPersistenceService");
        Throwable throwable = null;
        Object var4_5 = null;
        try (IntelliHouseTransaction tx = jps.beginTransaction();){
            this.logger.debug("process: Started transaction.");
            PvStatusDao pvStatusDao = (PvStatusDao)tx.getDao(PvStatusDao.class);
            int count = 0;
            for (PvStatus pvStatus : request.getPvStatuses()) {
                ++count;
                PvStatusEntity entity = pvStatusDao.getPvStatusEntity(pvStatus.getDeviceName(), pvStatus.getMeasured());
                this.logger.debug("process: Read entity: {}", (Object)entity);
                if (entity == null) {
                    entity = new PvStatusEntity();
                }
                this.updatePvStatusEntity(entity, pvStatus);
                pvStatusDao.makePersistent((Entity)entity);
                if (count % 100 != 0) continue;
                this.logger.debug("process: Persisted {} PvStatusEntity objects. Flushing...", (Object)count);
                tx.flush();
                this.logger.debug("process: Persisted {} PvStatusEntity objects. Flushed.", (Object)count);
            }
            this.logger.debug("process: Committing transaction...");
            tx.commit();
            this.logger.debug("process: Committed transaction.");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    protected void updatePvStatusEntity(PvStatusEntity entity, PvStatus pvStatus) {
        Objects.requireNonNull(entity, "entity");
        Objects.requireNonNull(pvStatus, "pvStatus");
        entity.setDeviceName(pvStatus.getDeviceName());
        entity.setMeasured(pvStatus.getMeasured());
        entity.setDeviceMode(pvStatus.getDeviceMode());
        entity.setAcInVoltage(pvStatus.getAcInVoltage());
        entity.setAcInFrequency(pvStatus.getAcInFrequency());
        entity.setAcOutVoltage(pvStatus.getAcOutVoltage());
        entity.setAcOutFrequency(pvStatus.getAcOutFrequency());
        entity.setAcOutApparentPower(pvStatus.getAcOutApparentPower());
        entity.setAcOutActivePower(pvStatus.getAcOutActivePower());
        entity.setAcOutLoadPercentage(pvStatus.getAcOutLoadPercentage());
        entity.setInternalBusVoltage(pvStatus.getInternalBusVoltage());
        entity.setBatteryVoltageAtInverter(pvStatus.getBatteryVoltageAtInverter());
        entity.setBatteryChargeCurrent(pvStatus.getBatteryChargeCurrent());
        entity.setBatteryCapacityPercentage(pvStatus.getBatteryCapacityPercentage());
        entity.setHeatSinkTemperature(pvStatus.getHeatSinkTemperature());
        entity.setPvToBatteryCurrent(pvStatus.getPvToBatteryCurrent());
        entity.setPvVoltage(pvStatus.getPvVoltage());
        entity.setBatteryVoltageAtCharger(pvStatus.getBatteryVoltageAtCharger());
        entity.setBatteryDischargeCurrent(pvStatus.getBatteryDischargeCurrent());
        entity.setStatusBitmask(pvStatus.getStatusBitmask());
        entity.setEepromVersion(pvStatus.getEepromVersion());
        entity.setPvPower(pvStatus.getPvPower());
    }

    public JdoPersistenceService getJdoPersistenceService() {
        return this.jdoPersistenceService;
    }

    public void setJdoPersistenceService(JdoPersistenceService jdoPersistenceService) {
        this.jdoPersistenceService = jdoPersistenceService;
    }

    public void unsetJdoPersistenceService(JdoPersistenceService jdoPersistenceService) {
        this.jdoPersistenceService = null;
    }
}

