/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.service;

import house.intelli.core.service.AbstractServiceRegistryDelegate;
import house.intelli.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiServiceRegistryDelegate<S>
extends AbstractServiceRegistryDelegate<S> {
    private final Logger logger = LoggerFactory.getLogger(OsgiServiceRegistryDelegate.class);
    private final Class<S> serviceClass;
    private final BundleContext bundleContext;
    private ServiceListener serviceListener;

    public OsgiServiceRegistryDelegate(Class<S> serviceClass, BundleContext bundleContext) {
        this.serviceClass = Objects.requireNonNull(serviceClass, "serviceClass");
        this.bundleContext = Objects.requireNonNull(bundleContext, "bundleContext");
    }

    public void setServiceRegistry(ServiceRegistry<S> serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
        this.hookListener();
    }

    public List<S> getServices() {
        try {
            ArrayList<Object> services = new ArrayList<Object>();
            Collection serviceReferences = this.bundleContext.getServiceReferences(this.serviceClass, null);
            for (ServiceReference serviceReference : serviceReferences) {
                Object service = this.bundleContext.getService(serviceReference);
                if (service == null) continue;
                services.add(service);
            }
            this.logger.info("getServices: serviceClass='{}' services={}", (Object)this.serviceClass.getName(), services);
            return services;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected void serviceChanged(ServiceEvent event) {
        this.logger.info("serviceChanged: serviceClass='{}'", (Object)this.serviceClass.getName());
        ServiceRegistry serviceRegistry = this.getServiceRegistry();
        if (serviceRegistry != null) {
            serviceRegistry.fireServiceRegistryChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hookListener() {
        OsgiServiceRegistryDelegate osgiServiceRegistryDelegate = this;
        synchronized (osgiServiceRegistryDelegate) {
            if (this.serviceListener != null) {
                return;
            }
            this.serviceListener = event -> this.serviceChanged(event);
        }
        boolean unhook = true;
        try {
            try {
                String filter = String.format("(objectclass=%s)", this.serviceClass.getName());
                this.bundleContext.addServiceListener(this.serviceListener, filter);
                unhook = false;
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        finally {
            if (unhook) {
                this.unhookListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unhookListener() {
        ServiceListener sl;
        OsgiServiceRegistryDelegate osgiServiceRegistryDelegate = this;
        synchronized (osgiServiceRegistryDelegate) {
            sl = this.serviceListener;
            this.serviceListener = null;
        }
        if (sl != null) {
            this.bundleContext.removeServiceListener(sl);
        }
    }

    public void close() {
        this.unhookListener();
        super.close();
    }
}

