/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.servlet;

import house.intelli.core.jaxb.IntelliHouseJaxbContextProvider;
import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.HttpRpcServerTransportProvider;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.RpcContextMode;
import house.intelli.core.rpc.RpcServer;
import house.intelli.core.rpc.RpcServerTransport;
import house.intelli.core.rpc.RpcServerTransportProvider;
import house.intelli.core.rpc.RpcService;
import house.intelli.core.rpc.ServletRpcServerTransport;
import house.intelli.core.service.ServiceRegistry;
import house.intelli.core.util.ReflectionUtil;
import house.intelli.core.util.StringUtil;
import house.intelli.core.util.Util;
import house.intelli.pgp.Pgp;
import house.intelli.pgp.PgpAuthenticationCallback;
import house.intelli.pgp.PgpKey;
import house.intelli.pgp.PgpOwnerTrust;
import house.intelli.pgp.PgpRegistry;
import house.intelli.pgp.StaticPgpAuthenticationCallback;
import house.intelli.pgp.gnupg.BcWithLocalGnuPgPgp;
import house.intelli.pgp.rpc.PgpTransportSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.events.ThingEventFactory;
import org.openhab.binding.intellihouse.DateUtil;
import org.openhab.binding.intellihouse.IntelliHouseActivator;
import org.openhab.binding.intellihouse.service.OsgiServiceRegistryDelegate;
import org.openhab.binding.intellihouse.servlet.BaseServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServlet
extends BaseServlet {
    private static final String METHOD_POST = "POST";
    private final Logger logger = LoggerFactory.getLogger(RpcServlet.class);
    public static final String SERVLET_NAME = "RPC";
    public static final String CONFIG_KEY_TRANSPORT = "transportProvider";
    public static final String CONFIG_KEY_LOCAL_HOST_ID = "localHostId";
    public static final String CONFIG_KEY_PGP_PASSPHRASE = "pgpPassphrase";
    private EventPublisher eventPublisher;
    private ThingRegistry thingRegistry;
    private RpcContext rpcContext;
    private BundleContext bundleContext;
    private OsgiServiceRegistryDelegate<RpcService> rpcServiceServiceRegistryDelegate;
    private OsgiServiceRegistryDelegate<IntelliHouseJaxbContextProvider> jaxbContextProviderServiceRegistryDelegate;
    private ServiceRegistration<RpcContext> rpcContextServiceRegistration;
    private Timer thingStatusOfflineTimer;
    private TimerTask thingStatusOfflineTimerTask;
    private Map<String, Object> configProps = Collections.emptyMap();
    private RpcServerTransportProvider transportProvider;
    private final AtomicInteger singleThreadAssertCounter = new AtomicInteger();

    protected void activate(Map<String, Object> configProps) {
        int singleThreadAssertCounterValue = this.singleThreadAssertCounter.getAndIncrement();
        try {
            try {
                this.logger.debug("activate: Starting up RPC servlet at /intellihouse/RPC");
                if (singleThreadAssertCounterValue != 0) {
                    throw new IllegalStateException("singleThreadAssertCounterValue != 0");
                }
                this.configProps = Collections.unmodifiableMap(new HashMap<String, Object>(configProps));
                this.bundleContext = IntelliHouseActivator.getInstance().getBundleContext();
                this.rpcServiceServiceRegistryDelegate = new OsgiServiceRegistryDelegate<RpcService>(RpcService.class, this.bundleContext);
                ServiceRegistry.getInstance(RpcService.class).addDelegate(this.rpcServiceServiceRegistryDelegate);
                this.jaxbContextProviderServiceRegistryDelegate = new OsgiServiceRegistryDelegate<IntelliHouseJaxbContextProvider>(IntelliHouseJaxbContextProvider.class, this.bundleContext);
                ServiceRegistry.getInstance(IntelliHouseJaxbContextProvider.class).addDelegate(this.jaxbContextProviderServiceRegistryDelegate);
                this.rpcContext = new RpcContext(RpcContextMode.SERVER, this.getLocalHostId());
                this.rpcContextServiceRegistration = this.bundleContext.registerService(RpcContext.class, (Object)this.rpcContext, null);
                this.setupPgp();
                Hashtable props = new Hashtable();
                this.httpService.registerServlet("/intellihouse/RPC", (Servlet)this, props, this.createHttpContext());
                this.thingStatusOfflineTimer = new Timer("thingStatusOfflineTimer", true);
                this.thingStatusOfflineTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            RpcServlet.this.updateThingStatusOffline();
                        }
                        catch (Throwable x) {
                            RpcServlet.this.logger.error("thingStatusOfflineTimerTask.run: " + x, x);
                        }
                    }
                };
                this.thingStatusOfflineTimer.schedule(this.thingStatusOfflineTimerTask, 30000L, 30000L);
            }
            catch (Exception e) {
                this.logger.error("activate: " + e, (Throwable)e);
                this.singleThreadAssertCounter.decrementAndGet();
            }
        }
        finally {
            this.singleThreadAssertCounter.decrementAndGet();
        }
    }

    protected void modified(Map<String, Object> configProps) {
        int singleThreadAssertCounterValue = this.singleThreadAssertCounter.getAndIncrement();
        try {
            this.logger.debug("modified: New configuration for RPC servlet at /intellihouse/RPC");
            if (singleThreadAssertCounterValue != 0) {
                throw new IllegalStateException("singleThreadAssertCounterValue != 0");
            }
            this.configProps = Collections.unmodifiableMap(new HashMap<String, Object>(configProps));
            if (!Util.equal((Object)this.getLocalHostId(), this.rpcContext == null ? null : this.rpcContext.getLocalHostId())) {
                if (this.rpcContextServiceRegistration != null) {
                    this.rpcContextServiceRegistration.unregister();
                }
                this.rpcContext = new RpcContext(RpcContextMode.SERVER, this.getLocalHostId());
                this.rpcContextServiceRegistration = this.bundleContext.registerService(RpcContext.class, (Object)this.rpcContext, null);
            }
            this.setupPgp();
        }
        finally {
            this.singleThreadAssertCounter.decrementAndGet();
        }
    }

    private HostId getLocalHostId() {
        Object o = this.configProps.get(CONFIG_KEY_LOCAL_HOST_ID);
        String s = StringUtil.trim((String)(o == null ? null : o.toString()));
        if (StringUtil.isEmpty((String)s)) {
            return HostId.getLocalHostId();
        }
        return new HostId(s);
    }

    private void setupPgp() {
        try {
            StaticPgpAuthenticationCallback callback = new StaticPgpAuthenticationCallback();
            callback.setDefaultPassphrase(StringUtil.trim((String)String.valueOf(this.configProps.get(CONFIG_KEY_PGP_PASSPHRASE))));
            PgpRegistry.getInstance().setPgpAuthenticationCallback((PgpAuthenticationCallback)callback);
            this.logger.info("Pgp.class.identityHashCode={}", (Object)Integer.toHexString(System.identityHashCode(Pgp.class)));
            this.logger.info("Pgp.class.classLoader={}", (Object)Pgp.class.getClassLoader());
            this.logger.info("BcWithLocalGnuPgPgp.class.classLoader={}", (Object)BcWithLocalGnuPgPgp.class.getClassLoader());
            for (Class iface : ReflectionUtil.getAllInterfaces(BcWithLocalGnuPgPgp.class)) {
                this.logger.info("BcWithLocalGnuPgPgp.class.interfaces[{}].identityHashCode={}", (Object)iface.getName(), (Object)Integer.toHexString(System.identityHashCode(iface)));
                this.logger.info("BcWithLocalGnuPgPgp.class.interfaces[{}].classLoader={}", (Object)iface.getName(), (Object)iface.getClassLoader());
            }
            Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
            PgpTransportSupport support = new PgpTransportSupport();
            HostId localHostId = this.getLocalHostId();
            PgpKey masterKey = support.getMasterKeyOrFail(localHostId);
            if (!masterKey.isSecretKeyAvailable()) {
                throw new IllegalStateException(String.format("PGP key with id='%s' found for localHostId='%s' does not have a secret key available!", masterKey.getPgpKeyId().toHumanString(), localHostId));
            }
            pgp.setOwnerTrust(masterKey, PgpOwnerTrust.ULTIMATE);
            pgp.updateTrustDb();
        }
        catch (Throwable x) {
            this.logger.warn("setupPgp: " + x + ' ', x);
        }
    }

    protected void deactivate() {
        int singleThreadAssertCounterValue = this.singleThreadAssertCounter.getAndIncrement();
        try {
            try {
                if (singleThreadAssertCounterValue != 0) {
                    throw new IllegalStateException("singleThreadAssertCounterValue != 0");
                }
                if (this.thingStatusOfflineTimer != null) {
                    this.thingStatusOfflineTimer.cancel();
                }
                this.httpService.unregister("/intellihouse/RPC");
                if (this.rpcContextServiceRegistration != null) {
                    this.rpcContextServiceRegistration.unregister();
                }
                if (this.rpcServiceServiceRegistryDelegate != null) {
                    this.rpcServiceServiceRegistryDelegate.close();
                }
                if (this.jaxbContextProviderServiceRegistryDelegate != null) {
                    this.jaxbContextProviderServiceRegistryDelegate.close();
                }
                if (this.rpcContext != null) {
                    this.rpcContext.close();
                }
            }
            catch (Exception e) {
                this.logger.error("deactivate: " + e, (Throwable)e);
                this.singleThreadAssertCounter.decrementAndGet();
            }
        }
        finally {
            this.singleThreadAssertCounter.decrementAndGet();
        }
    }

    protected RpcContext getRpcContextOrFail() {
        RpcContext result = this.rpcContext;
        if (result == null) {
            throw new IllegalStateException("rpcContext == null :: activate() not called?!");
        }
        return result;
    }

    public void service(ServletRequest _req, ServletResponse _res) throws ServletException, IOException {
        block22: {
            HttpServletRequest req = (HttpServletRequest)_req;
            HttpServletResponse res = (HttpServletResponse)_res;
            if (METHOD_POST.equals(req.getMethod())) {
                Throwable throwable = null;
                Object var6_7 = null;
                try (RpcServer rpcServer = this.getRpcContextOrFail().createRpcServer();){
                    Throwable throwable2 = null;
                    Object var9_12 = null;
                    try (RpcServerTransport rst = this.createRpcServerTransport(req.getInputStream(), res.getOutputStream());){
                        rpcServer.receiveAndProcessRequest(rst);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    Request request = rpcServer.getRequest();
                    if (request != null) {
                        Date now = new Date();
                        ThingStatusInfo thingStatusInfo = new ThingStatusInfo(ThingStatus.ONLINE, ThingStatusDetail.NONE, null);
                        for (Thing thing : this.getThings(request.getClientHostId())) {
                            thing.getConfiguration().put("lastSeenDate", (Object)DateUtil.toString(now));
                            thing.getConfiguration().remove("maybeOfflineSinceDate");
                            if (this.isThingStatusConfigurationError(thing)) continue;
                            this.setThingStatus(thing, thingStatusInfo);
                        }
                    }
                    break block22;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            res.sendError(405, String.format("Method '%s' not supported! Please use 'POST' instead!", req.getMethod()));
        }
    }

    protected RpcServerTransport createRpcServerTransport(ServletInputStream inputStream, ServletOutputStream outputStream) {
        RpcServerTransportProvider transportProvider;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        Object tpcn = this.configProps.get(CONFIG_KEY_TRANSPORT);
        String transportProviderClassName = StringUtil.trim((String)(tpcn == null ? null : tpcn.toString()));
        if (StringUtil.isEmpty((String)transportProviderClassName)) {
            transportProviderClassName = HttpRpcServerTransportProvider.class.getName();
        }
        if ((transportProvider = this.getTransportProvider()) == null || !Util.equal((Object)transportProviderClassName, (Object)transportProvider.getClass().getName())) {
            Object service;
            ServiceReference serviceReference = this.bundleContext.getServiceReference(transportProviderClassName);
            Object object = service = serviceReference == null ? null : this.bundleContext.getService(serviceReference);
            if (service == null) {
                throw new IllegalStateException(String.format("The service of type %s configured by the config-key '%s' could not be found!", transportProviderClassName, CONFIG_KEY_TRANSPORT));
            }
            try {
                transportProvider = (RpcServerTransportProvider)service;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException(String.format("The service of type %s configured by the config-key '%s' does not implement the interface %s!", transportProviderClassName, CONFIG_KEY_TRANSPORT, RpcServerTransportProvider.class.getName()));
            }
            this.setTransportProvider(transportProvider);
        }
        transportProvider = transportProvider.clone();
        transportProvider.setRpcContext(this.getRpcContextOrFail());
        RpcServerTransport rpcServerTransport = transportProvider.createRpcServerTransport();
        if (rpcServerTransport instanceof ServletRpcServerTransport) {
            ServletRpcServerTransport transport = (ServletRpcServerTransport)rpcServerTransport;
            transport.setInputStream((InputStream)inputStream);
            transport.setOutputStream((OutputStream)outputStream);
        }
        return rpcServerTransport;
    }

    protected synchronized RpcServerTransportProvider getTransportProvider() {
        return this.transportProvider;
    }

    protected synchronized void setTransportProvider(RpcServerTransportProvider transportProvider) {
        this.transportProvider = transportProvider;
    }

    protected void updateThingStatusOffline() {
        long now = System.currentTimeMillis();
        for (Thing thing : this.thingRegistry.getAll()) {
            String hostIdStr = (String)thing.getConfiguration().get("hostId");
            Date lastSeenDate = DateUtil.toDate((String)thing.getConfiguration().get("lastSeenDate"));
            if (lastSeenDate != null) {
                if (now - lastSeenDate.getTime() <= 60000L || this.isThingStatusOffline(thing)) continue;
                ThingStatusInfo thingStatusInfo = new ThingStatusInfo(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, String.format("Host '%s' was last seen %2$tY-%2$tm-%2$td %2$tH:%2$tM:%2$tS %2$tZ.", hostIdStr, lastSeenDate));
                this.setThingStatus(thing, thingStatusInfo);
                continue;
            }
            Date maybeOfflineSinceDate = DateUtil.toDate((String)thing.getConfiguration().get("maybeOfflineSinceDate"));
            if (maybeOfflineSinceDate == null) {
                maybeOfflineSinceDate = new Date();
                thing.getConfiguration().put("maybeOfflineSinceDate", (Object)DateUtil.toString(maybeOfflineSinceDate));
                continue;
            }
            if (now - maybeOfflineSinceDate.getTime() <= 60000L || this.isThingStatusOffline(thing)) continue;
            ThingStatusInfo thingStatusInfo = new ThingStatusInfo(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, String.format("Host '%s' was never seen. It is offline at least since %2$tY-%2$tm-%2$td %2$tH:%2$tM:%2$tS %2$tZ.", hostIdStr, maybeOfflineSinceDate));
            this.setThingStatus(thing, thingStatusInfo);
        }
    }

    protected boolean isThingStatusOffline(Thing thing) {
        Objects.requireNonNull(thing, "thing");
        ThingStatusInfo statusInfo = Objects.requireNonNull(thing.getStatusInfo(), "thing.statusInfo");
        return ThingStatus.OFFLINE.equals((Object)statusInfo.getStatus());
    }

    protected boolean isThingStatusConfigurationError(Thing thing) {
        Objects.requireNonNull(thing, "thing");
        ThingStatusInfo statusInfo = Objects.requireNonNull(thing.getStatusInfo(), "thing.statusInfo");
        return ThingStatusDetail.CONFIGURATION_ERROR.equals((Object)statusInfo.getStatusDetail());
    }

    protected List<Thing> getThings(HostId hostId) {
        Objects.requireNonNull(hostId, "hostId");
        ArrayList<Thing> result = new ArrayList<Thing>();
        String hostIdStr = hostId.toString();
        for (Thing thing : this.thingRegistry.getAll()) {
            String hid = (String)thing.getConfiguration().get("hostId");
            if (!hostIdStr.equals(hid)) continue;
            result.add(thing);
        }
        return result;
    }

    protected void setThingStatus(Thing thing, ThingStatusInfo thingStatusInfo) {
        Objects.requireNonNull(thing, "thing");
        Objects.requireNonNull(thingStatusInfo, "thingStatusInfo");
        ThingStatusInfo oldStatusInfo = thing.getStatusInfo();
        thing.setStatusInfo(thingStatusInfo);
        try {
            this.eventPublisher.post((Event)ThingEventFactory.createStatusInfoEvent((ThingUID)thing.getUID(), (ThingStatusInfo)thingStatusInfo));
            if (!oldStatusInfo.equals((Object)thingStatusInfo)) {
                this.eventPublisher.post((Event)ThingEventFactory.createStatusInfoChangedEvent((ThingUID)thing.getUID(), (ThingStatusInfo)thingStatusInfo, (ThingStatusInfo)oldStatusInfo));
            }
        }
        catch (Exception ex) {
            this.logger.error("Could not post 'ThingStatusInfoEvent' event: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    public void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    public void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }
}

