/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.appid;

import co.codewizards.cloudstore.core.appid.AppId;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.ServiceLoader;

public class AppIdRegistry {
    private volatile AppId appId;

    public static AppIdRegistry getInstance() {
        return Holder.instance;
    }

    protected AppIdRegistry() {
    }

    public AppId getAppIdOrFail() {
        AppId appId = this.appId;
        if (appId == null) {
            for (AppId ai : ServiceLoader.load(AppId.class)) {
                if (appId != null && appId.getPriority() >= ai.getPriority()) continue;
                appId = ai;
            }
            if (appId == null) {
                throw new IllegalStateException("No AppId implementation found!");
            }
            this.appId = appId;
        }
        return appId;
    }

    public void copyResourceResolvingAppId(Reader reader, Writer writer) throws IOException {
        AssertUtil.assertNotNull("writer", writer);
        AssertUtil.assertNotNull("reader", reader);
        AppId appId = this.getAppIdOrFail();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("appId.simpleId", appId.getSimpleId());
        variables.put("appId.qualifiedId", appId.getQualifiedId());
        variables.put("appId.name", appId.getName());
        variables.put("appId.webSiteBaseUrl", appId.getWebSiteBaseUrl());
        IOUtil.replaceTemplateVariables(writer, reader, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyResourceResolvingAppId(Class<?> sourceResClass, String sourceResName, File destinationFile) throws IOException {
        InputStream source = null;
        OutputStream destination = null;
        try {
            source = sourceResClass.getResourceAsStream(sourceResName);
            if (source == null) {
                throw new FileNotFoundException("Class " + sourceResClass.getName() + " could not find resource " + sourceResName);
            }
            if (destinationFile.exists()) {
                if (!destinationFile.isFile()) throw new IOException("destination is not a file: " + destinationFile.getCanonicalPath());
                if (!destinationFile.canWrite()) {
                    throw new IOException("destination file is unwriteable: " + destinationFile.getCanonicalPath());
                }
            } else {
                File parentdir = destinationFile.getAbsoluteFile().getParentFile();
                if (parentdir == null || !parentdir.exists()) {
                    throw new IOException("destination's parent directory doesn't exist: " + destinationFile.getCanonicalPath());
                }
                if (!parentdir.canWrite()) {
                    throw new IOException("destination's parent directory is unwriteable: " + destinationFile.getCanonicalPath());
                }
            }
            destination = StreamUtil.castStream(destinationFile.createOutputStream());
            try (InputStreamReader r = new InputStreamReader(source);
                 OutputStreamWriter w = new OutputStreamWriter(destination);){
                this.copyResourceResolvingAppId(r, w);
                return;
            }
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final class Holder {
        public static final AppIdRegistry instance = new AppIdRegistry();

        private Holder() {
        }
    }
}

