/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.invitation.accept.source;

import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.client.LocalServerClient;
import co.codewizards.cloudstore.ls.client.util.ByteArrayInputStreamLs;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.file.EncryptedDataFile;
import org.subshare.core.pgp.ImportKeysResult;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.user.UserRegistry;
import org.subshare.gui.invitation.accept.source.AbstractProblemSolver;
import org.subshare.gui.invitation.accept.source.CheckInvitationFileResult;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.ls.UserRegistryLs;

public class ImportSigningKeyProblemSolver
extends AbstractProblemSolver {
    private static final Logger logger = LoggerFactory.getLogger(ImportSigningKeyProblemSolver.class);

    @Override
    public boolean canSolveProblem() {
        byte[] signingKeyData;
        if (this.getCheckInvitationFileResult().getType() != CheckInvitationFileResult.Type.SIGNING_KEY_MISSING) {
            return false;
        }
        try {
            signingKeyData = this.readSigningKeyData();
        }
        catch (Exception x) {
            logger.warn("readSigningKeyData failed: " + x, x);
            return false;
        }
        if (signingKeyData == null) {
            logger.warn("signingKeyData == null");
            return false;
        }
        if (signingKeyData.length < 1) {
            logger.warn("signingKeyData is empty");
            return false;
        }
        return true;
    }

    @Override
    public void solveProblem() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setHeaderText("Import the signing key?");
        String text = "The signing key can be imported from the invitation file, now.\n\nBut note: If you import it, it stays in your PGP key ring (and your user management),\neven if you abort accepting the invitation, afterwards.\n\nShall we import the signing key now?";
        Text contentText = new Text("The signing key can be imported from the invitation file, now.\n\nBut note: If you import it, it stays in your PGP key ring (and your user management),\neven if you abort accepting the invitation, afterwards.\n\nShall we import the signing key now?");
        HBox contentTextContainer = new HBox();
        contentTextContainer.getChildren().add((Object)contentText);
        GridPane.setMargin((Node)contentText, (Insets)new Insets(8.0));
        alert.getDialogPane().setContent((Node)contentTextContainer);
        alert.getButtonTypes().clear();
        alert.getButtonTypes().add((Object)ButtonType.YES);
        alert.getButtonTypes().add((Object)ButtonType.NO);
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.YES) {
            try {
                this.importSigningKey();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void importSigningKey() throws IOException {
        byte[] signingKeyData = this.readSigningKeyData();
        Pgp pgp = PgpLs.getPgpOrFail();
        UserRegistry userRegistry = UserRegistryLs.getUserRegistry();
        ImportKeysResult importKeysResult = pgp.importKeys((IInputStream)ByteArrayInputStreamLs.create((byte[])signingKeyData));
        HashMap<PgpKeyId, PgpKey> pgpKeyId2PgpKey = new HashMap<PgpKeyId, PgpKey>();
        for (ImportKeysResult.ImportedMasterKey importedMasterKey : importKeysResult.getPgpKeyId2ImportedMasterKey().values()) {
            PgpKeyId pgpKeyId = importedMasterKey.getPgpKeyId();
            PgpKey pgpKey = pgp.getPgpKey(pgpKeyId);
            AssertUtil.assertNotNull((String)("pgp.getPgpKey(" + pgpKeyId + ")"), (Object)pgpKey);
            pgpKeyId2PgpKey.put(pgpKeyId, pgpKey);
        }
        userRegistry.importUsersFromPgpKeys(pgpKeyId2PgpKey.values());
    }

    private byte[] readSigningKeyData() throws IOException {
        LocalServerClient lsc = LocalServerClient.getInstance();
        Pgp pgp = PgpLs.getPgpOrFail();
        try (InputStream in = StreamUtil.castStream((IInputStream)this.getInvitationFile().createInputStream());){
            EncryptedDataFile encryptedDataFile = new EncryptedDataFile(in);
            Object bout = lsc.invokeConstructor(ByteArrayOutputStream.class, new Object[0]);
            Object bin = lsc.invokeConstructor(ByteArrayInputStream.class, new Object[]{encryptedDataFile.getSigningKeyData()});
            PgpDecoder pgpDecoder = (PgpDecoder)lsc.invoke((Object)pgp, "createDecoder", new Object[]{bin, bout});
            try {
                pgpDecoder.decode();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] signingKeyData = (byte[])lsc.invoke(bout, "toByteArray", new Object[0]);
            AssertUtil.assertNotNull((String)"signingKeyData", (Object)signingKeyData);
            byte[] byArray = signingKeyData;
            return byArray;
        }
    }
}

