/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.localrepo.directory;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.ObservableSet;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.listener.LocalRepoCommitEventListener;
import org.subshare.core.repo.listener.LocalRepoCommitEventManager;
import org.subshare.core.repo.listener.WeakLocalRepoCommitEventListener;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.gui.localrepo.directory.PermissionTypeItem;
import org.subshare.gui.localrepo.directory.UserListItem;
import org.subshare.gui.ls.LocalRepoCommitEventManagerLs;
import org.subshare.gui.ls.LocalRepoManagerFactoryLs;
import org.subshare.gui.ls.UserRegistryLs;
import org.subshare.gui.statusdialog.StatusDialog;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;

public abstract class SecurityPane
extends GridPane {
    private final LocalRepo localRepo;
    private final File file;
    private final String localPath;
    @FXML
    private CheckBox permissionsInheritedCheckBox;
    @FXML
    private TableView<UserListItem> userTableView;
    @FXML
    private Label permissionTypeLabel;
    @FXML
    private ComboBox<PermissionTypeItem> permissionTypeComboBox;
    @FXML
    private CheckBox readUserIdentityPermissionCheckBox;
    private boolean ignorePermissionTypeSelectionChange;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private volatile Runnable updatePermissionsInheritedDataModelRunnable;
    private volatile Runnable grantOrRevokeNormalPermissionRunnable;
    private volatile Runnable grantOrRevokeReadUserIdentityPermissionRunnable;
    private final IntegerProperty backgroundWorkCounter = new SimpleIntegerProperty((Object)this, "backgroundWorkCounter");
    private SecureRandom random;
    private StatusDialog statusDialog;
    private final LocalRepoCommitEventListener localRepoCommitEventListener = event -> {
        if (!event.getModifications().isEmpty()) {
            this.scheduleDeferredUpdateUiTimerTask();
        }
    };
    private final WeakLocalRepoCommitEventListener weakLocalRepoCommitEventListener;
    private static final Timer deferredUpdateUiTimer = new Timer(true);
    private TimerTask deferredUpdateUiTimerTask;
    private Window window;

    public SecurityPane(LocalRepo localRepo, File file) {
        this.localRepo = (LocalRepo)AssertUtil.assertNotNull((String)"localRepo", (Object)localRepo);
        this.file = (File)AssertUtil.assertNotNull((String)"file", (Object)file);
        this.localPath = localRepo.getLocalPath(this.file);
        FxmlUtil.loadDynamicComponentFxml(SecurityPane.class, this);
        this.userTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.userTableView.getSelectionModel().getSelectedItems().addListener(observable -> this.onUserTableViewSelectionChange());
        this.backgroundWorkCounter.addListener(observable -> this.showOrHideStatusDialog());
        this.initPermissionTypeComboBox();
        this.hookListeners();
        this.updateUi();
        this.onUserTableViewSelectionChange();
        UUID localRepositoryId = localRepo.getRepositoryId();
        LocalRepoCommitEventManager localRepoCommitEventManager = LocalRepoCommitEventManagerLs.getLocalRepoCommitEventManager();
        this.weakLocalRepoCommitEventListener = new WeakLocalRepoCommitEventListener(localRepoCommitEventManager, localRepositoryId, this.localRepoCommitEventListener);
        this.weakLocalRepoCommitEventListener.addLocalRepoCommitEventListener();
        this.sceneProperty().addListener(observable -> {
            Scene scene = this.getScene();
            if (scene != null) {
                this.window = scene.getWindow();
            }
        });
    }

    protected abstract void startSync();

    private synchronized void scheduleDeferredUpdateUiTimerTask() {
        if (this.deferredUpdateUiTimerTask != null) {
            this.deferredUpdateUiTimerTask.cancel();
            this.deferredUpdateUiTimerTask = null;
        }
        this.deferredUpdateUiTimerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SecurityPane securityPane = SecurityPane.this;
                synchronized (securityPane) {
                    SecurityPane.this.deferredUpdateUiTimerTask = null;
                }
                Platform.runLater(() -> SecurityPane.this.updateUi());
            }
        };
        deferredUpdateUiTimer.schedule(this.deferredUpdateUiTimerTask, 500L);
    }

    private void showOrHideStatusDialog() {
        if (this.backgroundWorkCounter.get() > 0) {
            this.showStatusDialog();
        } else {
            this.hideStatusDialog();
        }
    }

    private void showStatusDialog() {
        if (this.statusDialog == null) {
            this.statusDialog = new StatusDialog((Window)AssertUtil.assertNotNull((String)"window", (Object)this.window), Modality.APPLICATION_MODAL, null, null);
            this.statusDialog.show();
        }
    }

    private void hideStatusDialog() {
        if (this.statusDialog != null) {
            this.statusDialog.hide();
            this.statusDialog = null;
        }
    }

    private void initPermissionTypeComboBox() {
        this.permissionTypeComboBox.getItems().add((Object)PermissionTypeItem.NONE);
        for (PermissionType permissionType : PermissionType.values()) {
            if (PermissionType.readUserIdentity == permissionType) continue;
            this.permissionTypeComboBox.getItems().add((Object)new PermissionTypeItem(permissionType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUserTableViewSelectionChange() {
        this.ignorePermissionTypeSelectionChange = true;
        try {
            this.permissionTypeComboBox.getItems().remove((Object)PermissionTypeItem.MIXED);
            List<UserListItem> userListItems = this.filterOutOwner((List<UserListItem>)this.userTableView.getSelectionModel().getSelectedItems());
            this.permissionTypeLabel.setDisable(userListItems.isEmpty());
            this.permissionTypeComboBox.setDisable(userListItems.isEmpty());
            this.readUserIdentityPermissionCheckBox.setDisable(userListItems.isEmpty());
            if (userListItems.isEmpty()) {
                this.permissionTypeComboBox.getSelectionModel().clearSelection();
                this.readUserIdentityPermissionCheckBox.setIndeterminate(true);
                return;
            }
            if (userListItems.size() > 1) {
                this.permissionTypeComboBox.getItems().add((Object)PermissionTypeItem.MIXED);
            }
            HashSet<Boolean> allUsersReadUserIdentityPermissionTypes = new HashSet<Boolean>();
            HashSet<ObservableSet<PermissionType>> allUsersGrantedPermissionTypes = new HashSet<ObservableSet<PermissionType>>();
            for (UserListItem userListItem : userListItems) {
                Object grantedPermissionTypes = userListItem.getGrantedPermissionTypes();
                allUsersReadUserIdentityPermissionTypes.add(grantedPermissionTypes.contains(PermissionType.readUserIdentity));
                grantedPermissionTypes = this.filterOutReadUserIdentity((Set<PermissionType>)grantedPermissionTypes);
                allUsersGrantedPermissionTypes.add((ObservableSet<PermissionType>)grantedPermissionTypes);
            }
            if (allUsersReadUserIdentityPermissionTypes.isEmpty()) {
                throw new IllegalStateException("WTF?!");
            }
            if (allUsersGrantedPermissionTypes.isEmpty()) {
                throw new IllegalStateException("WTF?!");
            }
            if (allUsersReadUserIdentityPermissionTypes.size() == 1) {
                this.readUserIdentityPermissionCheckBox.setIndeterminate(false);
                this.readUserIdentityPermissionCheckBox.setSelected(((Boolean)allUsersReadUserIdentityPermissionTypes.iterator().next()).booleanValue());
            } else {
                this.readUserIdentityPermissionCheckBox.setIndeterminate(true);
            }
            if (allUsersGrantedPermissionTypes.size() == 1) {
                this.permissionTypeComboBox.getSelectionModel().clearSelection();
                PermissionTypeItem permissionTypeItem = this.getPermissionTypeItem((Set)allUsersGrantedPermissionTypes.iterator().next());
                this.permissionTypeComboBox.getSelectionModel().select((Object)permissionTypeItem);
            } else {
                this.permissionTypeComboBox.getSelectionModel().clearSelection();
                this.permissionTypeComboBox.getSelectionModel().select((Object)PermissionTypeItem.MIXED);
            }
        }
        finally {
            this.ignorePermissionTypeSelectionChange = false;
        }
    }

    private Set<PermissionType> filterOutReadUserIdentity(Set<PermissionType> permissionTypes) {
        AssertUtil.assertNotNull((String)"permissionTypes", permissionTypes);
        EnumSet<PermissionType> result = permissionTypes.isEmpty() ? EnumSet.noneOf(PermissionType.class) : EnumSet.copyOf(permissionTypes);
        result.remove(PermissionType.readUserIdentity);
        return result;
    }

    private PermissionTypeItem getPermissionTypeItem(Set<PermissionType> permissionTypes) {
        if (permissionTypes.isEmpty()) {
            return PermissionTypeItem.NONE;
        }
        if (permissionTypes.contains(PermissionType.grant)) {
            return this.getPermissionTypeItem(PermissionType.grant);
        }
        if (permissionTypes.contains(PermissionType.write)) {
            return this.getPermissionTypeItem(PermissionType.write);
        }
        if (permissionTypes.contains(PermissionType.read)) {
            return this.getPermissionTypeItem(PermissionType.read);
        }
        throw new IllegalStateException("permissionTypes neither contains the expected content, nor is it empty: " + permissionTypes);
    }

    private PermissionTypeItem getPermissionTypeItem(PermissionType permissionType) {
        for (PermissionTypeItem permissionTypeItem : this.permissionTypeComboBox.getItems()) {
            if (permissionTypeItem.getPermissionType() != permissionType) continue;
            return permissionTypeItem;
        }
        return null;
    }

    private List<UserListItem> filterOutOwner(List<UserListItem> userListItems) {
        AssertUtil.assertNotNull((String)"userListItems", userListItems);
        ArrayList<UserListItem> result = new ArrayList<UserListItem>(userListItems.size());
        for (UserListItem userListItem : userListItems) {
            if (userListItem.isOwner()) continue;
            result.add(userListItem);
        }
        return result;
    }

    protected void onPermissionTypeComboBoxSelectionChange() {
        Runnable runnable;
        PlatformUtil.assertFxApplicationThread();
        if (this.ignorePermissionTypeSelectionChange) {
            return;
        }
        final PermissionTypeItem permissionTypeItem = (PermissionTypeItem)this.permissionTypeComboBox.getSelectionModel().getSelectedItem();
        if (PermissionTypeItem.MIXED == permissionTypeItem) {
            return;
        }
        final List<User> users = this.getSelectedUsers();
        this.grantOrRevokeNormalPermissionRunnable = runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SecurityPane.this.incBackgroundWorkCounter();
                try {
                    if (SecurityPane.this.grantOrRevokeNormalPermissionRunnable != this) {
                        return;
                    }
                    try (LocalRepoManager localRepoManager = SecurityPane.this.createLocalRepoManager(SecurityPane.this.localRepo);){
                        SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                        SecurityPane.this.applySelectedPermissionTypeItem(localRepoManager, localRepoMetaData, users, permissionTypeItem);
                    }
                    Platform.runLater(() -> SecurityPane.this.updateUi());
                }
                finally {
                    SecurityPane.this.decBackgroundWorkCounter();
                }
            }
        };
        this.executorService.execute(runnable);
    }

    protected List<User> getSelectedUsers() {
        PlatformUtil.assertFxApplicationThread();
        ArrayList<User> result = new ArrayList<User>();
        for (UserListItem userListItem : this.userTableView.getSelectionModel().getSelectedItems()) {
            result.add(userListItem.getUser());
        }
        return result;
    }

    protected void onReadUserIdentityPermissionCheckBoxChange() {
        Runnable runnable;
        PlatformUtil.assertFxApplicationThread();
        if (this.ignorePermissionTypeSelectionChange) {
            return;
        }
        if (this.readUserIdentityPermissionCheckBox.isIndeterminate()) {
            return;
        }
        final List<User> users = this.getSelectedUsers();
        final boolean readUserIdentityPermissionIsGranted = this.readUserIdentityPermissionCheckBox.isSelected();
        this.grantOrRevokeReadUserIdentityPermissionRunnable = runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SecurityPane.this.incBackgroundWorkCounter();
                try {
                    if (SecurityPane.this.grantOrRevokeReadUserIdentityPermissionRunnable != this) {
                        return;
                    }
                    try (LocalRepoManager localRepoManager = SecurityPane.this.createLocalRepoManager(SecurityPane.this.localRepo);){
                        SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                        SecurityPane.this.applyReadUserIdentityPermission(localRepoManager, localRepoMetaData, users, readUserIdentityPermissionIsGranted);
                    }
                    Platform.runLater(() -> SecurityPane.this.updateUi());
                }
                finally {
                    SecurityPane.this.decBackgroundWorkCounter();
                }
            }
        };
        this.executorService.execute(runnable);
    }

    protected void applySelectedPermissionTypeItem(LocalRepoManager localRepoManager, SsLocalRepoMetaData localRepoMetaData, List<User> users, PermissionTypeItem permissionTypeItem) {
        if (PermissionTypeItem.NONE == permissionTypeItem) {
            this.revokePermission(localRepoManager, localRepoMetaData, PermissionType.read, users);
            return;
        }
        PermissionType permissionType = (PermissionType)AssertUtil.assertNotNull((String)"permissionTypeItem.permissionType", (Object)permissionTypeItem.getPermissionType());
        Set<PermissionType> includedPermissionTypes = this.filterOutReadUserIdentity(permissionType.getIncludedPermissionTypes());
        UUID serverRepositoryId = this.getServerRepositoryId(localRepoManager);
        boolean needSync = false;
        for (User user : users) {
            Set<Uid> userRepoKeyIds = this.getUserRepoKeyIds(user, serverRepositoryId);
            EnumSet<PermissionType> permissionTypesToRevoke = EnumSet.noneOf(PermissionType.class);
            boolean needGrant = true;
            for (Uid userRepoKeyId : userRepoKeyIds) {
                Set<PermissionType> grantedPermissionTypes = this.filterOutReadUserIdentity(localRepoMetaData.getGrantedPermissionTypes(this.localPath, userRepoKeyId));
                if (grantedPermissionTypes.contains(permissionType)) {
                    needGrant = false;
                }
                for (PermissionType pt : grantedPermissionTypes) {
                    if (includedPermissionTypes.contains(pt)) continue;
                    permissionTypesToRevoke.add(pt);
                }
            }
            if (needGrant) {
                needSync = true;
                for (UserRepoKey.PublicKey publicKey : this.getUserRepoKeyPublicKeysForGrant(localRepoManager, user)) {
                    localRepoMetaData.grantPermission(this.localPath, permissionType, publicKey);
                }
            }
            for (PermissionType permissionTypeToRevoke : permissionTypesToRevoke) {
                needSync = true;
                localRepoMetaData.revokePermission(this.localPath, permissionTypeToRevoke, userRepoKeyIds);
            }
        }
        if (needSync) {
            this.startSync();
        }
    }

    protected void applyReadUserIdentityPermission(LocalRepoManager localRepoManager, SsLocalRepoMetaData localRepoMetaData, List<User> users, boolean readUserIdentityPermissionIsGranted) {
        if (readUserIdentityPermissionIsGranted) {
            this.grantReadUserIdentityPermission(localRepoManager, localRepoMetaData, users);
        } else {
            this.revokePermission(localRepoManager, localRepoMetaData, PermissionType.readUserIdentity, users);
        }
    }

    protected void grantReadUserIdentityPermission(LocalRepoManager localRepoManager, SsLocalRepoMetaData localRepoMetaData, List<User> users) {
        UUID serverRepositoryId = this.getServerRepositoryId(localRepoManager);
        block0: for (User user : users) {
            for (Uid userRepoKeyId : this.getUserRepoKeyIds(user, serverRepositoryId)) {
                Set grantedPermissionTypes = localRepoMetaData.getGrantedPermissionTypes(this.localPath, userRepoKeyId);
                if (!grantedPermissionTypes.contains(PermissionType.readUserIdentity)) continue;
                continue block0;
            }
            for (UserRepoKey.PublicKey publicKey : this.getUserRepoKeyPublicKeysForGrant(localRepoManager, user)) {
                localRepoMetaData.grantPermission(this.localPath, PermissionType.readUserIdentity, publicKey);
            }
        }
        this.startSync();
    }

    protected Collection<UserRepoKey.PublicKey> getUserRepoKeyPublicKeysForGrant(LocalRepoManager localRepoManager, User user) {
        UUID serverRepositoryId = this.getServerRepositoryId(localRepoManager);
        ArrayList<Object> permanentUserRepoKeyPublicKeys = new ArrayList<Object>();
        ArrayList<UserRepoKey.PublicKey> invitationUserRepoKeyPublicKeys = new ArrayList<UserRepoKey.PublicKey>();
        if (user.getUserRepoKeyRing() == null) {
            Iterator userRepoKeyPublicKeys = user.getUserRepoKeyPublicKeys(serverRepositoryId);
            Iterator iterator = userRepoKeyPublicKeys.iterator();
            while (iterator.hasNext()) {
                UserRepoKey.PublicKey publicKey = (UserRepoKey.PublicKey)iterator.next();
                if (publicKey.isInvitation()) {
                    invitationUserRepoKeyPublicKeys.add(publicKey);
                    continue;
                }
                permanentUserRepoKeyPublicKeys.add(publicKey);
            }
        } else {
            for (UserRepoKey userRepoKey : user.getUserRepoKeyRing().getPermanentUserRepoKeys(serverRepositoryId)) {
                permanentUserRepoKeyPublicKeys.add(userRepoKey.getPublicKey());
            }
            for (UserRepoKey userRepoKey : user.getUserRepoKeyRing().getInvitationUserRepoKeys(serverRepositoryId)) {
                invitationUserRepoKeyPublicKeys.add((UserRepoKey.PublicKey)userRepoKey.getPublicKey());
            }
        }
        if (!permanentUserRepoKeyPublicKeys.isEmpty()) {
            int index = this.getRandom().nextInt(permanentUserRepoKeyPublicKeys.size());
            return Collections.singletonList(permanentUserRepoKeyPublicKeys.get(index));
        }
        if (invitationUserRepoKeyPublicKeys.isEmpty()) {
            throw new IllegalStateException("Neither permanent nor invitation-key found!");
        }
        return invitationUserRepoKeyPublicKeys;
    }

    protected void revokePermission(LocalRepoManager localRepoManager, SsLocalRepoMetaData localRepoMetaData, PermissionType permissionType, List<User> users) {
        UUID serverRepositoryId = this.getServerRepositoryId(localRepoManager);
        HashSet<Uid> userRepoKeyIds = new HashSet<Uid>();
        for (User user : users) {
            for (Uid userRepoKeyId : this.getUserRepoKeyIds(user, serverRepositoryId)) {
                userRepoKeyIds.add(userRepoKeyId);
            }
        }
        localRepoMetaData.revokePermission(this.localPath, permissionType, userRepoKeyIds);
        this.startSync();
    }

    protected void hookListeners() {
        this.permissionsInheritedCheckBox.selectedProperty().addListener(observable -> this.updatePermissionsInheritedDataModel());
        this.permissionTypeComboBox.getSelectionModel().selectedItemProperty().addListener(observable -> this.onPermissionTypeComboBoxSelectionChange());
        InvalidationListener invalidationListener = InvalidationListener2 -> this.onReadUserIdentityPermissionCheckBoxChange();
        this.readUserIdentityPermissionCheckBox.indeterminateProperty().addListener(invalidationListener);
        this.readUserIdentityPermissionCheckBox.selectedProperty().addListener(invalidationListener);
    }

    protected void updateUi() {
        this.updatePermissionsInheritedCheckBox();
        this.loadUserListItems();
    }

    protected void updatePermissionsInheritedCheckBox() {
        PlatformUtil.assertFxApplicationThread();
        this.executorService.execute(() -> {
            this.incBackgroundWorkCounter();
            try (LocalRepoManager localRepoManager = this.createLocalRepoManager(this.localRepo);){
                SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                boolean permissionsInherited = localRepoMetaData.isPermissionsInherited(this.localPath);
                Platform.runLater(() -> this.permissionsInheritedCheckBox.setSelected(permissionsInherited));
            }
            finally {
                this.decBackgroundWorkCounter();
            }
        });
    }

    protected void loadUserListItems() {
        PlatformUtil.assertFxApplicationThread();
        this.executorService.execute(() -> {
            this.incBackgroundWorkCounter();
            try (LocalRepoManager localRepoManager = this.createLocalRepoManager(this.localRepo);){
                SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                Map<User, Set<Uid>> user2UserRepoKeyIds = this.getUsersHavingUserRepoKey(localRepoManager);
                ArrayList<UserListItem> userListItems = new ArrayList<UserListItem>();
                for (Map.Entry<User, Set<Uid>> me : user2UserRepoKeyIds.entrySet()) {
                    User user = me.getKey();
                    Set<Uid> userRepoKeyIds = me.getValue();
                    try {
                        UserListItem uli = new UserListItem(user);
                        uli.getUserRepoKeyIds().addAll(userRepoKeyIds);
                        if (userRepoKeyIds.contains(localRepoMetaData.getOwnerUserRepoKeyId())) {
                            uli.setOwner(true);
                        } else {
                            for (Uid userRepoKeyId : userRepoKeyIds) {
                                Set pts = localRepoMetaData.getGrantedPermissionTypes(this.localPath, userRepoKeyId);
                                uli.getGrantedPermissionTypes().addAll((Collection)pts);
                                pts = localRepoMetaData.getEffectivePermissionTypes(this.localPath, userRepoKeyId);
                                uli.getEffectivePermissionTypes().addAll((Collection)pts);
                                pts = localRepoMetaData.getInheritedPermissionTypes(this.localPath, userRepoKeyId);
                                uli.getInheritedPermissionTypes().addAll((Collection)pts);
                            }
                        }
                        userListItems.add(uli);
                    }
                    catch (Exception x) {
                        throw new RuntimeException("Failed to load permissions for user " + user + " (userRepoKeyIds=" + userRepoKeyIds + "): " + x, x);
                    }
                }
                Platform.runLater(() -> this.addOrUpdateUserListItems(userListItems));
            }
            finally {
                this.decBackgroundWorkCounter();
            }
        });
    }

    protected void addOrUpdateUserListItems(List<UserListItem> userListItems) {
        AssertUtil.assertNotNull((String)"userListItems", userListItems);
        IdentityHashMap<User, UserListItem> user2UserListItemModel = new IdentityHashMap<User, UserListItem>();
        for (UserListItem userListItem : userListItems) {
            user2UserListItemModel.put(userListItem.getUser(), userListItem);
        }
        ArrayList<UserListItem> userListItemsToRemove = new ArrayList<UserListItem>();
        IdentityHashMap<User, UserListItem> user2UserListItemView = new IdentityHashMap<User, UserListItem>();
        for (UserListItem userListItem : this.userTableView.getItems()) {
            user2UserListItemView.put(userListItem.getUser(), userListItem);
            if (user2UserListItemModel.containsKey(userListItem.getUser())) continue;
            userListItemsToRemove.add(userListItem);
        }
        this.userTableView.getItems().removeAll(userListItemsToRemove);
        for (UserListItem userListItemModel : userListItems) {
            UserListItem userListItemView = (UserListItem)user2UserListItemView.get(userListItemModel.getUser());
            if (userListItemView == null) {
                this.userTableView.getItems().add((Object)userListItemModel);
                continue;
            }
            userListItemView.copyFrom(userListItemModel);
        }
        this.onUserTableViewSelectionChange();
    }

    private Map<User, Set<Uid>> getUsersHavingUserRepoKey(LocalRepoManager localRepoManager) {
        UUID serverRepositoryId = this.getServerRepositoryId(localRepoManager);
        LinkedHashMap<User, Set<Uid>> result = new LinkedHashMap<User, Set<Uid>>();
        for (User user : UserRegistryLs.getUserRegistry().getUsers()) {
            Set<Uid> userRepoKeyIds = this.getUserRepoKeyIds(user, serverRepositoryId);
            if (userRepoKeyIds.isEmpty()) continue;
            result.put(user, userRepoKeyIds);
        }
        return result;
    }

    private Set<Uid> getUserRepoKeyIds(User user, UUID serverRepositoryId) {
        UserRepoKeyRing userRepoKeyRing = user.getUserRepoKeyRing();
        HashSet<Uid> userRepoKeyIds = new HashSet<Uid>();
        if (userRepoKeyRing != null) {
            List userRepoKeys = userRepoKeyRing.getUserRepoKeys(serverRepositoryId);
            for (UserRepoKey userRepoKey : userRepoKeys) {
                userRepoKeyIds.add(userRepoKey.getUserRepoKeyId());
            }
        } else {
            List userRepoKeyPublicKeys = user.getUserRepoKeyPublicKeys(serverRepositoryId);
            for (UserRepoKey.PublicKeyWithSignature publicKey : userRepoKeyPublicKeys) {
                userRepoKeyIds.add(publicKey.getUserRepoKeyId());
            }
        }
        return userRepoKeyIds;
    }

    private UUID getServerRepositoryId(LocalRepoManager localRepoManager) {
        AssertUtil.assertNotNull((String)"localRepoManager", (Object)localRepoManager);
        Map remoteRepositoryId2RemoteRootMap = localRepoManager.getRemoteRepositoryId2RemoteRootMap();
        Iterator iterator = remoteRepositoryId2RemoteRootMap.keySet().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("remoteRepositoryId2RemoteRootMap is empty!");
        }
        UUID result = (UUID)iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException("remoteRepositoryId2RemoteRootMap contains more than 1 entry!");
        }
        return result;
    }

    private void incBackgroundWorkCounter() {
        Platform.runLater(() -> this.backgroundWorkCounter.set(this.backgroundWorkCounter.get() + 1));
    }

    private void decBackgroundWorkCounter() {
        Platform.runLater(() -> {
            int newValue = this.backgroundWorkCounter.get() - 1;
            if (newValue < 0) {
                throw new IllegalStateException("backgroundWorkCounter cannot become negative!");
            }
            this.backgroundWorkCounter.set(newValue);
            if (newValue == 0) {
                this.updatePermissionsInheritedDataModelRunnable = null;
                this.grantOrRevokeNormalPermissionRunnable = null;
                this.grantOrRevokeReadUserIdentityPermissionRunnable = null;
            }
        });
    }

    private void updatePermissionsInheritedDataModel() {
        Runnable runnable;
        PlatformUtil.assertFxApplicationThread();
        final boolean newInherited = this.permissionsInheritedCheckBox.isSelected();
        this.updatePermissionsInheritedDataModelRunnable = runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SecurityPane.this.incBackgroundWorkCounter();
                try {
                    if (SecurityPane.this.updatePermissionsInheritedDataModelRunnable != this) {
                        return;
                    }
                    try (LocalRepoManager localRepoManager = SecurityPane.this.createLocalRepoManager(SecurityPane.this.localRepo);){
                        SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                        localRepoMetaData.setPermissionsInherited(SecurityPane.this.localPath, newInherited);
                    }
                    Platform.runLater(() -> SecurityPane.this.updateUi());
                }
                finally {
                    SecurityPane.this.decBackgroundWorkCounter();
                }
            }
        };
        this.executorService.execute(runnable);
    }

    private LocalRepoManager createLocalRepoManager(LocalRepo localRepo) {
        return LocalRepoManagerFactoryLs.getLocalRepoManagerFactory().createLocalRepoManagerForExistingRepository(localRepo.getLocalRoot());
    }

    public synchronized SecureRandom getRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }
}

