/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.createkey.validity;

import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeListener;
import java.util.function.UnaryOperator;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import org.subshare.core.pgp.CreatePgpKeyParam;
import org.subshare.gui.pgp.createkey.TimeUnit;
import org.subshare.gui.pgp.createkey.validity.Messages;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class ValidityPane
extends WizardPageContentGridPane {
    private final CreatePgpKeyParam createPgpKeyParam;
    @FXML
    private Spinner<Integer> validityNumberSpinner;
    @FXML
    private ComboBox<TimeUnit> validityTimeUnitComboBox;
    private boolean ignoreUpdateValidity;
    private final PropertyChangeListener validitySecondsPropertyChangeListener = event -> PlatformUtil.runAndWait(() -> this.updateValidityNumberSpinner());
    private StringConverter<TimeUnit> timeUnitStringConverter = new StringConverter<TimeUnit>(){

        public String toString(TimeUnit timeUnit) {
            return Messages.getString(String.format("ValidityPane.TimeUnit[%s]", new Object[]{timeUnit}));
        }

        public TimeUnit fromString(String string) {
            throw new UnsupportedOperationException();
        }
    };

    public ValidityPane(CreatePgpKeyParam createPgpKeyParam) {
        this.createPgpKeyParam = (CreatePgpKeyParam)AssertUtil.assertNotNull((String)"createPgpKeyParam", (Object)createPgpKeyParam);
        FxmlUtil.loadDynamicComponentFxml(ValidityPane.class, this);
        this.validityNumberSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, Integer.MAX_VALUE));
        this.validityNumberSpinner.valueProperty().addListener(observable -> {
            this.updateValiditySeconds();
            this.updateComplete();
        });
        this.validityNumberSpinner.getEditor().setTextFormatter(new TextFormatter((UnaryOperator)new UnaryOperator<TextFormatter.Change>(){

            @Override
            public TextFormatter.Change apply(TextFormatter.Change change) {
                String text = change.getControlNewText();
                try {
                    Integer.parseInt(text);
                }
                catch (NumberFormatException x) {
                    return null;
                }
                return change;
            }
        }));
        this.validityTimeUnitComboBox.setItems(FXCollections.observableArrayList((Object[])new TimeUnit[]{TimeUnit.YEAR, TimeUnit.MONTH, TimeUnit.DAY}));
        this.validityTimeUnitComboBox.setConverter(this.timeUnitStringConverter);
        this.validityTimeUnitComboBox.getSelectionModel().clearAndSelect(0);
        this.validityTimeUnitComboBox.valueProperty().addListener(observable -> this.updateValiditySeconds());
        createPgpKeyParam.addPropertyChangeListener((PropertyBase)CreatePgpKeyParam.PropertyEnum.validitySeconds, this.validitySecondsPropertyChangeListener);
        this.updateValidityNumberSpinner();
        this.updateComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValidityNumberSpinner() {
        if (this.ignoreUpdateValidity) {
            return;
        }
        this.ignoreUpdateValidity = true;
        try {
            long remainder;
            long validitySeconds = this.createPgpKeyParam.getValiditySeconds();
            TimeUnit timeUnit = (TimeUnit)((Object)this.validityTimeUnitComboBox.getValue());
            do {
                if ((remainder = validitySeconds % timeUnit.getSeconds()) == 0L) continue;
                if (timeUnit.ordinal() + 1 >= TimeUnit.values().length) break;
                timeUnit = TimeUnit.values()[timeUnit.ordinal() + 1];
            } while (remainder != 0L);
            this.validityTimeUnitComboBox.setValue((Object)timeUnit);
            long validityNumber = validitySeconds / timeUnit.getSeconds();
            if (remainder != 0L) {
                ++validityNumber;
            }
            this.validityNumberSpinner.getValueFactory().setValue((Object)((int)validityNumber));
            if (remainder != 0L) {
                this.createPgpKeyParam.setValiditySeconds(validityNumber * timeUnit.getSeconds());
            }
        }
        finally {
            this.ignoreUpdateValidity = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValiditySeconds() {
        if (this.ignoreUpdateValidity) {
            return;
        }
        this.ignoreUpdateValidity = true;
        try {
            Integer validityNumber = (Integer)this.validityNumberSpinner.getValue();
            if (validityNumber == null) {
                return;
            }
            long seconds = validityNumber.longValue() * ((TimeUnit)((Object)this.validityTimeUnitComboBox.getValue())).getSeconds();
            this.createPgpKeyParam.setValiditySeconds(seconds);
        }
        finally {
            this.ignoreUpdateValidity = false;
        }
    }

    @Override
    protected boolean isComplete() {
        boolean complete = this.validityNumberSpinner.getValue() != null;
        return complete;
    }

    public void requestFocus() {
        super.requestFocus();
        this.validityNumberSpinner.requestFocus();
    }
}

