/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.server;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.ServerRepoRegistry;
import org.subshare.core.server.Server;
import org.subshare.gui.checkout.CheckOutWizard;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.createrepo.CreateRepoData;
import org.subshare.gui.createrepo.CreateRepoWizard;
import org.subshare.gui.ls.ServerRepoRegistryLs;
import org.subshare.gui.server.ServerRepoListItem;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;
import org.subshare.gui.wizard.WizardDialog;

public class ServerPane
extends GridPane {
    private ServerRepoRegistry serverRepoRegistry;
    private final Server server;
    @FXML
    private Button createRepositoryButton;
    @FXML
    private Button checkOutButton;
    @FXML
    private TableView<ServerRepoListItem> tableView;
    private final ListChangeListener<ServerRepoListItem> selectionListener = new ListChangeListener<ServerRepoListItem>(){

        public void onChanged(ListChangeListener.Change<? extends ServerRepoListItem> c) {
            ServerPane.this.updateEnabled();
        }
    };
    private PropertyChangeListener serverReposPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ArrayList serverRepos = new ArrayList((List)evt.getNewValue());
            Iterator it = serverRepos.iterator();
            while (it.hasNext()) {
                if (ServerPane.this.server.getServerId().equals((Object)((ServerRepo)it.next()).getServerId())) continue;
                it.remove();
            }
            Platform.runLater(() -> ServerPane.this.addOrRemoveItemTablesViewCallback(serverRepos));
        }
    };

    public ServerPane(Server server) {
        this.server = (Server)AssertUtil.assertNotNull((String)"server", (Object)server);
        FxmlUtil.loadDynamicComponentFxml(ServerPane.class, this);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.getSelectionModel().getSelectedItems().addListener(this.selectionListener);
        for (TableColumn tableColumn : this.tableView.getColumns()) {
            if (!"nameColumn".equals(tableColumn.getId())) continue;
            TableColumn tc = (TableColumn)Util.cast((Object)tableColumn);
            tc.setCellFactory((Callback)Util.cast((Object)TextFieldTableCell.forTableColumn()));
        }
        this.populateTableViewAsync();
        this.updateEnabled();
    }

    private void addOrRemoveItemTablesViewCallback(Collection<ServerRepo> serverRepos) {
        PlatformUtil.assertFxApplicationThread();
        HashSet<ServerRepo> modelRepos = new HashSet<ServerRepo>(serverRepos);
        HashMap<ServerRepo, ServerRepoListItem> viewRepo2ServerRepoListItem = new HashMap<ServerRepo, ServerRepoListItem>();
        for (ServerRepoListItem sli : this.tableView.getItems()) {
            viewRepo2ServerRepoListItem.put(sli.getServerRepo(), sli);
        }
        for (ServerRepo serverRepo : serverRepos) {
            if (viewRepo2ServerRepoListItem.containsKey(serverRepo)) continue;
            ServerRepoListItem sli = new ServerRepoListItem(serverRepo);
            viewRepo2ServerRepoListItem.put(serverRepo, sli);
            this.tableView.getItems().add((Object)sli);
        }
        if (modelRepos.size() < viewRepo2ServerRepoListItem.size()) {
            for (ServerRepo serverRepo : modelRepos) {
                viewRepo2ServerRepoListItem.remove(serverRepo);
            }
            for (ServerRepoListItem sli : viewRepo2ServerRepoListItem.values()) {
                this.tableView.getItems().remove((Object)sli);
            }
        }
    }

    private void addTableItemsViewCallback(Collection<ServerRepo> serverRepos) {
        for (ServerRepo serverRepo : serverRepos) {
            this.tableView.getItems().add((Object)new ServerRepoListItem(serverRepo));
        }
        this.tableView.requestLayout();
    }

    private void updateEnabled() {
        int selectionCount = this.tableView.getSelectionModel().getSelectedItems().size();
        this.checkOutButton.setDisable(selectionCount != 1);
    }

    private void populateTableViewAsync() {
        new Service<Collection<ServerRepo>>(){

            protected Task<Collection<ServerRepo>> createTask() {
                return new SsTask<Collection<ServerRepo>>(){

                    protected Collection<ServerRepo> call() throws Exception {
                        return ServerPane.this.getServerRepoRegistry().getServerReposOfServer(ServerPane.this.server.getServerId());
                    }

                    protected void succeeded() {
                        Collection serverRepos;
                        try {
                            serverRepos = (Collection)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        ServerPane.this.addTableItemsViewCallback(serverRepos);
                    }
                };
            }
        }.start();
    }

    protected ServerRepoRegistry getServerRepoRegistry() {
        if (this.serverRepoRegistry == null) {
            this.serverRepoRegistry = ServerRepoRegistryLs.getServerRepoRegistry();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.serverRepoRegistry, (PropertyBase)ServerRepoRegistry.PropertyEnum.serverRepos, (PropertyChangeListener)this.serverReposPropertyChangeListener);
        }
        return this.serverRepoRegistry;
    }

    @FXML
    private void createRepositoryButtonClicked(ActionEvent event) {
        CreateRepoData createRepoData = new CreateRepoData(this.server);
        CreateRepoWizard wizard = new CreateRepoWizard(createRepoData);
        WizardDialog dialog = new WizardDialog(this.getScene().getWindow(), wizard);
        dialog.show();
    }

    @FXML
    private void checkOutButtonClicked(ActionEvent event) {
        ServerRepoListItem serverRepoListItem = (ServerRepoListItem)this.tableView.getSelectionModel().getSelectedItems().get(0);
        ServerRepo serverRepo = serverRepoListItem.getServerRepo();
        new CheckOutWizard(this.server, serverRepo).checkOut(this.getScene().getWindow());
    }

    @FXML
    private void syncButtonClicked(ActionEvent event) {
        for (ServerRepoListItem item : this.tableView.getSelectionModel().getSelectedItems()) {
            item.getServerRepo().getRepositoryId();
        }
    }
}

