/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.userlist;

import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpKeyValidity;
import org.subshare.core.pgp.PgpOwnerTrust;
import org.subshare.core.user.User;
import org.subshare.gui.ls.PgpLs;

public class UserListItem {
    private final User user;
    private Pgp pgp;
    private final StringProperty firstName = new SimpleStringProperty((Object)this, "firstName");
    private final StringProperty lastName = new SimpleStringProperty((Object)this, "lastName");
    private final StringProperty email = new SimpleStringProperty((Object)this, "email");
    private final StringProperty keyValidityProperty = new SimpleStringProperty((Object)this, "keyValidity");
    private final StringProperty ownerTrustProperty = new SimpleStringProperty((Object)this, "ownerTrust");
    private volatile List<String> emails;
    private volatile String keyValidity;
    private volatile String ownerTrust;
    private final PropertyChangeListener userPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Platform.runLater(() -> {
                UserListItem.this.emails = null;
                UserListItem.this.copyDataFromUser();
            });
        }
    };
    private final PropertyChangeListener pgpPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Platform.runLater(() -> {
                UserListItem.this.keyValidity = null;
                UserListItem.this.ownerTrust = null;
                UserListItem.this.copyDataFromPgp();
            });
        }
    };

    public UserListItem(User user) {
        this.user = (User)AssertUtil.assertNotNull((String)"user", (Object)user);
        PropertyChangeListenerUtil.addWeakPropertyChangeListener((Object)user, (PropertyChangeListener)this.userPropertyChangeListener);
        this.copyDataFromUser();
        this.copyDataFromPgp();
    }

    protected synchronized Pgp getPgp() {
        if (this.pgp == null) {
            this.pgp = PgpLs.getPgpOrFail();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Object)this.pgp, (PropertyChangeListener)this.pgpPropertyChangeListener);
        }
        return this.pgp;
    }

    protected void copyDataFromUser() {
        this.firstName.set((Object)this.user.getFirstName());
        this.lastName.set((Object)this.user.getLastName());
        this.email.set((Object)this.getEmail());
    }

    protected void copyDataFromPgp() {
        this.keyValidityProperty.set((Object)this.getKeyValidity());
        this.ownerTrustProperty.set((Object)this.getOwnerTrust());
    }

    public User getUser() {
        return this.user;
    }

    public StringProperty firstNameProperty() {
        return this.firstName;
    }

    public String getFirstName() {
        return (String)this.firstName.get();
    }

    public StringProperty lastNameProperty() {
        return this.lastName;
    }

    public String getLastName() {
        return (String)this.lastName.get();
    }

    public StringProperty emailProperty() {
        return this.email;
    }

    public StringProperty keyValidityProperty() {
        return this.keyValidityProperty;
    }

    public StringProperty ownerTrustProperty() {
        return this.ownerTrustProperty;
    }

    public List<String> getEmails() {
        List<String> emails = this.emails;
        if (emails == null) {
            this.emails = emails = new ArrayList<String>(((User)AssertUtil.assertNotNull((String)"user", (Object)this.user)).getEmails());
        }
        return emails;
    }

    private String getEmail() {
        if (this.getEmails().isEmpty()) {
            return null;
        }
        String firstEmail = this.getEmails().get(0);
        if (this.user.getEmails().size() == 1) {
            return firstEmail;
        }
        return String.format("%s (%s more)", firstEmail, this.user.getEmails().size() - 1);
    }

    public String getKeyValidity() {
        String keyValidity = this.keyValidity;
        if (keyValidity == null) {
            TreeSet keyValidities = new TreeSet(Collections.reverseOrder());
            for (PgpKeyId pgpKeyId : this.user.getPgpKeyIds()) {
                PgpKey pgpKey = this.getPgp().getPgpKey(pgpKeyId);
                if (pgpKey == null) continue;
                PgpKeyValidity v = this.getPgp().getKeyValidity(pgpKey);
                keyValidities.add(v);
            }
            StringBuilder sb = new StringBuilder();
            for (PgpKeyValidity kv : keyValidities) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(kv.toShortString());
            }
            this.keyValidity = keyValidity = sb.toString();
        }
        return keyValidity;
    }

    public String getOwnerTrust() {
        String ownerTrust = this.ownerTrust;
        if (ownerTrust == null) {
            TreeSet ownerTrusts = new TreeSet(Collections.reverseOrder());
            for (PgpKeyId pgpKeyId : this.user.getPgpKeyIds()) {
                PgpKey pgpKey = this.getPgp().getPgpKey(pgpKeyId);
                if (pgpKey == null) continue;
                PgpOwnerTrust ot = this.getPgp().getOwnerTrust(pgpKey);
                ownerTrusts.add(ot);
            }
            StringBuilder sb = new StringBuilder();
            for (PgpOwnerTrust ot : ownerTrusts) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(ot.toShortString());
            }
            this.ownerTrust = ownerTrust = sb.toString();
        }
        return ownerTrust;
    }

    public boolean matchesFilter(String filterText) {
        if (filterText.isEmpty()) {
            return true;
        }
        String firstName = (String)this.firstName.get();
        if (firstName != null && firstName.toLowerCase().contains(filterText)) {
            return true;
        }
        String lastName = (String)this.lastName.get();
        if (lastName != null && lastName.toLowerCase().contains(filterText)) {
            return true;
        }
        for (String email : this.getEmails()) {
            if (!email.toLowerCase().contains(filterText)) continue;
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

