/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.welcome.server;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.property.adapter.JavaBeanObjectPropertyBuilder;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import org.subshare.core.server.Server;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.UrlStringConverter;
import org.subshare.gui.welcome.ServerData;
import org.subshare.gui.wizard.WizardPageContentGridPane;

public class ServerPane
extends WizardPageContentGridPane {
    private final PropertyChangeListener updateCompletePropertyChangeListener = event -> Platform.runLater(() -> this.updateComplete());
    private final InvalidationListener updateCompleteInvalidationListener = observable -> this.updateComplete();
    private final ServerData serverData;
    private final Server server;
    @FXML
    private Label urlLabel;
    @FXML
    private TextField urlTextField;
    private final ObjectProperty<URL> url;
    @FXML
    private Label nameLabel;
    @FXML
    private TextField nameTextField;
    private final StringProperty name;
    @FXML
    private CheckBox acceptInvitationCheckBox;

    public ServerPane(ServerData serverData) {
        this.serverData = (ServerData)AssertUtil.assertNotNull((String)"serverData", (Object)serverData);
        this.server = (Server)AssertUtil.assertNotNull((String)"serverData.server", (Object)serverData.getServer());
        FxmlUtil.loadDynamicComponentFxml(ServerPane.class, this);
        try {
            this.url = JavaBeanObjectPropertyBuilder.create().bean((Object)this.server).name(Server.PropertyEnum.url.name()).build();
            this.name = JavaBeanStringPropertyBuilder.create().bean((Object)this.server).name(Server.PropertyEnum.name.name()).build();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.urlTextField.textProperty().bindBidirectional(this.url, (StringConverter)new UrlStringConverter());
        this.nameTextField.textProperty().bindBidirectional((Property)this.name);
        this.acceptInvitationCheckBox.selectedProperty().bindBidirectional((Property)serverData.acceptInvitationProperty());
        this.nameLabel.disableProperty().bind((ObservableValue)this.acceptInvitationCheckBox.selectedProperty());
        this.nameTextField.disableProperty().bind((ObservableValue)this.acceptInvitationCheckBox.selectedProperty());
        this.urlLabel.disableProperty().bind((ObservableValue)this.acceptInvitationCheckBox.selectedProperty());
        this.urlTextField.disableProperty().bind((ObservableValue)this.acceptInvitationCheckBox.selectedProperty());
        PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.server, (PropertyBase)Server.PropertyEnum.url, (PropertyChangeListener)this.updateCompletePropertyChangeListener);
        serverData.acceptInvitationProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateCompleteInvalidationListener));
        this.updateComplete();
    }

    @Override
    protected boolean isComplete() {
        if (this.serverData.acceptInvitationProperty().get()) {
            return true;
        }
        URL url = this.server.getUrl();
        return url != null;
    }
}

