/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoMetaData;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.dto.RepoFileDtoConverter;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.util.ArrayList;
import java.util.List;

public class LocalRepoMetaDataImpl
implements LocalRepoMetaData {
    private LocalRepoManager localRepoManager;

    protected LocalRepoManager getLocalRepoManager() {
        return this.localRepoManager;
    }

    protected LocalRepoManager getLocalRepoManagerOrFail() {
        return (LocalRepoManager)AssertUtil.assertNotNull((String)"localRepoManager", (Object)this.localRepoManager);
    }

    protected void setLocalRepoManager(LocalRepoManager localRepoManager) {
        this.localRepoManager = localRepoManager;
    }

    protected LocalRepoTransaction beginReadTransaction() {
        return this.getLocalRepoManagerOrFail().beginReadTransaction();
    }

    protected LocalRepoTransaction beginWriteTransaction() {
        return this.getLocalRepoManagerOrFail().beginWriteTransaction();
    }

    public RepoFileDto getRepoFileDto(String path, int depth) {
        RepoFileDto result;
        AssertUtil.assertNotNull((String)"path", (Object)path);
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            RepoFileDtoConverter converter = RepoFileDtoConverter.create(tx);
            File localRoot = this.getLocalRepoManagerOrFail().getLocalRoot();
            File file = OioFileFactory.createFile((File)localRoot, (String[])new String[]{path});
            RepoFile repoFile = ((RepoFileDao)tx.getDao(RepoFileDao.class)).getRepoFile(localRoot, file);
            result = repoFile == null ? null : converter.toRepoFileDto(repoFile, depth);
            tx.commit();
        }
        return result;
    }

    public RepoFileDto getRepoFileDto(long repoFileId, int depth) {
        RepoFileDto result;
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            RepoFileDtoConverter converter = RepoFileDtoConverter.create(tx);
            RepoFile repoFile = (RepoFile)((RepoFileDao)tx.getDao(RepoFileDao.class)).getObjectByIdOrNull(repoFileId);
            result = repoFile == null ? null : converter.toRepoFileDto(repoFile, depth);
            tx.commit();
        }
        return result;
    }

    public List<RepoFileDto> getChildRepoFileDtos(long repoFileId, int depth) {
        List<RepoFileDto> result;
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            RepoFile repoFile = (RepoFile)((RepoFileDao)tx.getDao(RepoFileDao.class)).getObjectByIdOrNull(repoFileId);
            result = this.getChildRepoFileDtos(tx, repoFile, depth);
            tx.commit();
        }
        return result;
    }

    public List<RepoFileDto> getChildRepoFileDtos(String path, int depth) {
        List<RepoFileDto> result;
        try (LocalRepoTransaction tx = this.beginReadTransaction();){
            File localRoot = this.getLocalRepoManagerOrFail().getLocalRoot();
            File file = OioFileFactory.createFile((File)localRoot, (String[])new String[]{path});
            RepoFile repoFile = ((RepoFileDao)tx.getDao(RepoFileDao.class)).getRepoFile(localRoot, file);
            result = this.getChildRepoFileDtos(tx, repoFile, depth);
            tx.commit();
        }
        return result;
    }

    private List<RepoFileDto> getChildRepoFileDtos(LocalRepoTransaction tx, RepoFile repoFile, int depth) {
        if (repoFile == null) {
            return null;
        }
        RepoFileDao repoFileDao = (RepoFileDao)tx.getDao(RepoFileDao.class);
        RepoFileDtoConverter converter = RepoFileDtoConverter.create(tx);
        ArrayList<RepoFileDto> result = new ArrayList<RepoFileDto>();
        for (RepoFile childRepoFile : repoFileDao.getChildRepoFiles(repoFile)) {
            RepoFileDto dto = converter.toRepoFileDto(childRepoFile, depth);
            result.add(dto);
        }
        return result;
    }
}

