/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRef;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxy;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxyFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteObjectProxyManager {
    private static final Logger logger = LoggerFactory.getLogger(RemoteObjectProxyManager.class);
    private final Map<ObjectRef, WeakReference<RemoteObjectProxy>> objectRef2RemoteObjectProxyRef = new HashMap<ObjectRef, WeakReference<RemoteObjectProxy>>();
    private final Map<WeakReference<RemoteObjectProxy>, ObjectRef> remoteObjectProxyRef2ObjectRef = new IdentityHashMap<WeakReference<RemoteObjectProxy>, ObjectRef>();
    private final ReferenceQueue<RemoteObjectProxy> referenceQueue = new ReferenceQueue();

    protected RemoteObjectProxyManager() {
        if (logger.isDebugEnabled()) {
            logger.debug("[{}]<init>", (Object)this.getThisId());
        }
    }

    public synchronized RemoteObjectProxy getRemoteObjectProxy(ObjectRef objectRef) {
        AssertUtil.assertNotNull((String)"objectRef", (Object)objectRef);
        WeakReference<RemoteObjectProxy> remoteObjectProxyRef = this.objectRef2RemoteObjectProxyRef.get(objectRef);
        RemoteObjectProxy remoteObjectProxy = remoteObjectProxyRef == null ? null : (RemoteObjectProxy)remoteObjectProxyRef.get();
        this.evictOrphanedObjectRefs();
        return remoteObjectProxy;
    }

    public synchronized RemoteObjectProxy getRemoteObjectProxyOrCreate(ObjectRef objectRef, RemoteObjectProxyFactory remoteObjectProxyFactory) {
        RemoteObjectProxy remoteObjectProxy;
        AssertUtil.assertNotNull((String)"objectRef", (Object)objectRef);
        AssertUtil.assertNotNull((String)"remoteObjectProxyFactory", (Object)remoteObjectProxyFactory);
        WeakReference<RemoteObjectProxy> remoteObjectProxyRef = this.objectRef2RemoteObjectProxyRef.get(objectRef);
        RemoteObjectProxy remoteObjectProxy2 = remoteObjectProxy = remoteObjectProxyRef == null ? null : (RemoteObjectProxy)remoteObjectProxyRef.get();
        if (remoteObjectProxy == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("[{}]getRemoteObjectProxy: Creating proxy for {}. remoteObjectProxyRef={}", new Object[]{this.getThisId(), objectRef, remoteObjectProxyRef});
            }
            remoteObjectProxy = remoteObjectProxyFactory.createRemoteObjectProxy(objectRef);
            AssertUtil.assertNotNull((String)"remoteObjectProxyFactory.createRemoteObjectProxy(objectRef)", (Object)remoteObjectProxy);
            WeakReference<RemoteObjectProxy> reference = new WeakReference<RemoteObjectProxy>(remoteObjectProxy, this.referenceQueue);
            this.objectRef2RemoteObjectProxyRef.put(objectRef, reference);
            this.remoteObjectProxyRef2ObjectRef.put(reference, objectRef);
        }
        this.evictOrphanedObjectRefs();
        return remoteObjectProxy;
    }

    private String getThisId() {
        return Integer.toHexString(System.identityHashCode(this));
    }

    private synchronized void evictOrphanedObjectRefs() {
        Reference<RemoteObjectProxy> reference;
        while (null != (reference = this.referenceQueue.poll())) {
            ObjectRef objectRef = this.remoteObjectProxyRef2ObjectRef.remove(reference);
            this.objectRef2RemoteObjectProxyRef.remove(objectRef);
        }
    }
}

