/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.sign.WriteProtected;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.core.user.UserRepoKeyRingLookup;
import org.subshare.core.user.UserRepoKeyRingLookupContext;
import org.subshare.local.CryptreeImpl;
import org.subshare.local.persistence.Collision;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.HistoCryptoRepoFileDao;
import org.subshare.local.persistence.ScheduledReuploadDao;
import org.subshare.local.persistence.SsRemoteRepository;

public class DuplicateCryptoRepoFileHandler {
    private static final Logger logger = LoggerFactory.getLogger(DuplicateCryptoRepoFileHandler.class);
    private final LocalRepoTransaction transaction;
    private final Cryptree cryptree;
    private CryptoRepoFile cryptoRepoFileActive;
    private CryptoRepoFile cryptoRepoFileDead;

    public static DuplicateCryptoRepoFileHandler createInstance(LocalRepoTransaction transaction) {
        AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        return (DuplicateCryptoRepoFileHandler)ObjectFactoryUtil.createObject(DuplicateCryptoRepoFileHandler.class, (Object[])new Object[]{transaction});
    }

    protected DuplicateCryptoRepoFileHandler(LocalRepoTransaction transaction) {
        this.transaction = (LocalRepoTransaction)AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        this.cryptree = this._getCryptree();
    }

    public LocalRepoTransaction getTransaction() {
        return this.transaction;
    }

    public void associateCryptoRepoFileWithRepoFile(RepoFile repoFile, CryptoRepoFile cryptoRepoFile) {
        AssertUtil.assertNotNull((String)"repoFile", (Object)repoFile);
        AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)cryptoRepoFile));
        CryptoRepoFile cryptoRepoFile2 = ((CryptoRepoFileDao)((Object)this.transaction.getDao(CryptoRepoFileDao.class))).getCryptoRepoFile(repoFile);
        if (cryptoRepoFile2 != null && !cryptoRepoFile2.equals((Object)cryptoRepoFile)) {
            cryptoRepoFile = this.deduplicate(cryptoRepoFile, cryptoRepoFile2);
        }
        if (cryptoRepoFile != null) {
            cryptoRepoFile.setRepoFile(repoFile);
        }
    }

    protected CryptoRepoFile deduplicate(CryptoRepoFile cryptoRepoFile1, CryptoRepoFile cryptoRepoFile2) {
        this.assignCryptoRepoFiles(cryptoRepoFile1, cryptoRepoFile2);
        CryptoRepoFile result = this.deduplicate();
        return result;
    }

    protected void assignCryptoRepoFiles(CryptoRepoFile cryptoRepoFile1, CryptoRepoFile cryptoRepoFile2) {
        AssertUtil.assertNotNull((String)"cryptoRepoFile1", (Object)((Object)cryptoRepoFile1));
        AssertUtil.assertNotNull((String)"cryptoRepoFile2", (Object)((Object)cryptoRepoFile2));
        this.assignCryptoRepoFileCreatedIfNeeded(cryptoRepoFile1);
        this.assignCryptoRepoFileCreatedIfNeeded(cryptoRepoFile2);
        int compared = DuplicateCryptoRepoFileHandler.compare(cryptoRepoFile1, cryptoRepoFile2);
        if (compared < 0) {
            this.cryptoRepoFileActive = cryptoRepoFile1;
            this.cryptoRepoFileDead = cryptoRepoFile2;
        } else if (compared > 0) {
            this.cryptoRepoFileActive = cryptoRepoFile2;
            this.cryptoRepoFileDead = cryptoRepoFile1;
        } else {
            throw new IllegalArgumentException("cryptoRepoFile1 == cryptoRepoFile2");
        }
    }

    protected CryptoRepoFile deduplicate() {
        AssertUtil.assertNotNull((String)"cryptoRepoFileActive", (Object)((Object)this.cryptoRepoFileActive));
        AssertUtil.assertNotNull((String)"cryptoRepoFileDead", (Object)((Object)this.cryptoRepoFileDead));
        logger.debug("deduplicate: cryptoRepoFileActive={} cryptoRepoFileDead={}", (Object)this.cryptoRepoFileActive, (Object)this.cryptoRepoFileDead);
        HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)((Object)this.transaction.getDao(HistoCryptoRepoFileDao.class));
        Collection<HistoCryptoRepoFile> histoCryptoRepoFiles = hcrfDao.getHistoCryptoRepoFiles(this.cryptoRepoFileActive);
        if (histoCryptoRepoFiles.isEmpty()) {
            logger.warn("deduplicate: cryptoRepoFileActive={} does not yet have any HistoCryptoRepoFile associated! Must postpone this operation!", (Object)this.cryptoRepoFileActive);
            return null;
        }
        RepoFile repoFile = this.cryptoRepoFileActive.getRepoFile();
        if (repoFile == null) {
            repoFile = this.cryptoRepoFileDead.getRepoFile();
        }
        ((RepoFile)AssertUtil.assertNotNull((String)"repoFile", (Object)repoFile)).setLocalRevision(this.transaction.getLocalRevision());
        this.cryptoRepoFileDead.setRepoFile(null);
        this.transaction.flush();
        Collision collision = ((CryptreeImpl)this.cryptree).createCollisionIfNeeded(this.cryptoRepoFileActive, this.cryptoRepoFileDead, null, true);
        this.deduplicateFromCollisionIfNeeded(collision);
        this.transaction.flush();
        return (CryptoRepoFile)((Object)AssertUtil.assertNotNull((String)"cryptoRepoFileActive", (Object)((Object)this.cryptoRepoFileActive)));
    }

    public void deduplicateFromCollisionIfNeeded(Collision collision) {
        AssertUtil.assertNotNull((String)"collision", (Object)((Object)collision));
        if (collision.getDuplicateCryptoRepoFileId() == null) {
            return;
        }
        CryptoRepoFileDao crfDao = (CryptoRepoFileDao)((Object)this.transaction.getDao(CryptoRepoFileDao.class));
        this.cryptoRepoFileActive = collision.getHistoCryptoRepoFile1().getCryptoRepoFile();
        this.cryptoRepoFileDead = crfDao.getCryptoRepoFile(collision.getDuplicateCryptoRepoFileId());
        if (this.cryptoRepoFileDead == null) {
            return;
        }
        logger.debug("deduplicateFromCollisionIfNeeded: cryptoRepoFileActive={} cryptoRepoFileDead={}", (Object)this.cryptoRepoFileActive, (Object)this.cryptoRepoFileDead);
        if (this.cryptree.getUserRepoKeyRing() != null) {
            Collection<CryptoRepoFile> children = crfDao.getChildCryptoRepoFiles(this.cryptoRepoFileDead);
            for (CryptoRepoFile child : children) {
                child.setParent(this.cryptoRepoFileActive);
                this.cryptree.sign((WriteProtected)child);
            }
            RepoFile repoFile = this.cryptoRepoFileDead.getRepoFile();
            if (repoFile != null) {
                ((ScheduledReuploadDao)((Object)this.transaction.getDao(ScheduledReuploadDao.class))).scheduleReupload(repoFile);
            }
        }
        crfDao.deletePersistent(this.cryptoRepoFileDead);
        this.cryptoRepoFileDead = null;
        this.transaction.flush();
    }

    private void assignCryptoRepoFileCreatedIfNeeded(CryptoRepoFile cryptoRepoFile) {
        AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)cryptoRepoFile));
        if (cryptoRepoFile.getCryptoRepoFileCreated() != null) {
            return;
        }
        HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)((Object)this.getTransaction().getDao(HistoCryptoRepoFileDao.class));
        Collection<HistoCryptoRepoFile> histoCryptoRepoFiles = hcrfDao.getHistoCryptoRepoFiles(cryptoRepoFile);
        Date cryptoRepoFileCreated = null;
        for (HistoCryptoRepoFile histoCryptoRepoFile : histoCryptoRepoFiles) {
            if (cryptoRepoFileCreated != null && !cryptoRepoFileCreated.after(histoCryptoRepoFile.getSignature().getSignatureCreated())) continue;
            cryptoRepoFileCreated = histoCryptoRepoFile.getSignature().getSignatureCreated();
        }
        AssertUtil.assertNotNull((String)"cryptoRepoFileCreated", cryptoRepoFileCreated);
        cryptoRepoFile.setCryptoRepoFileCreated(cryptoRepoFileCreated);
        this._getCryptree().sign((WriteProtected)cryptoRepoFile);
    }

    private static int compare(CryptoRepoFile cryptoRepoFile1, CryptoRepoFile cryptoRepoFile2) {
        AssertUtil.assertNotNull((String)"cryptoRepoFile1", (Object)((Object)cryptoRepoFile1));
        AssertUtil.assertNotNull((String)"cryptoRepoFile2", (Object)((Object)cryptoRepoFile2));
        Date cryptoRepoFileCreated1 = (Date)AssertUtil.assertNotNull((String)("cryptoRepoFile1.cryptoRepoFileCreated [cryptoRepoFileId=" + cryptoRepoFile1.getCryptoRepoFileId() + "]"), (Object)cryptoRepoFile1.getCryptoRepoFileCreated());
        Date cryptoRepoFileCreated2 = (Date)AssertUtil.assertNotNull((String)("cryptoRepoFile2.cryptoRepoFileCreated [cryptoRepoFileId=" + cryptoRepoFile2.getCryptoRepoFileId() + "]"), (Object)cryptoRepoFile2.getCryptoRepoFileCreated());
        int result = cryptoRepoFileCreated1.compareTo(cryptoRepoFileCreated2);
        if (result != 0) {
            return result;
        }
        result = cryptoRepoFile1.getCryptoRepoFileId().compareTo(cryptoRepoFile2.getCryptoRepoFileId());
        return result;
    }

    private Cryptree _getCryptree() {
        Cryptree cryptree = (Cryptree)this.transaction.getContextObject(Cryptree.class);
        if (cryptree == null) {
            UUID localRepositoryId = this.transaction.getLocalRepoManager().getRepositoryId();
            RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)this.transaction.getDao(RemoteRepositoryDao.class);
            Map remoteRepositoryId2RemoteRootMap = remoteRepositoryDao.getRemoteRepositoryId2RemoteRootMap();
            if (remoteRepositoryId2RemoteRootMap.size() != 1) {
                throw new IllegalStateException("Not exactly one remote repository! size=" + remoteRepositoryId2RemoteRootMap.size());
            }
            UUID remoteRepositoryId = (UUID)remoteRepositoryId2RemoteRootMap.keySet().iterator().next();
            SsRemoteRepository remoteRepository = (SsRemoteRepository)remoteRepositoryDao.getRemoteRepositoryOrFail(remoteRepositoryId);
            String remotePathPrefix = remoteRepository.getRemotePathPrefix();
            AssertUtil.assertNotNull((String)"remoteRepository.remotePathPrefix", (Object)remotePathPrefix);
            UserRepoKeyRing userRepoKeyRing = UserRepoKeyRingLookup.Helper.getUserRepoKeyRingLookup().getUserRepoKeyRing(new UserRepoKeyRingLookupContext(localRepositoryId, remoteRepositoryId));
            cryptree = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail().getCryptreeOrCreate(this.transaction, remoteRepositoryId, remotePathPrefix, userRepoKeyRing);
        }
        return cryptree;
    }
}

