/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.util.AssertUtil;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.KeyParameter;
import org.subshare.core.dto.CryptoKeyPart;
import org.subshare.crypto.CryptoRegistry;
import org.subshare.local.persistence.CryptoKey;

public class PlainCryptoKey {
    private final CryptoKey cryptoKey;
    private final CryptoKeyPart cryptoKeyPart;
    private final CipherParameters cipherParameters;

    public PlainCryptoKey(CryptoKey cryptoKey, CryptoKeyPart cryptoKeyPart, CipherParameters cipherParameters) {
        this.cryptoKey = (CryptoKey)((Object)AssertUtil.assertNotNull((String)"cryptoKey", (Object)((Object)cryptoKey)));
        this.cryptoKeyPart = (CryptoKeyPart)AssertUtil.assertNotNull((String)"cryptoKeyPart", (Object)cryptoKeyPart);
        this.cipherParameters = (CipherParameters)AssertUtil.assertNotNull((String)"cipherParameters", (Object)cipherParameters);
        switch (cryptoKeyPart) {
            case privateKey: 
            case publicKey: {
                if (cipherParameters instanceof AsymmetricKeyParameter) break;
                throw new IllegalArgumentException("cryptoKeyPart indicates asymmetric cryptography, but cipherParameters is not an instance of AsymmetricKeyParameter!");
            }
            case sharedSecret: {
                if (cipherParameters instanceof KeyParameter) break;
                throw new IllegalArgumentException("cryptoKeyPart indicates symmetric cryptography, but cipherParameters is not an instance of KeyParameter!");
            }
            default: {
                throw new IllegalArgumentException("Unknown cryptoKeyPart: " + cryptoKeyPart);
            }
        }
    }

    public PlainCryptoKey(CryptoKey cryptoKey, CryptoKeyPart cryptoKeyPart, byte[] encoded) {
        this(cryptoKey, cryptoKeyPart, PlainCryptoKey.getDecodedKey(cryptoKeyPart, encoded));
    }

    private static CipherParameters getDecodedKey(CryptoKeyPart cryptoKeyPart, byte[] encoded) {
        try {
            switch (cryptoKeyPart) {
                case privateKey: {
                    return CryptoRegistry.getInstance().decodePrivateKey(encoded);
                }
                case publicKey: {
                    return CryptoRegistry.getInstance().decodePublicKey(encoded);
                }
                case sharedSecret: {
                    return new KeyParameter(encoded);
                }
            }
            throw new IllegalArgumentException("Unknown cryptoKeyPart: " + cryptoKeyPart);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public CryptoKey getCryptoKey() {
        return this.cryptoKey;
    }

    public CryptoKeyPart getCryptoKeyPart() {
        return this.cryptoKeyPart;
    }

    public CipherParameters getCipherParameters() {
        return this.cipherParameters;
    }

    public KeyParameter getKeyParameterOrFail() {
        if (CryptoKeyPart.sharedSecret != this.cryptoKeyPart) {
            throw new IllegalStateException("This is not a shared secret! this.cryptoKeyPart=" + this.cryptoKeyPart);
        }
        if (this.cipherParameters instanceof KeyParameter) {
            return (KeyParameter)this.cipherParameters;
        }
        throw new IllegalStateException("cipherParameters is not an instance of KeyParameter!");
    }

    public AsymmetricKeyParameter getPublicKeyParameterOrFail() {
        if (CryptoKeyPart.publicKey != this.cryptoKeyPart) {
            throw new IllegalStateException("This is not a public key! this.cryptoKeyPart=" + this.cryptoKeyPart);
        }
        if (this.cipherParameters instanceof AsymmetricKeyParameter) {
            return (AsymmetricKeyParameter)this.cipherParameters;
        }
        throw new IllegalStateException("cipherParameters is not an instance of AsymmetricKeyParameter!");
    }

    public AsymmetricKeyParameter getPrivateKeyParameterOrFail() {
        if (CryptoKeyPart.privateKey != this.cryptoKeyPart) {
            throw new IllegalStateException("This is not a private key! this.cryptoKeyPart=" + this.cryptoKeyPart);
        }
        if (this.cipherParameters instanceof AsymmetricKeyParameter) {
            return (AsymmetricKeyParameter)this.cipherParameters;
        }
        throw new IllegalStateException("cipherParameters is not an instance of AsymmetricKeyParameter!");
    }

    public byte[] getEncodedKey() {
        try {
            switch (this.cryptoKeyPart) {
                case privateKey: {
                    return CryptoRegistry.getInstance().encodePrivateKey((CipherParameters)this.getPrivateKeyParameterOrFail());
                }
                case publicKey: {
                    return CryptoRegistry.getInstance().encodePublicKey((CipherParameters)this.getPublicKeyParameterOrFail());
                }
                case sharedSecret: {
                    return this.getKeyParameterOrFail().getKey();
                }
            }
            throw new IllegalArgumentException("Unknown cryptoKeyPart: " + this.cryptoKeyPart);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }
}

