/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.dto.jaxb.CloudStoreJaxbContext;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.NoCloseInputStream;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.dto.UserRepoInvitationDto;
import org.subshare.core.file.EncryptedDataFile;
import org.subshare.core.pgp.ImportKeysResult;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpEncoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.ServerRepoManagerImpl;
import org.subshare.core.repo.ServerRepoRegistry;
import org.subshare.core.repo.ServerRepoRegistryImpl;
import org.subshare.core.server.Server;
import org.subshare.core.server.ServerRegistry;
import org.subshare.core.server.ServerRegistryImpl;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistry;
import org.subshare.core.user.UserRepoInvitation;
import org.subshare.core.user.UserRepoInvitationDtoConverter;
import org.subshare.core.user.UserRepoInvitationManager;
import org.subshare.core.user.UserRepoInvitationToken;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.local.persistence.InvitationUserRepoKeyPublicKey;
import org.subshare.local.persistence.SsRemoteRepository;
import org.subshare.local.persistence.UserIdentityDao;
import org.subshare.local.persistence.UserIdentityLinkDao;
import org.subshare.local.persistence.UserRepoKeyPublicKeyDao;
import org.subshare.local.persistence.VerifySignableAndWriteProtectedEntityListener;

public class UserRepoInvitationManagerImpl
implements UserRepoInvitationManager {
    private static final String USER_REPO_INVITATION_DTO_XML_FILE_NAME = "userRepoInvitationDto.xml";
    private static final Logger logger = LoggerFactory.getLogger(UserRepoInvitationManagerImpl.class);
    private final UserRepoInvitationDtoConverter userRepoInvitationDtoConverter = new UserRepoInvitationDtoConverter();
    private UserRegistry userRegistry;
    private LocalRepoManager localRepoManager;
    private LocalRepoTransaction transaction;
    private Cryptree cryptree;
    private User grantingUser;

    public int getPriority() {
        return 0;
    }

    public UserRegistry getUserRegistry() {
        return this.userRegistry;
    }

    public void setUserRegistry(UserRegistry userRegistry) {
        this.userRegistry = userRegistry;
    }

    public LocalRepoManager getLocalRepoManager() {
        return this.localRepoManager;
    }

    public void setLocalRepoManager(LocalRepoManager localRepoManager) {
        this.localRepoManager = localRepoManager;
    }

    public UserRepoInvitationToken createUserRepoInvitationToken(String localPath, User user, Set<PgpKey> userPgpKeys, PermissionType permissionType, long validityDurationMillis) {
        AssertUtil.assertNotNull((String)"localPath", (Object)localPath);
        AssertUtil.assertNotNull((String)"user", (Object)user);
        AssertUtil.assertNotNull((String)"permissionType", (Object)permissionType);
        if (userPgpKeys == null) {
            if (user.getPgpKeys().isEmpty()) {
                throw new IllegalArgumentException("The user does not have any PGP keys assigned: " + user);
            }
            userPgpKeys = user.getValidPgpKeys();
            if (userPgpKeys.isEmpty()) {
                throw new IllegalArgumentException("All the user's PGP keys are revoked or expired: " + user);
            }
        } else {
            if (userPgpKeys.isEmpty()) {
                throw new IllegalArgumentException("The specified userPgpKeys must not be empty!");
            }
            Set allowedPgpKeys = user.getPgpKeys();
            for (PgpKey pgpKey : userPgpKeys) {
                if (allowedPgpKeys.contains(pgpKey)) continue;
                throw new IllegalArgumentException(String.format("The key %s given in userPgpKeys does not belong to the user %s!", pgpKey, user));
            }
        }
        UserRepoInvitation userRepoInvitation = this.createUserRepoInvitation(localPath, user, permissionType, validityDurationMillis);
        User grantingUser = (User)AssertUtil.assertNotNull((String)"grantingUser", (Object)this.grantingUser);
        byte[] userRepoInvitationData = this.toUserRepoInvitationData(userRepoInvitation);
        PgpKey signPgpKey = grantingUser.getPgpKeyContainingSecretKeyOrFail();
        HashSet<PgpKey> encryptPgpKeys = new HashSet<PgpKey>(userPgpKeys.size() + 1);
        encryptPgpKeys.addAll(userPgpKeys);
        encryptPgpKeys.add(signPgpKey);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getPgpOrFail().exportPublicKeys(Collections.singleton(signPgpKey), (IOutputStream)out);
        byte[] signPgpKeyData = out.toByteArray();
        byte[] encryptedSignPgpKeyData = this.encrypt(signPgpKeyData, encryptPgpKeys);
        byte[] encryptedUserRepoInvitationData = this.signAndEncrypt(userRepoInvitationData, signPgpKey, encryptPgpKeys);
        EncryptedDataFile edf = new EncryptedDataFile();
        edf.putSigningKeyData(encryptedSignPgpKeyData);
        edf.putDefaultData(encryptedUserRepoInvitationData);
        try {
            return new UserRepoInvitationToken(edf.write());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] encrypt(byte[] plainData, Set<PgpKey> encryptPgpKeys) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PgpEncoder encoder = this.getPgpOrFail().createEncoder((IInputStream)new ByteArrayInputStream(plainData), (IOutputStream)out);
        encoder.getEncryptPgpKeys().addAll(encryptPgpKeys);
        try {
            encoder.encode();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return out.toByteArray();
    }

    private byte[] signAndEncrypt(byte[] plainData, PgpKey signPgpKey, Set<PgpKey> encryptPgpKeys) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PgpEncoder encoder = this.getPgpOrFail().createEncoder((IInputStream)new ByteArrayInputStream(plainData), (IOutputStream)out);
        encoder.setSignPgpKey(signPgpKey);
        encoder.getEncryptPgpKeys().addAll(encryptPgpKeys);
        try {
            encoder.encode();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return out.toByteArray();
    }

    public ServerRepo importUserRepoInvitationToken(UserRepoInvitationToken userRepoInvitationToken) {
        PgpDecoder pgpDecoder;
        EncryptedDataFile edf;
        AssertUtil.assertNotNull((String)"userRepoInvitationToken", (Object)userRepoInvitationToken);
        try {
            edf = new EncryptedDataFile(userRepoInvitationToken.getSignedEncryptedUserRepoInvitationData());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] defaultData = edf.getDefaultData();
        if (defaultData == null) {
            throw new IllegalArgumentException("Container does not contain defaultData!");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] encryptedSignPgpKeyData = edf.getSigningKeyData();
        Pgp pgp = this.getPgpOrFail();
        if (encryptedSignPgpKeyData != null) {
            pgpDecoder = pgp.createDecoder((IInputStream)new ByteArrayInputStream(encryptedSignPgpKeyData), (IOutputStream)out);
            try {
                pgpDecoder.decode();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] signPgpKeyData = out.toByteArray();
            ImportKeysResult importKeysResult = pgp.importKeys((IInputStream)new ByteArrayInputStream(signPgpKeyData));
            HashMap<PgpKeyId, PgpKey> pgpKeyId2PgpKey = new HashMap<PgpKeyId, PgpKey>();
            for (ImportKeysResult.ImportedMasterKey importedMasterKey : importKeysResult.getPgpKeyId2ImportedMasterKey().values()) {
                PgpKeyId pgpKeyId = importedMasterKey.getPgpKeyId();
                PgpKey pgpKey = pgp.getPgpKey(pgpKeyId);
                AssertUtil.assertNotNull((String)("pgp.getPgpKey(" + pgpKeyId + ")"), (Object)pgpKey);
                pgpKeyId2PgpKey.put(pgpKeyId, pgpKey);
            }
            this.userRegistry.importUsersFromPgpKeys(pgpKeyId2PgpKey.values());
        }
        out.reset();
        pgpDecoder = pgp.createDecoder((IInputStream)new ByteArrayInputStream(defaultData), (IOutputStream)out);
        try {
            pgpDecoder.decode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (pgpDecoder.getPgpSignature() == null) {
            throw new SignatureException("Missing signature!");
        }
        UserRepoInvitation userRepoInvitation = this.fromUserRepoInvitationData(out.toByteArray());
        ServerRepo serverRepo = this.importUserRepoInvitation(userRepoInvitation);
        URL remoteURL = UrlUtil.appendEncodedPath((URL)userRepoInvitation.getServerUrl(), (String)userRepoInvitation.getServerPath());
        ServerRepoManagerImpl.connectLocalRepositoryWithServerRepository((LocalRepoManager)this.localRepoManager, (UUID)serverRepo.getRepositoryId(), (URL)remoteURL);
        return serverRepo;
    }

    private byte[] toUserRepoInvitationData(UserRepoInvitation userRepoInvitation) {
        AssertUtil.assertNotNull((String)"userRepoInvitation", (Object)userRepoInvitation);
        try {
            Marshaller marshaller = CloudStoreJaxbContext.getJaxbContext().createMarshaller();
            UserRepoInvitationDto userRepoInvitationDto = this.userRepoInvitationDtoConverter.toUserRepoInvitationDto(userRepoInvitation);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zout = new ZipOutputStream((OutputStream)out);
            this.writeManifest(zout);
            zout.putNextEntry(new ZipEntry(USER_REPO_INVITATION_DTO_XML_FILE_NAME));
            marshaller.marshal((Object)userRepoInvitationDto, (OutputStream)zout);
            zout.closeEntry();
            zout.close();
            return out.toByteArray();
        }
        catch (IOException | JAXBException x) {
            throw new RuntimeException(x);
        }
    }

    private void writeManifest(ZipOutputStream zout) throws IOException {
        byte[] manifestData = this.createManifestData();
        zout.putNextEntry(this.createManifestZipEntry(manifestData));
        zout.write(manifestData);
        zout.closeEntry();
    }

    private UserRepoInvitation fromUserRepoInvitationData(byte[] userRepoInvitationData) {
        AssertUtil.assertNotNull((String)"userRepoInvitationData", (Object)userRepoInvitationData);
        try {
            ZipInputStream zin = new ZipInputStream((InputStream)new ByteArrayInputStream(userRepoInvitationData));
            Properties manifestProperties = this.readManifest(zin);
            int version = this.getVersionFromManifestProperties(manifestProperties);
            if (version != 1) {
                throw new IllegalArgumentException("userRepoInvitationData invalid: Unsupported version: " + version);
            }
            Map<String, Object> name2Dto = this.readName2Dto(zin);
            UserRepoInvitationDto userRepoInvitationDto = (UserRepoInvitationDto)name2Dto.get(USER_REPO_INVITATION_DTO_XML_FILE_NAME);
            if (userRepoInvitationDto == null) {
                throw new IllegalArgumentException("userRepoInvitationData invalid: Missing zip-entry: userRepoInvitationDto.xml");
            }
            UserRepoInvitation userRepoInvitation = this.userRepoInvitationDtoConverter.fromUserRepoInvitationDto(userRepoInvitationDto);
            return userRepoInvitation;
        }
        catch (IOException | JAXBException x) {
            throw new RuntimeException(x);
        }
    }

    private Map<String, Object> readName2Dto(ZipInputStream zin) throws IOException, JAXBException {
        ZipEntry ze;
        Unmarshaller unmarshaller = CloudStoreJaxbContext.getJaxbContext().createUnmarshaller();
        HashMap<String, Object> name2Dto = new HashMap<String, Object>();
        while (null != (ze = zin.getNextEntry())) {
            if (!ze.getName().endsWith(".xml")) {
                logger.warn("fromUserRepoInvitationData: Ignoring file (not ending on '.xml'): {}", (Object)ze.getName());
                continue;
            }
            Object dto = unmarshaller.unmarshal((InputStream)new NoCloseInputStream((InputStream)zin));
            name2Dto.put(ze.getName(), dto);
        }
        return name2Dto;
    }

    private Properties readManifest(ZipInputStream zin) throws IOException {
        AssertUtil.assertNotNull((String)"zin", (Object)zin);
        ZipEntry ze = zin.getNextEntry();
        if (ze == null) {
            throw new IllegalArgumentException(String.format("userRepoInvitationData is not valid: It lacks the '%s' as very first zip-entry (there is no first ZipEntry)!", "MANIFEST.properties"));
        }
        if (!"MANIFEST.properties".equals(ze.getName())) {
            throw new IllegalArgumentException(String.format("userRepoInvitationData is not valid: The very first zip-entry is not '%s' (it is '%s' instead)!", "MANIFEST.properties", ze.getName()));
        }
        Properties properties = new Properties();
        properties.load(zin);
        String contentType = properties.getProperty("contentType");
        if (!"application/vnd.subshare.user-repo-invitation".equals(contentType)) {
            throw new IllegalArgumentException(String.format("userRepoInvitationData is not valid: The manifest indicates the content-type '%s', but '%s' is expected!", contentType, "application/vnd.subshare.user-repo-invitation"));
        }
        return properties;
    }

    private int getVersionFromManifestProperties(Properties manifestProperties) {
        int version;
        String versionStr = manifestProperties.getProperty("contentTypeVersion");
        try {
            version = Integer.parseInt(versionStr);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(String.format("The manifest does not contain a valid version number ('%s' is not a valid integer)!", versionStr), x);
        }
        return version;
    }

    private ZipEntry createManifestZipEntry(byte[] manifestData) {
        ZipEntry ze = new ZipEntry("MANIFEST.properties");
        ze.setMethod(0);
        ze.setSize(manifestData.length);
        ze.setCompressedSize(manifestData.length);
        CRC32 crc32 = new CRC32();
        crc32.update(manifestData);
        ze.setCrc(crc32.getValue());
        return ze;
    }

    private byte[] createManifestData() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        this.writeManifestEntry(w, "contentType", "application/vnd.subshare.user-repo-invitation");
        this.writeManifestEntry(w, "contentTypeVersion", Integer.toString(1));
        ((Writer)w).close();
        return out.toByteArray();
    }

    private void writeManifestEntry(Writer w, String key, String value) throws IOException {
        w.write(key);
        w.write(61);
        w.write(value);
        w.write(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserRepoInvitation createUserRepoInvitation(String localPath, User user, PermissionType permissionType, long validityDurationMillis) {
        UserRepoInvitation userRepoInvitation;
        AssertUtil.assertNotNull((String)"localPath", (Object)localPath);
        AssertUtil.assertNotNull((String)"user", (Object)user);
        AssertUtil.assertNotNull((String)"permissionType", (Object)permissionType);
        try (LocalRepoTransaction transaction = this.localRepoManager.beginWriteTransaction();){
            this.transaction = transaction;
            this.grantingUser = this.createCryptreeAndDetermineGrantingUser(localPath);
            UserRepoKey invitationUserRepoKey = this.grantingUser.createInvitationUserRepoKey(user, this.cryptree.getRemoteRepositoryId(), validityDurationMillis);
            user.getUserRepoKeyPublicKeys().add(invitationUserRepoKey.getPublicKey());
            this.cryptree.grantPermission(localPath, permissionType, (UserRepoKey.PublicKey)invitationUserRepoKey.getPublicKey());
            RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class);
            SsRemoteRepository remoteRepository = (SsRemoteRepository)remoteRepositoryDao.getRemoteRepositoryOrFail(this.cryptree.getRemoteRepositoryId());
            URL remoteRoot = remoteRepository.getRemoteRoot();
            if (remoteRoot == null) {
                throw new IllegalStateException("Could not determine the remoteRoot for the remoteRepositoryId " + this.cryptree.getRemoteRepositoryId());
            }
            String remotePathPrefix = (String)AssertUtil.assertNotNull((String)"remoteRepository.remotePathPrefix", (Object)remoteRepository.getRemotePathPrefix());
            URL serverUrl = this.removePathSuffix(remoteRoot, remotePathPrefix);
            serverUrl = this.removePathSuffix(serverUrl, remoteRepository.getRepositoryId().toString());
            String serverPath = this.cryptree.getServerPath(localPath);
            URL completeUrl = UrlUtil.appendEncodedPath((URL)remoteRoot, (String)serverPath);
            String serverPathWithRepositoryName = this.getPathAfterPrefix(completeUrl, serverUrl);
            userRepoInvitation = new UserRepoInvitation(serverUrl, serverPathWithRepositoryName, invitationUserRepoKey);
            logger.info("createUserRepoInvitation: grantingUser={} grantingUserRepoKeyIds={} invitedUser={} invitationUserRepoKey={}", new Object[]{this.grantingUser, this.grantingUser.getUserRepoKeyRing().getUserRepoKeys(), user, invitationUserRepoKey});
            transaction.commit();
        }
        finally {
            this.cryptree = null;
            this.transaction = null;
        }
        return userRepoInvitation;
    }

    private URL removePathSuffix(URL url, String pathSuffix) {
        AssertUtil.assertNotNull((String)"url", (Object)url);
        AssertUtil.assertNotNull((String)"suffix", (Object)pathSuffix);
        String urlStr = url.toString();
        while (urlStr.endsWith("/")) {
            urlStr = urlStr.substring(0, urlStr.length() - 1);
        }
        while (pathSuffix.endsWith("/")) {
            pathSuffix = pathSuffix.substring(0, pathSuffix.length() - 1);
        }
        if (!urlStr.endsWith(pathSuffix)) {
            throw new IllegalArgumentException(String.format("url '%s' does not end with suffix '%s'!", urlStr, pathSuffix));
        }
        String resultStr = urlStr.substring(0, urlStr.length() - pathSuffix.length());
        if (resultStr.endsWith("/")) {
            resultStr = resultStr.substring(0, resultStr.length() - 1);
        }
        try {
            return new URL(resultStr);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPathAfterPrefix(URL completeUrl, URL prefixUrl) {
        AssertUtil.assertNotNull((String)"completeUrl", (Object)completeUrl);
        AssertUtil.assertNotNull((String)"prefixUrl", (Object)prefixUrl);
        String completeUrlStr = completeUrl.toExternalForm();
        String prefixUrlStr = prefixUrl.toExternalForm();
        if (prefixUrlStr.endsWith("/")) {
            throw new IllegalStateException("prefixUrlStr.endsWith(\"/\") :: " + prefixUrlStr);
        }
        if (!completeUrlStr.startsWith(prefixUrlStr)) {
            throw new IllegalStateException("! completeUrlStr.startsWith(prefixUrlStr) :: " + completeUrlStr + " :: " + prefixUrlStr);
        }
        String result = completeUrlStr.substring(prefixUrlStr.length());
        return result;
    }

    private User createCryptreeAndDetermineGrantingUser(String localPath) {
        RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)this.transaction.getDao(RemoteRepositoryDao.class);
        Map remoteRepositoryId2RemoteRootMap = remoteRepositoryDao.getRemoteRepositoryId2RemoteRootMap();
        if (remoteRepositoryId2RemoteRootMap.size() > 1) {
            throw new UnsupportedOperationException("Currently, only exactly one remote-repository is allowed per local repository!");
        }
        if (remoteRepositoryId2RemoteRootMap.isEmpty()) {
            throw new IllegalStateException("There is no remote-repository connected with this local repository!");
        }
        UUID remoteRepositoryId = (UUID)remoteRepositoryId2RemoteRootMap.keySet().iterator().next();
        SsRemoteRepository remoteRepository = (SsRemoteRepository)remoteRepositoryDao.getRemoteRepositoryOrFail(remoteRepositoryId);
        for (User user : this.userRegistry.getUsers()) {
            UserRepoKeyRing userRepoKeyRing = user.getUserRepoKeyRing();
            if (userRepoKeyRing == null || user.getPgpKeyContainingSecretKey() == null) continue;
            this.cryptree = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail().getCryptreeOrCreate(this.transaction, remoteRepositoryId, remoteRepository.getRemotePathPrefix(), userRepoKeyRing);
            UserRepoKey grantingUserRepoKey = this.cryptree.getUserRepoKey(localPath, PermissionType.grant);
            if (grantingUserRepoKey != null) {
                return user;
            }
            this.transaction.removeContextObject((Object)this.cryptree);
        }
        throw new IllegalArgumentException("No User found having a local UserRepoKey allowed to grant access as desired!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerRepo importUserRepoInvitation(UserRepoInvitation userRepoInvitation) {
        AssertUtil.assertNotNull((String)"userRepoInvitation", (Object)userRepoInvitation);
        logger.info("importUserRepoInvitation: serverUrl='{}' serverPath='{}' invitationUserRepoKey={}", new Object[]{userRepoInvitation.getServerUrl(), userRepoInvitation.getServerPath(), userRepoInvitation.getInvitationUserRepoKey()});
        PgpKey decryptPgpKey = this.determineDecryptPgpKey(userRepoInvitation);
        User user = this.findUserWithPgpKeyOrFail(decryptPgpKey);
        ServerRepo serverRepo = this.registerInServerRepoRegistry(userRepoInvitation, user);
        user.getUserRepoKeyRingOrCreate().addUserRepoKey(userRepoInvitation.getInvitationUserRepoKey());
        UserRepoKey userRepoKey = user.createUserRepoKey(userRepoInvitation.getInvitationUserRepoKey().getServerRepositoryId());
        try (LocalRepoTransaction transaction = this.localRepoManager.beginWriteTransaction();){
            this.transaction = transaction;
            this.cryptree = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail().getCryptreeOrCreate(transaction, userRepoInvitation.getInvitationUserRepoKey().getServerRepositoryId(), "NOT_NEEDED_FOR_THIS_OPERATION", user.getUserRepoKeyRingOrCreate());
            UserRepoKeyPublicKeyDao userRepoKeyPublicKeyDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
            this.cryptree.requestReplaceInvitationUserRepoKey(userRepoInvitation.getInvitationUserRepoKey(), (UserRepoKey.PublicKey)userRepoKey.getPublicKey());
            logger.info("importUserRepoInvitation: invitationUserRepoKey={} realUserRepoKey={}", (Object)userRepoInvitation.getInvitationUserRepoKey(), (Object)userRepoKey);
            InvitationUserRepoKeyPublicKey invitationUserRepoKeyPublicKey = (InvitationUserRepoKeyPublicKey)userRepoKeyPublicKeyDao.getUserRepoKeyPublicKeyOrFail(userRepoInvitation.getInvitationUserRepoKey().getUserRepoKeyId());
            VerifySignableAndWriteProtectedEntityListener verifySignableAndWriteProtectedEntityListener = (VerifySignableAndWriteProtectedEntityListener)((Object)transaction.getContextObject(VerifySignableAndWriteProtectedEntityListener.class));
            AssertUtil.assertNotNull((String)"verifySignableAndWriteProtectedEntityListener", (Object)((Object)verifySignableAndWriteProtectedEntityListener));
            verifySignableAndWriteProtectedEntityListener.removeSignable(invitationUserRepoKeyPublicKey);
            UserIdentityDao uiDao = (UserIdentityDao)((Object)transaction.getDao(UserIdentityDao.class));
            UserIdentityLinkDao uilDao = (UserIdentityLinkDao)((Object)transaction.getDao(UserIdentityLinkDao.class));
            uilDao.deletePersistentAll(uilDao.getObjects());
            transaction.flush();
            uiDao.deletePersistentAll(uiDao.getObjects());
            transaction.flush();
            transaction.commit();
        }
        finally {
            this.cryptree = null;
            this.transaction = null;
        }
        this.userRegistry.writeIfNeeded();
        return serverRepo;
    }

    private Server registerInServerRegistry(UserRepoInvitation userRepoInvitation) {
        URL serverUrl;
        ServerRegistry serverRegistry = ServerRegistryImpl.getInstance();
        Server server = serverRegistry.getServerForRemoteRoot(serverUrl = userRepoInvitation.getServerUrl());
        if (server == null) {
            server = serverRegistry.createServer();
            server.setName(serverUrl.getHost());
            server.setUrl(serverUrl);
            serverRegistry.getServers().add(server);
            serverRegistry.writeIfNeeded();
        }
        return server;
    }

    private ServerRepo registerInServerRepoRegistry(UserRepoInvitation userRepoInvitation, User user) {
        Server server = this.registerInServerRegistry(userRepoInvitation);
        UUID serverRepositoryId = userRepoInvitation.getInvitationUserRepoKey().getServerRepositoryId();
        ServerRepoRegistry serverRepoRegistry = ServerRepoRegistryImpl.getInstance();
        ServerRepo serverRepo = serverRepoRegistry.getServerRepo(serverRepositoryId);
        if (serverRepo == null) {
            serverRepo = serverRepoRegistry.createServerRepo(serverRepositoryId);
            serverRepo.setServerId(server.getServerId());
            serverRepo.setName(serverRepositoryId.toString());
            serverRepo.setUserId(user.getUserId());
            serverRepoRegistry.getServerRepos().add(serverRepo);
            serverRepoRegistry.writeIfNeeded();
        }
        return serverRepo;
    }

    private PgpKey determineDecryptPgpKey(UserRepoInvitation userRepoInvitation) {
        byte[] encryptedSignedPrivateKeyData = userRepoInvitation.getInvitationUserRepoKey().getEncryptedSignedPrivateKeyData();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PgpDecoder decoder = this.getPgpOrFail().createDecoder((IInputStream)new ByteArrayInputStream(encryptedSignedPrivateKeyData), (IOutputStream)out);
        try {
            decoder.decode();
            if (decoder.getPgpSignature() == null) {
                throw new SignatureException("Missing signature!");
            }
            return decoder.getDecryptPgpKey();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Pgp getPgpOrFail() {
        return PgpRegistry.getInstance().getPgpOrFail();
    }

    private User findUserWithPgpKeyOrFail(PgpKey pgpKey) {
        PgpKeyId pgpKeyId = ((PgpKey)AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey)).getMasterKey().getPgpKeyId();
        for (User user : this.userRegistry.getUsers()) {
            if (!user.getPgpKeyIds().contains(pgpKeyId)) continue;
            return user;
        }
        throw new IllegalArgumentException("No User associated with the PgpKey with id=" + pgpKeyId);
    }
}

