/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.HistoFileChunkDao;
import org.subshare.local.persistence.HistoFrame;
import org.subshare.local.persistence.PlainHistoCryptoRepoFile;
import org.subshare.local.persistence.PlainHistoCryptoRepoFileDao;

public class HistoCryptoRepoFileDao
extends Dao<HistoCryptoRepoFile, HistoCryptoRepoFileDao> {
    private static final Logger logger = LoggerFactory.getLogger(HistoCryptoRepoFileDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HistoCryptoRepoFile> getHistoCryptoRepoFilesChangedAfterExclLastSyncFromRepositoryId(long localRevision, UUID exclLastSyncFromRepositoryId) {
        AssertUtil.assertNotNull((String)"exclLastSyncFromRepositoryId", (Object)exclLastSyncFromRepositoryId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getHistoCryptoRepoFilesChangedAfter_localRevision_exclLastSyncFromRepositoryId");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision, (Object)exclLastSyncFromRepositoryId.toString());
            logger.debug("getHistoCryptoRepoFilesChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getHistoCryptoRepoFilesChangedAfter: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HistoCryptoRepoFile> getHistoCryptoRepoFiles(CryptoRepoFile cryptoRepoFile) {
        AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)cryptoRepoFile));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getHistoCryptoRepoFiles_cryptoRepoFile");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)cryptoRepoFile);
            logger.debug("getHistoCryptoRepoFiles: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getHistoCryptoRepoFiles: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HistoCryptoRepoFile> getHistoCryptoRepoFiles(HistoFrame histoFrame) {
        AssertUtil.assertNotNull((String)"histoFrame", (Object)((Object)histoFrame));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getHistoCryptoRepoFiles_histoFrame");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)histoFrame);
            logger.debug("getHistoCryptoRepoFiles: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getHistoCryptoRepoFiles: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public HistoCryptoRepoFile getHistoCryptoRepoFileOrFail(Uid histoCryptoRepoFileId) {
        HistoCryptoRepoFile histoCryptoRepoFile = this.getHistoCryptoRepoFile(histoCryptoRepoFileId);
        AssertUtil.assertNotNull((String)("getHistoCryptoRepoFile(" + histoCryptoRepoFileId + ")"), (Object)((Object)histoCryptoRepoFile));
        return histoCryptoRepoFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoCryptoRepoFile getHistoCryptoRepoFile(Uid histoCryptoRepoFileId) {
        AssertUtil.assertNotNull((String)"histoCryptoRepoFileId", (Object)histoCryptoRepoFileId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getHistoCryptoRepoFile_histoCryptoRepoFileId");
        try {
            HistoCryptoRepoFile result;
            HistoCryptoRepoFile histoCryptoRepoFile = result = (HistoCryptoRepoFile)((Object)query.execute((Object)histoCryptoRepoFileId.toString()));
            return histoCryptoRepoFile;
        }
        finally {
            query.closeAll();
        }
    }

    public void deletePersistent(HistoCryptoRepoFile entity) {
        this.deletePlainHistoCryptoRepoFile(entity);
        this.deleteHistoFileChunks(entity);
        this.getPersistenceManager().flush();
        super.deletePersistent((Entity)entity);
    }

    public void deletePersistentAll(Collection<? extends HistoCryptoRepoFile> entities) {
        for (HistoCryptoRepoFile histoCryptoRepoFile : entities) {
            this.deletePlainHistoCryptoRepoFile(histoCryptoRepoFile);
            this.deleteHistoFileChunks(histoCryptoRepoFile);
        }
        this.getPersistenceManager().flush();
        super.deletePersistentAll(entities);
    }

    private void deleteHistoFileChunks(HistoCryptoRepoFile histoCryptoRepoFile) {
        HistoFileChunkDao hfcDao = (HistoFileChunkDao)this.getDao(HistoFileChunkDao.class);
        hfcDao.deletePersistentAll(hfcDao.getHistoFileChunks(histoCryptoRepoFile));
    }

    private void deletePlainHistoCryptoRepoFile(HistoCryptoRepoFile histoCryptoRepoFile) {
        PlainHistoCryptoRepoFileDao phcrfDao = (PlainHistoCryptoRepoFileDao)this.getDao(PlainHistoCryptoRepoFileDao.class);
        PlainHistoCryptoRepoFile phcrf = phcrfDao.getPlainHistoCryptoRepoFile(histoCryptoRepoFile);
        if (phcrf != null) {
            phcrfDao.deletePersistent(phcrf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HistoCryptoRepoFile> getHistoCryptoRepoFilesWithoutPlainHistoCryptoRepoFile() {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getHistoCryptoRepoFilesWithoutPlainHistoCryptoRepoFile");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute();
            logger.debug("getHistoCryptoRepoFilesWithoutPlainHistoCryptoRepoFile: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getHistoCryptoRepoFilesWithoutPlainHistoCryptoRepoFile: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HistoCryptoRepoFile> getHistoCryptoRepoFilesByCollisions(Set<Uid> collisionIds) {
        AssertUtil.assertNotNull((String)"collisionIds", collisionIds);
        HashSet<String> collisionIdsAsString = new HashSet<String>(collisionIds.size());
        for (Uid collisionId : collisionIds) {
            collisionIdsAsString.add(collisionId.toString());
        }
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getHistoCryptoRepoFilesByCollisions");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute(collisionIdsAsString);
            logger.debug("getHistoCryptoRepoFilesByCollisions: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getHistoCryptoRepoFilesByCollisions: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }
}

