/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot;

import java.io.File;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.wot.OwnerTrust;
import org.bouncycastle.openpgp.wot.Validity;
import org.bouncycastle.openpgp.wot.internal.TrustDbImpl;
import org.bouncycastle.openpgp.wot.internal.Util;
import org.bouncycastle.openpgp.wot.key.PgpKey;
import org.bouncycastle.openpgp.wot.key.PgpKeyRegistry;
import org.bouncycastle.openpgp.wot.key.PgpUserId;
import org.bouncycastle.openpgp.wot.key.PgpUserIdNameHash;

public interface TrustDb
extends AutoCloseable {
    @Override
    public void close();

    public OwnerTrust getOwnerTrust(PgpKey var1);

    public void setOwnerTrust(PgpKey var1, OwnerTrust var2);

    public OwnerTrust getOwnerTrust(PGPPublicKey var1);

    public void setOwnerTrust(PGPPublicKey var1, OwnerTrust var2);

    @Deprecated
    public int getValidityRaw(PGPPublicKey var1);

    @Deprecated
    public int getValidityRaw(PGPPublicKey var1, PgpUserIdNameHash var2);

    public Validity getValidity(PgpKey var1);

    public Validity getValidity(PgpUserId var1);

    public Validity getValidity(PGPPublicKey var1);

    public Validity getValidity(PGPPublicKey var1, PgpUserIdNameHash var2);

    public void updateUltimatelyTrustedKeysFromAvailableSecretKeys(boolean var1);

    public boolean isExpired(PGPPublicKey var1);

    public boolean isDisabled(PgpKey var1);

    public void setDisabled(PgpKey var1, boolean var2);

    public boolean isDisabled(PGPPublicKey var1);

    public void setDisabled(PGPPublicKey var1, boolean var2);

    public boolean isTrustDbStale();

    public void markTrustDbStale();

    public void updateTrustDbIfNeeded();

    public void updateTrustDb();

    public static class Helper {
        public static TrustDb createInstance(File file, PgpKeyRegistry pgpKeyRegistry) {
            Util.assertNotNull("file", file);
            Util.assertNotNull("pgpKeyRegistry", pgpKeyRegistry);
            return new TrustDbImpl(file, pgpKeyRegistry);
        }
    }
}

