/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core;

import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.UUID;
import org.subshare.core.LocalRepoStorage;
import org.subshare.core.LocalRepoStorageFactory;

public abstract class AbstractLocalRepoStorageFactory
implements LocalRepoStorageFactory {
    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public LocalRepoStorage getLocalRepoStorageOrCreate(LocalRepoTransaction transaction) {
        AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        LocalRepoStorage lrs = (LocalRepoStorage)transaction.getContextObject(LocalRepoStorage.class);
        if (lrs == null) {
            lrs = this._createLocalRepoStorage();
            lrs.setLocalRepoStorageFactory(this);
            lrs.setTransaction(transaction);
            transaction.setContextObject((Object)lrs);
        } else if (transaction != lrs.getTransaction()) {
            throw new IllegalStateException("transaction != cryptree.transaction");
        }
        return lrs;
    }

    @Override
    public LocalRepoStorage getLocalRepoStorageOrCreate(LocalRepoTransaction transaction, UUID remoteRepositoryId, String remotePathPrefix) {
        AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
        AssertUtil.assertNotNull((String)"remoteRepositoryId", (Object)remoteRepositoryId);
        AssertUtil.assertNotNull((String)"remotePathPrefix", (Object)remotePathPrefix);
        LocalRepoStorage cryptree = (LocalRepoStorage)transaction.getContextObject(LocalRepoStorage.class);
        if (cryptree == null) {
            cryptree = this._createLocalRepoStorage();
            cryptree.setLocalRepoStorageFactory(this);
            cryptree.setTransaction(transaction);
            cryptree.setRemoteRepositoryId(remoteRepositoryId);
            cryptree.setRemotePathPrefix(remotePathPrefix);
            transaction.setContextObject((Object)cryptree);
        } else {
            if (transaction != cryptree.getTransaction()) {
                throw new IllegalStateException("transaction != cryptree.transaction");
            }
            if (!remoteRepositoryId.equals(cryptree.getRemoteRepositoryId())) {
                throw new IllegalStateException("remoteRepositoryId != cryptree.remoteRepositoryId");
            }
            if (!remotePathPrefix.equals(cryptree.getRemotePathPrefix())) {
                throw new IllegalStateException("remotePathPrefix != cryptree.remotePathPrefix");
            }
        }
        return cryptree;
    }

    protected abstract LocalRepoStorage _createLocalRepoStorage();
}

