/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.file;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.FileFilter;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.file.DataFile;

public class DataFileFilter
implements FileFilter {
    private static final Logger logger = LoggerFactory.getLogger(DataFileFilter.class);
    private boolean acceptDirectories = true;
    private String acceptContentType = null;
    private int acceptContentTypeVersionMin = 0;
    private int acceptContentTypeVersionMax = Integer.MAX_VALUE;

    public boolean isAcceptDirectories() {
        return this.acceptDirectories;
    }

    public DataFileFilter setAcceptDirectories(boolean acceptDirectories) {
        this.acceptDirectories = acceptDirectories;
        return this;
    }

    public String getAcceptContentType() {
        return this.acceptContentType;
    }

    public DataFileFilter setAcceptContentType(String acceptContentType) {
        this.acceptContentType = acceptContentType;
        return this;
    }

    public int getAcceptContentTypeVersionMin() {
        return this.acceptContentTypeVersionMin;
    }

    public DataFileFilter setAcceptContentTypeVersionMin(int acceptContentTypeVersionMin) {
        this.acceptContentTypeVersionMin = acceptContentTypeVersionMin;
        return this;
    }

    public int getAcceptContentTypeVersionMax() {
        return this.acceptContentTypeVersionMax;
    }

    public DataFileFilter setAcceptContentTypeVersionMax(int acceptContentTypeVersionMax) {
        this.acceptContentTypeVersionMax = acceptContentTypeVersionMax;
        return this;
    }

    public boolean accept(File file) {
        AssertUtil.assertNotNull((String)"file", (Object)file);
        if (this.isAcceptDirectories() && file.isDirectory()) {
            return true;
        }
        if (!this.acceptFileName(file)) {
            return false;
        }
        return this.acceptContentType(file);
    }

    protected boolean acceptFileName(File file) {
        return file.getName().endsWith(".subshare");
    }

    protected boolean acceptContentType(File file) {
        AssertUtil.assertNotNull((String)"file", (Object)file);
        try {
            DataFile dataFile;
            try (InputStream in = StreamUtil.castStream((IInputStream)file.createInputStream());){
                dataFile = new DataFile(in){

                    @Override
                    protected String getContentTypeValue() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    protected void assertValidContentType(Properties manifestProperties) {
                    }

                    @Override
                    protected void readPayload(ZipInputStream zin) throws IOException {
                    }
                };
            }
            return this.acceptContentType(dataFile.getManifestProperties());
        }
        catch (Exception x) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("acceptContentType: Reading '%s' failed: %s", file.getAbsolutePath(), x), (Throwable)x);
            }
            return false;
        }
    }

    protected boolean acceptContentType(Properties manifestProperties) {
        AssertUtil.assertNotNull((String)"manifestProperties", (Object)manifestProperties);
        String contentTypeValue = manifestProperties.getProperty("contentType");
        if (this.getAcceptContentType() == null) {
            return true;
        }
        if (!this.getAcceptContentType().equals(contentTypeValue)) {
            return false;
        }
        if (this.getAcceptContentTypeVersionMin() == 0 && this.getAcceptContentTypeVersionMax() == Integer.MAX_VALUE) {
            return true;
        }
        String contentTypeVersionString = manifestProperties.getProperty("contentTypeVersion");
        if (StringUtil.isEmpty((String)contentTypeVersionString)) {
            return false;
        }
        int contentTypeVersion = Integer.parseInt(contentTypeVersionString);
        return this.getAcceptContentTypeVersionMin() <= contentTypeVersion && this.getAcceptContentTypeVersionMax() >= contentTypeVersion;
    }
}

