/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.subshare.core.repo.LocalRepo;

public class LocalRepoImpl
implements LocalRepo {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final UUID repositoryId;
    private String name;
    private co.codewizards.cloudstore.core.oio.File localRoot;

    public LocalRepoImpl(UUID repositoryId) {
        this.repositoryId = (UUID)AssertUtil.assertNotNull((String)"repositoryId)", (Object)repositoryId);
    }

    @Override
    public UUID getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChange(LocalRepo.PropertyEnum.name, old, name);
    }

    @Override
    public co.codewizards.cloudstore.core.oio.File getLocalRoot() {
        return this.localRoot;
    }

    @Override
    public void setLocalRoot(co.codewizards.cloudstore.core.oio.File localRoot) {
        co.codewizards.cloudstore.core.oio.File old = this.localRoot;
        this.localRoot = localRoot;
        this.firePropertyChange(LocalRepo.PropertyEnum.localRoot, old, localRoot);
    }

    @Override
    public String getLocalPath(co.codewizards.cloudstore.core.oio.File file) {
        String relativePath;
        AssertUtil.assertNotNull((String)"file", (Object)file);
        AssertUtil.assertNotNull((String)"localRoot", (Object)this.localRoot);
        if (file.equals(this.localRoot)) {
            return "";
        }
        try {
            relativePath = IOUtil.getRelativePath((co.codewizards.cloudstore.core.oio.File)this.localRoot, (co.codewizards.cloudstore.core.oio.File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (relativePath.startsWith("..") || relativePath.startsWith("/")) {
            throw new IllegalArgumentException(String.format("file '%s' is not located inside repository's root '%s'!", file.getPath(), this.localRoot.getPath()));
        }
        return '/' + relativePath.replace(File.separatorChar, '/');
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(LocalRepo.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(LocalRepo.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(LocalRepo.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }

    public LocalRepo clone() {
        LocalRepoImpl clone;
        try {
            clone = (LocalRepoImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.propertyChangeSupport = new PropertyChangeSupport(clone);
        return clone;
    }
}

