/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.DeletedUUID;
import org.subshare.core.dto.ServerRepoDto;
import org.subshare.core.dto.ServerRepoRegistryDto;
import org.subshare.core.dto.jaxb.ServerRepoRegistryDtoIo;
import org.subshare.core.fbor.FileBasedObjectRegistry;
import org.subshare.core.observable.ObservableList;
import org.subshare.core.observable.standard.StandardPostModificationEvent;
import org.subshare.core.observable.standard.StandardPostModificationListener;
import org.subshare.core.observable.standard.StandardPreModificationEvent;
import org.subshare.core.observable.standard.StandardPreModificationListener;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.ServerRepoDtoConverter;
import org.subshare.core.repo.ServerRepoImpl;
import org.subshare.core.repo.ServerRepoRegistry;
import org.subshare.core.server.ServerRegistry;
import org.subshare.core.server.ServerRegistryImpl;

public class ServerRepoRegistryImpl
extends FileBasedObjectRegistry
implements ServerRepoRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ServerRepoRegistryImpl.class);
    private static final String PAYLOAD_ENTRY_NAME = ServerRepoRegistryDto.class.getSimpleName() + ".xml";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String SERVER_REPO_REGISTRY_FILE_NAME = "serverRepoRegistry.subshare";
    private Map<UUID, ServerRepo> repositoryId2ServerRepo;
    private final ObservableList<ServerRepo> serverRepos;
    private final List<DeletedUUID> deletedServerRepoIds = new CopyOnWriteArrayList<DeletedUUID>();
    private final ThreadLocal<Boolean> suppressAddToDeletedServerRepoIds = new ThreadLocal();
    private final PreModificationListener preModificationListener = new PreModificationListener();
    private final PostModificationListener postModificationListener = new PostModificationListener();
    private final PropertyChangeListener serverRepoPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ServerRepoRegistryImpl.this.markDirty();
            ServerRepo serverRepo = (ServerRepo)evt.getSource();
            ServerRepoRegistryImpl.this.firePropertyChange(ServerRepoRegistry.PropertyEnum.serverRepos_serverRepo, null, serverRepo);
        }
    };
    private final File serverRepoRegistryFile;
    private Uid version;

    private void removeDeletedServerRepoId(UUID repositoryId) {
        ArrayList<DeletedUUID> deletedUidsToRemove = new ArrayList<DeletedUUID>();
        for (DeletedUUID deletedUUID : this.deletedServerRepoIds) {
            if (!repositoryId.equals(deletedUUID.getUuid())) continue;
            deletedUidsToRemove.add(deletedUUID);
        }
        this.deletedServerRepoIds.removeAll(deletedUidsToRemove);
    }

    private void addToDeletedServerRepoIds(UUID repositoryId) {
        if (!Boolean.TRUE.equals(this.suppressAddToDeletedServerRepoIds.get())) {
            this.deletedServerRepoIds.add(new DeletedUUID(repositoryId));
        }
    }

    protected ServerRepoRegistryImpl() {
        this.serverRepos = ObservableList.decorate(new CopyOnWriteArrayList());
        this.serverRepos.getHandler().addPreModificationListener(this.preModificationListener);
        this.serverRepos.getHandler().addPostModificationListener(this.postModificationListener);
        this.serverRepoRegistryFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{SERVER_REPO_REGISTRY_FILE_NAME});
        this.read();
    }

    @Override
    protected void markDirty() {
        super.markDirty();
        this.repositoryId2ServerRepo = null;
        this.version = new Uid();
        this.deferredWrite();
    }

    @Override
    protected String getContentType() {
        return "application/vnd.subshare.server-repo-registry";
    }

    @Override
    protected File getFile() {
        return this.serverRepoRegistryFile;
    }

    protected synchronized Map<UUID, ServerRepo> getRepositoryId2ServerRepo() {
        if (this.repositoryId2ServerRepo == null) {
            HashMap<UUID, ServerRepo> m = new HashMap<UUID, ServerRepo>();
            for (ServerRepo serverRepo : this.getServerRepos()) {
                m.put(serverRepo.getRepositoryId(), serverRepo);
            }
            this.repositoryId2ServerRepo = Collections.unmodifiableMap(m);
        }
        return this.repositoryId2ServerRepo;
    }

    @Override
    protected void preRead() {
        this.version = null;
    }

    @Override
    protected void postRead() {
        if (this.version == null) {
            this.markDirty();
        }
    }

    protected ServerRegistry getServerRegistry() {
        return ServerRegistryImpl.getInstance();
    }

    @Override
    protected void readPayloadEntry(ZipInputStream zin, ZipEntry zipEntry) throws IOException {
        if (!PAYLOAD_ENTRY_NAME.equals(zipEntry.getName())) {
            logger.warn("readPayloadEntry: Ignoring unexpected zip-entry: {}", (Object)zipEntry.getName());
            return;
        }
        ServerRegistry serverRegistry = this.getServerRegistry();
        ServerRepoDtoConverter serverRepoDtoConverter = new ServerRepoDtoConverter();
        ServerRepoRegistryDtoIo serverRepoRegistryDtoIo = new ServerRepoRegistryDtoIo();
        ServerRepoRegistryDto serverRepoRegistryDto = (ServerRepoRegistryDto)serverRepoRegistryDtoIo.deserialize(zin);
        for (ServerRepoDto serverRepoDto : serverRepoRegistryDto.getServerRepoDtos()) {
            ServerRepo serverRepo = serverRepoDtoConverter.fromServerRepoDto(serverRepoDto);
            this.serverRepos.add(serverRepo);
        }
        this.deletedServerRepoIds.clear();
        this.deletedServerRepoIds.addAll(serverRepoRegistryDto.getDeletedServerRepoIds());
        this.version = serverRepoRegistryDto.getVersion();
    }

    @Override
    public List<ServerRepo> getServerReposOfServer(Uid serverId) {
        AssertUtil.assertNotNull((String)"serverId", (Object)serverId);
        ArrayList<ServerRepo> result = new ArrayList<ServerRepo>();
        for (ServerRepo serverRepo : this.getServerRepos()) {
            if (!serverId.equals((Object)serverRepo.getServerId())) continue;
            result.add(serverRepo);
        }
        return result;
    }

    @Override
    public ServerRepo createServerRepo(UUID repositoryId) {
        return new ServerRepoImpl(repositoryId);
    }

    @Override
    public ServerRepo getServerRepo(UUID repositoryId) {
        AssertUtil.assertNotNull((String)"repositoryId", (Object)repositoryId);
        for (ServerRepo serverRepo : this.getServerRepos()) {
            if (!repositoryId.equals(serverRepo.getRepositoryId())) continue;
            return serverRepo;
        }
        return null;
    }

    public static ServerRepoRegistry getInstance() {
        return Holder.instance;
    }

    @Override
    public List<ServerRepo> getServerRepos() {
        return this.serverRepos;
    }

    @Override
    protected void writePayload(ZipOutputStream zout) throws IOException {
        ServerRepoRegistryDtoIo serverRepoRegistryDtoIo = new ServerRepoRegistryDtoIo();
        ServerRepoRegistryDto serverRepoRegistryDto = this.createServerRepoListDto();
        zout.putNextEntry(new ZipEntry(PAYLOAD_ENTRY_NAME));
        serverRepoRegistryDtoIo.serialize(serverRepoRegistryDto, zout);
        zout.closeEntry();
    }

    private ServerRepoRegistryDto createServerRepoListDto() {
        ServerRepoDtoConverter converter = new ServerRepoDtoConverter();
        ServerRepoRegistryDto result = new ServerRepoRegistryDto();
        for (ServerRepo serverRepo : this.serverRepos) {
            ServerRepoDto serverRepoDto = converter.toServerRepoDto(serverRepo);
            result.getServerRepoDtos().add(serverRepoDto);
        }
        result.getDeletedServerRepoIds().addAll(this.deletedServerRepoIds);
        result.setVersion(this.version);
        return result;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(ServerRepoRegistry.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(ServerRepoRegistry.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(ServerRepoRegistry.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }

    @Override
    protected void mergeFrom(ZipInputStream zin, ZipEntry zipEntry) {
        ServerRepoRegistryDtoIo serverRepoRegistryDtoIo = new ServerRepoRegistryDtoIo();
        ServerRepoRegistryDto serverRepoRegistryDto = (ServerRepoRegistryDto)serverRepoRegistryDtoIo.deserialize(zin);
        this.mergeFrom(serverRepoRegistryDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void mergeFrom(ServerRepoRegistryDto serverRepoRegistryDto) {
        AssertUtil.assertNotNull((String)"serverRepoRegistryDto", (Object)serverRepoRegistryDto);
        HashSet<UUID> deletedServerRepoIdSet = new HashSet<UUID>(this.deletedServerRepoIds.size());
        for (DeletedUUID deletedUUID : this.deletedServerRepoIds) {
            deletedServerRepoIdSet.add(deletedUUID.getUuid());
        }
        ArrayList<ServerRepoDto> newServerRepoDtos = new ArrayList<ServerRepoDto>(serverRepoRegistryDto.getServerRepoDtos().size());
        for (ServerRepoDto serverRepoDto : serverRepoRegistryDto.getServerRepoDtos()) {
            UUID repositoryId = (UUID)AssertUtil.assertNotNull((String)"serverRepoDto.repositoryId", (Object)serverRepoDto.getRepositoryId());
            if (deletedServerRepoIdSet.contains(repositoryId)) continue;
            ServerRepo serverRepo = this.getRepositoryId2ServerRepo().get(repositoryId);
            if (serverRepo == null) {
                newServerRepoDtos.add(serverRepoDto);
                continue;
            }
            this.merge(serverRepo, serverRepoDto);
        }
        HashSet<DeletedUUID> hashSet = new HashSet<DeletedUUID>(serverRepoRegistryDto.getDeletedServerRepoIds());
        hashSet.removeAll(this.deletedServerRepoIds);
        HashMap<DeletedUUID, ServerRepo> newDeletedServerRepos = new HashMap<DeletedUUID, ServerRepo>(hashSet.size());
        for (DeletedUUID deletedServerRepoId : hashSet) {
            ServerRepo serverRepo = this.getRepositoryId2ServerRepo().get(deletedServerRepoId.getUuid());
            if (serverRepo == null) continue;
            newDeletedServerRepos.put(deletedServerRepoId, serverRepo);
        }
        ServerRepoDtoConverter serverRepoDtoConverter = new ServerRepoDtoConverter();
        for (ServerRepoDto serverRepoDto : newServerRepoDtos) {
            ServerRepo serverRepo = serverRepoDtoConverter.fromServerRepoDto(serverRepoDto);
            this.serverRepos.add(serverRepo);
        }
        this.suppressAddToDeletedServerRepoIds.set(Boolean.TRUE);
        try {
            for (Map.Entry entry : newDeletedServerRepos.entrySet()) {
                this.serverRepos.remove(entry.getValue());
                this.deletedServerRepoIds.add((DeletedUUID)entry.getKey());
            }
        }
        finally {
            this.suppressAddToDeletedServerRepoIds.remove();
        }
        this.writeIfNeeded();
    }

    private void merge(ServerRepo toServerRepo, ServerRepoDto fromServerRepoDto) {
        AssertUtil.assertNotNull((String)"toServerRepo", (Object)toServerRepo);
        AssertUtil.assertNotNull((String)"fromServerRepoDto", (Object)fromServerRepoDto);
        if (toServerRepo.getChanged().before(fromServerRepoDto.getChanged())) {
            toServerRepo.setName(fromServerRepoDto.getName());
            toServerRepo.setServerId(fromServerRepoDto.getServerId());
            toServerRepo.setUserId(fromServerRepoDto.getUserId());
            toServerRepo.setChanged(fromServerRepoDto.getChanged());
            if (!toServerRepo.getChanged().equals(fromServerRepoDto.getChanged())) {
                throw new IllegalStateException("toServerRepo.changed != fromServerRepoDto.changed");
            }
        }
    }

    public Uid getVersion() {
        return this.version;
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    private class PostModificationListener
    implements StandardPostModificationListener {
        private PostModificationListener() {
        }

        @Override
        public void modificationOccurred(StandardPostModificationEvent event) {
            ServerRepoRegistryImpl.this.markDirty();
            ServerRepoRegistryImpl.this.firePropertyChange(ServerRepoRegistry.PropertyEnum.serverRepos, null, ServerRepoRegistryImpl.this.getServerRepos());
        }
    }

    private class PreModificationListener
    implements StandardPreModificationListener {
        private PreModificationListener() {
        }

        @Override
        public void modificationOccurring(StandardPreModificationEvent event) {
            block6: {
                Collection changeCollection;
                block8: {
                    block7: {
                        block5: {
                            changeCollection = event.getChangeCollection();
                            if ((0x3F & event.getType()) == 0) break block5;
                            for (ServerRepo serverRepo : changeCollection) {
                                if (ServerRepoRegistryImpl.this.getRepositoryId2ServerRepo().get(serverRepo.getRepositoryId()) != null) {
                                    throw new UnsupportedOperationException(String.format("Cannot add the same ServerRepo (repositoryId=%s) twice!", serverRepo.getRepositoryId()));
                                }
                                serverRepo.addPropertyChangeListener(ServerRepoRegistryImpl.this.serverRepoPropertyChangeListener);
                                ServerRepoRegistryImpl.this.removeDeletedServerRepoId(serverRepo.getRepositoryId());
                            }
                            break block6;
                        }
                        if ((0x3F00 & event.getType()) == 0) break block7;
                        for (ServerRepo serverRepo : changeCollection) {
                            serverRepo.removePropertyChangeListener(ServerRepoRegistryImpl.this.serverRepoPropertyChangeListener);
                            ServerRepoRegistryImpl.this.addToDeletedServerRepoIds(serverRepo.getRepositoryId());
                        }
                        break block6;
                    }
                    if ((0x8000 & event.getType()) == 0) break block8;
                    for (ServerRepo serverRepo : ServerRepoRegistryImpl.this.serverRepos) {
                        serverRepo.removePropertyChangeListener(ServerRepoRegistryImpl.this.serverRepoPropertyChangeListener);
                        ServerRepoRegistryImpl.this.addToDeletedServerRepoIds(serverRepo.getRepositoryId());
                    }
                    break block6;
                }
                if ((0x4000 & event.getType()) == 0) break block6;
                for (ServerRepo serverRepo : ServerRepoRegistryImpl.this.serverRepos) {
                    if (changeCollection.contains(serverRepo)) continue;
                    serverRepo.removePropertyChangeListener(ServerRepoRegistryImpl.this.serverRepoPropertyChangeListener);
                    ServerRepoRegistryImpl.this.addToDeletedServerRepoIds(serverRepo.getRepositoryId());
                }
            }
        }
    }

    private static final class Holder {
        public static final ServerRepoRegistryImpl instance = new ServerRepoRegistryImpl();

        private Holder() {
        }
    }
}

