/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.user;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.subshare.core.dto.SignatureDto;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpEncoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.sign.Signature;
import org.subshare.core.user.UserRepoKey;
import org.subshare.crypto.CryptoRegistry;

public class UserRepoKeyImpl
implements UserRepoKey {
    private final Uid userRepoKeyId;
    private final UUID serverRepositoryId;
    private final AsymmetricCipherKeyPair keyPair;
    private final Date validTo;
    private final boolean invitation;
    private PublicKeyWithSignatureImpl publicKey;
    private final byte[] encryptedSignedPrivateKeyData;
    private final byte[] signedPublicKeyData;

    public UserRepoKeyImpl(UUID serverRepositoryId, AsymmetricCipherKeyPair keyPair, Set<PgpKey> pgpKeysForEncryption, PgpKey pgpKeyForSignature, Date validTo) {
        this.userRepoKeyId = new Uid();
        this.serverRepositoryId = (UUID)AssertUtil.assertNotNull((String)"serverRepositoryId", (Object)serverRepositoryId);
        this.keyPair = (AsymmetricCipherKeyPair)AssertUtil.assertNotNull((String)"keyPair", (Object)keyPair);
        this.validTo = validTo;
        AssertUtil.assertNotNull((String)"pgpKeysForEncryption", pgpKeysForEncryption);
        AssertUtil.assertNotNull((String)"pgpKeyForSignature", (Object)pgpKeyForSignature);
        this.encryptedSignedPrivateKeyData = this.encryptSignPrivateKeyData(pgpKeysForEncryption, pgpKeyForSignature);
        this.signedPublicKeyData = this.signPublicKeyData(pgpKeyForSignature);
        this.invitation = pgpKeysForEncryption.size() != 1 || pgpKeysForEncryption.iterator().next() != pgpKeyForSignature;
    }

    public UserRepoKeyImpl(Uid userRepoKeyId, UUID serverRepositoryId, byte[] encryptedSignedPrivateKeyData, byte[] signedPublicKeyData, Date validTo, boolean invitation) {
        this.userRepoKeyId = (Uid)AssertUtil.assertNotNull((String)"userRepoKeyId", (Object)userRepoKeyId);
        this.serverRepositoryId = (UUID)AssertUtil.assertNotNull((String)"serverRepositoryId", (Object)serverRepositoryId);
        this.encryptedSignedPrivateKeyData = (byte[])AssertUtil.assertNotNull((String)"encryptedSignedPrivateKeyData", (Object)encryptedSignedPrivateKeyData);
        this.signedPublicKeyData = (byte[])AssertUtil.assertNotNull((String)"signedPublicKeyData", (Object)signedPublicKeyData);
        this.validTo = validTo;
        this.invitation = invitation;
        this.keyPair = new AsymmetricCipherKeyPair(this.verifyPublicKeyData(), this.decryptVerifyPrivateKeyData());
    }

    @Override
    public Uid getUserRepoKeyId() {
        return this.userRepoKeyId;
    }

    @Override
    public UUID getServerRepositoryId() {
        return this.serverRepositoryId;
    }

    @Override
    public AsymmetricCipherKeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public UserRepoKey.PublicKeyWithSignature getPublicKey() {
        if (this.publicKey == null) {
            this.publicKey = new PublicKeyWithSignatureImpl(this.getUserRepoKeyId(), this.getServerRepositoryId(), this.getKeyPair().getPublic(), this.getSignedPublicKeyData(), this.getValidTo(), this.isInvitation());
        }
        return this.publicKey;
    }

    @Override
    public boolean isInvitation() {
        return this.invitation;
    }

    @Override
    public Date getValidTo() {
        return this.validTo;
    }

    private byte[] encryptSignPrivateKeyData(Set<PgpKey> pgpKeysForEncryption, PgpKey pgpKeyForSignature) {
        if (pgpKeysForEncryption.size() == 1 && PgpKey.TEST_DUMMY_PGP_KEY == pgpKeysForEncryption.iterator().next()) {
            return new byte[0];
        }
        AssertUtil.assertNotNull((String)"pgpKeysForEncryption", pgpKeysForEncryption);
        AssertUtil.assertNotNull((String)"pgpKeyForSignature", (Object)pgpKeyForSignature);
        byte[] encodedPrivateKey = CryptoRegistry.getInstance().encodePrivateKey((CipherParameters)this.keyPair.getPrivate());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PgpEncoder encoder = PgpRegistry.getInstance().getPgpOrFail().createEncoder((IInputStream)new ByteArrayInputStream(encodedPrivateKey), (IOutputStream)out);
        encoder.getEncryptPgpKeys().addAll(pgpKeysForEncryption);
        encoder.setSignPgpKey(pgpKeyForSignature);
        try {
            encoder.encode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    private AsymmetricKeyParameter decryptVerifyPrivateKeyData() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PgpDecoder decoder = PgpRegistry.getInstance().getPgpOrFail().createDecoder((IInputStream)new ByteArrayInputStream(this.encryptedSignedPrivateKeyData), (IOutputStream)out);
        try {
            decoder.decode();
            if (decoder.getPgpSignature() == null) {
                throw new SignatureException("Missing signature!");
            }
            byte[] privateKeyData = out.toByteArray();
            AsymmetricKeyParameter privateKey = CryptoRegistry.getInstance().decodePrivateKey(privateKeyData);
            return privateKey;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] signPublicKeyData(PgpKey pgpKey) {
        if (PgpKey.TEST_DUMMY_PGP_KEY == pgpKey) {
            return new byte[0];
        }
        AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
        byte[] encodedPublicKey = CryptoRegistry.getInstance().encodePublicKey((CipherParameters)this.keyPair.getPublic());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PgpEncoder encoder = PgpRegistry.getInstance().getPgpOrFail().createEncoder((IInputStream)new ByteArrayInputStream(encodedPublicKey), (IOutputStream)out);
        encoder.setSignPgpKey(pgpKey);
        try {
            encoder.encode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    private AsymmetricKeyParameter verifyPublicKeyData() throws SignatureException {
        return UserRepoKeyImpl.verifyPublicKeyData(this.signedPublicKeyData);
    }

    private static AsymmetricKeyParameter verifyPublicKeyData(byte[] signedPublicKeyData) throws SignatureException {
        AssertUtil.assertNotNull((String)"signedPublicKeyData", (Object)signedPublicKeyData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PgpDecoder decoder = PgpRegistry.getInstance().getPgpOrFail().createDecoder((IInputStream)new ByteArrayInputStream(signedPublicKeyData), (IOutputStream)out);
        try {
            decoder.decode();
            if (decoder.getPgpSignature() == null) {
                throw new SignatureException("Missing signature!");
            }
            byte[] publicKeyData = out.toByteArray();
            AsymmetricKeyParameter publicKey = CryptoRegistry.getInstance().decodePublicKey(publicKeyData);
            return publicKey;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getEncryptedSignedPrivateKeyData() {
        return this.encryptedSignedPrivateKeyData;
    }

    @Override
    public byte[] getSignedPublicKeyData() {
        return this.signedPublicKeyData;
    }

    public String toString() {
        return String.format("%s[userRepoKeyId=%s, invitation=%s]", this.getClass().getSimpleName(), this.userRepoKeyId, this.invitation);
    }

    public static class PublicKeyWithSignatureImpl
    extends PublicKeyImpl
    implements UserRepoKey.PublicKeyWithSignature {
        private final byte[] signedPublicKeyData;
        private byte[] publicKeyData;
        private Signature signature;

        protected PublicKeyWithSignatureImpl(Uid userRepoKeyId, UUID serverRepositoryId, AsymmetricKeyParameter publicKey, byte[] signedPublicKeyData, Date validTo, boolean invitation) {
            super(userRepoKeyId, serverRepositoryId, publicKey, validTo, invitation);
            this.signedPublicKeyData = (byte[])AssertUtil.assertNotNull((String)"signedPublicKeyData", (Object)signedPublicKeyData);
        }

        public PublicKeyWithSignatureImpl(Uid userRepoKeyId, UUID repositoryId, byte[] signedPublicKeyData, Date validTo, boolean invitation) {
            super(userRepoKeyId, repositoryId, UserRepoKeyImpl.verifyPublicKeyData(signedPublicKeyData), validTo, invitation);
            this.signedPublicKeyData = (byte[])AssertUtil.assertNotNull((String)"signedPublicKeyData", (Object)signedPublicKeyData);
        }

        @Override
        public byte[] getSignedPublicKeyData() {
            return this.signedPublicKeyData;
        }

        @Override
        public byte[] getPublicKeyData() {
            if (this.publicKeyData == null) {
                this.publicKeyData = CryptoRegistry.getInstance().encodePublicKey((CipherParameters)this.getPublicKey());
            }
            return this.publicKeyData;
        }

        @Override
        public String getSignedDataType() {
            return "PublicKey";
        }

        @Override
        public int getSignedDataVersion() {
            return 0;
        }

        @Override
        public InputStream getSignedData(int signedDataVersion) {
            try {
                byte separatorIndex = 0;
                InputStreamSource[] inputStreamSourceArray = new InputStreamSource[5];
                inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource(this.getUserRepoKeyId());
                separatorIndex = (byte)(separatorIndex + 1);
                inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
                inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource(this.getServerRepositoryId());
                separatorIndex = (byte)(separatorIndex + 1);
                inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource(separatorIndex);
                inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource(this.getPublicKeyData());
                return new MultiInputStream(inputStreamSourceArray);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }

        @Override
        public Signature getSignature() {
            return this.signature;
        }

        @Override
        public void setSignature(Signature signature) {
            if (!Util.equal((Object)this.signature, (Object)signature)) {
                this.signature = SignatureDto.copyIfNeeded(signature);
            }
        }
    }

    public static class PublicKeyImpl
    implements UserRepoKey.PublicKey {
        private final Uid userRepoKeyId;
        private final UUID serverRepositoryId;
        private final AsymmetricKeyParameter publicKey;
        private final Date validTo;
        private final boolean invitation;

        public PublicKeyImpl(Uid userRepoKeyId, UUID serverRepositoryId, AsymmetricKeyParameter publicKey, Date validTo, boolean invitation) {
            this.userRepoKeyId = (Uid)AssertUtil.assertNotNull((String)"userRepoKeyId", (Object)userRepoKeyId);
            this.serverRepositoryId = (UUID)AssertUtil.assertNotNull((String)"serverRepositoryId", (Object)serverRepositoryId);
            this.publicKey = (AsymmetricKeyParameter)AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
            this.validTo = validTo;
            this.invitation = invitation;
        }

        @Override
        public Uid getUserRepoKeyId() {
            return this.userRepoKeyId;
        }

        @Override
        public UUID getServerRepositoryId() {
            return this.serverRepositoryId;
        }

        @Override
        public AsymmetricKeyParameter getPublicKey() {
            return this.publicKey;
        }

        @Override
        public Date getValidTo() {
            return this.validTo;
        }

        @Override
        public boolean isInvitation() {
            return this.invitation;
        }

        public String toString() {
            return String.format("%s[userRepoKeyId=%s, invitation=%s, validTo=%s]", this.getClass().getSimpleName(), this.userRepoKeyId, this.invitation, this.validTo);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            PublicKeyImpl other = (PublicKeyImpl)obj;
            return this.userRepoKeyId.equals((Object)other.getUserRepoKeyId());
        }

        public int hashCode() {
            return this.userRepoKeyId.hashCode();
        }
    }
}

