/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.client.request;

import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.dto.RemoteException;
import co.codewizards.cloudstore.core.dto.RemoteExceptionUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.UrlEncoder;
import co.codewizards.cloudstore.rest.client.CloudStoreRestClient;
import co.codewizards.cloudstore.rest.client.request.Request;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequest<R>
implements Request<R> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRequest.class);
    private CloudStoreRestClient cloudStoreRestClient;

    @Override
    public CloudStoreRestClient getCloudStoreRestClient() {
        return this.cloudStoreRestClient;
    }

    @Override
    public void setCloudStoreRestClient(CloudStoreRestClient cloudStoreRestClient) {
        this.cloudStoreRestClient = cloudStoreRestClient;
    }

    protected CloudStoreRestClient getCloudStoreRestClientOrFail() {
        CloudStoreRestClient cloudStoreRestClient = this.getCloudStoreRestClient();
        AssertUtil.assertNotNull((String)"cloudStoreRestClient", (Object)cloudStoreRestClient);
        return cloudStoreRestClient;
    }

    protected void handleException(RuntimeException x) {
        this.getCloudStoreRestClientOrFail().handleAndRethrowException(x);
    }

    protected Invocation.Builder assignCredentials(Invocation.Builder builder) {
        return this.getCloudStoreRestClientOrFail().assignCredentials(builder);
    }

    protected String getPath(Class<?> dtoClass) {
        return "_" + dtoClass.getSimpleName();
    }

    protected static String urlEncode(String string) {
        AssertUtil.assertNotNull((String)"string", (Object)string);
        return UrlEncoder.encode((String)string);
    }

    protected WebTarget createWebTarget(String ... pathSegments) {
        Client client = this.getClientOrFail();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseURL());
        boolean first = true;
        if (pathSegments != null && pathSegments.length != 0) {
            for (String pathSegment : pathSegments) {
                if (!first) {
                    sb.append('/');
                }
                first = false;
                sb.append(pathSegment);
            }
        }
        WebTarget webTarget = client.target(URI.create(sb.toString()));
        return webTarget;
    }

    protected String getBaseURL() {
        return this.getCloudStoreRestClientOrFail().getBaseUrl();
    }

    protected Client getClientOrFail() {
        return this.getCloudStoreRestClientOrFail().getClientOrFail();
    }

    protected String encodePath(String path) {
        String[] segments;
        AssertUtil.assertNotNull((String)"path", (Object)path);
        StringBuilder sb = new StringBuilder();
        for (String segment : segments = path.split("/")) {
            if (segment.isEmpty()) continue;
            if (sb.length() != 0) {
                sb.append('/');
            }
            sb.append(AbstractRequest.urlEncode(segment));
        }
        return sb.toString();
    }

    protected void assertResponseIndicatesSuccess(Response response) {
        if (400 <= response.getStatus() && response.getStatus() <= 599) {
            response.bufferEntity();
            if (response.hasEntity()) {
                Error error = null;
                try {
                    error = (Error)response.readEntity(Error.class);
                }
                catch (Exception y) {
                    logger.error("handleException: " + y, (Throwable)y);
                }
                if (error != null) {
                    this.throwOriginalExceptionIfPossible(error);
                    throw new RemoteException(error);
                }
            }
            throw new WebApplicationException(response);
        }
    }

    protected void throwOriginalExceptionIfPossible(Error error) {
        RemoteExceptionUtil.throwOriginalExceptionIfPossible((Error)error);
    }
}

