/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.repo.local.DaoProvider;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.identity.LongIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Dao<E extends Entity, D extends Dao<E, D>>
implements ContextWithPersistenceManager {
    private final Logger logger;
    private final Class<E> entityClass;
    private final Class<D> daoClass;
    private DaoProvider daoProvider;
    private PersistenceManager pm;
    private final Map<Class<? extends Dao<?, ?>>, Dao<?, ?>> daoClass2DaoInstance = new HashMap(3);

    public Dao() {
        Class k;
        Class c;
        Type[] actualTypeArguments = ReflectionUtil.resolveActualTypeArguments(Dao.class, (Object)this);
        if (!(actualTypeArguments[0] instanceof Class)) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " misses generic type info for 'E'!");
        }
        this.entityClass = c = (Class)actualTypeArguments[0];
        if (this.entityClass == null) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " has no generic type argument!");
        }
        if (!(actualTypeArguments[1] instanceof Class)) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " misses generic type info for 'D'!");
        }
        this.daoClass = k = (Class)actualTypeArguments[1];
        if (this.daoClass == null) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " has no generic type argument!");
        }
        this.logger = LoggerFactory.getLogger((String)String.format("%s<%s>", Dao.class.getName(), this.entityClass.getSimpleName()));
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public void setPersistenceManager(PersistenceManager persistenceManager) {
        if (this.pm != persistenceManager) {
            this.daoClass2DaoInstance.clear();
            this.pm = persistenceManager;
        }
    }

    protected PersistenceManager pm() {
        if (this.pm == null) {
            throw new IllegalStateException("persistenceManager not assigned!");
        }
        return this.pm;
    }

    public DaoProvider getDaoProvider() {
        return this.daoProvider;
    }

    public void setDaoProvider(DaoProvider daoProvider) {
        this.daoProvider = daoProvider;
    }

    public D persistenceManager(PersistenceManager persistenceManager) {
        this.setPersistenceManager(persistenceManager);
        return this.thisDao();
    }

    protected D thisDao() {
        return (D)((Dao)this.daoClass.cast(this));
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public E getObjectByIdOrFail(long id) throws JDOObjectNotFoundException {
        return this.getObjectById(id, true);
    }

    public E getObjectByIdOrNull(long id) {
        return this.getObjectById(id, false);
    }

    private E getObjectById(long id, boolean throwExceptionIfNotFound) throws JDOObjectNotFoundException {
        try {
            Object result = this.pm().getObjectById((Object)new LongIdentity(this.entityClass, id));
            return (E)((Entity)this.entityClass.cast(result));
        }
        catch (JDOObjectNotFoundException x) {
            if (throwExceptionIfNotFound) {
                throw x;
            }
            return null;
        }
    }

    public Collection<E> getObjects() {
        ArrayList result = new ArrayList();
        Iterator iterator = this.pm().getExtent(this.entityClass).iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public long getObjectsCount() {
        Query query = this.pm().newQuery(this.entityClass);
        query.setResult("count(this)");
        Long result = (Long)query.execute();
        if (result == null) {
            throw new IllegalStateException("Query for count(this) returned null!");
        }
        return result;
    }

    public <P extends E> P makePersistent(P entity) {
        AssertUtil.assertNotNull((String)"entity", entity);
        try {
            Entity result = (Entity)this.pm().makePersistent(entity);
            this.logger.debug("makePersistent: entityID={}", JDOHelper.getObjectId((Object)result));
            return (P)result;
        }
        catch (RuntimeException x) {
            this.logger.warn("makePersistent: FAILED for entityID={}: {}", JDOHelper.getObjectId(entity), (Object)x);
            throw x;
        }
    }

    public void deletePersistent(E entity) {
        AssertUtil.assertNotNull((String)"entity", entity);
        this.logger.debug("deletePersistent: entityID={}", JDOHelper.getObjectId(entity));
        this.pm().deletePersistent(entity);
    }

    public void deletePersistentAll(Collection<? extends E> entities) {
        AssertUtil.assertNotNull((String)"entities", entities);
        if (this.logger.isDebugEnabled()) {
            for (Entity entity : entities) {
                this.logger.debug("deletePersistentAll: entityID={}", JDOHelper.getObjectId((Object)entity));
            }
        }
        this.pm().deletePersistentAll(entities);
    }

    protected Collection<E> load(Collection<E> entities) {
        AssertUtil.assertNotNull((String)"entities", entities);
        ArrayList result = new ArrayList();
        HashMap entityClass2EntityIDs = new HashMap();
        for (Entity entity : entities) {
            HashSet<Long> entityIDs = (HashSet<Long>)entityClass2EntityIDs.get(entity.getClass());
            if (entityIDs == null) {
                entityIDs = new HashSet<Long>();
                entityClass2EntityIDs.put(entity.getClass(), entityIDs);
            }
            entityIDs.add(entity.getId());
        }
        for (Map.Entry entry : entityClass2EntityIDs.entrySet()) {
            Class entityClass = (Class)entry.getKey();
            Query query = this.pm().newQuery(this.pm().getExtent(entityClass, false));
            query.setFilter(":entityIDs.contains(this.id)");
            Set entityIDs = (Set)entry.getValue();
            int idx = -1;
            HashSet<Long> entityIDSubSet = new HashSet<Long>(300);
            for (Long entityID : entityIDs) {
                entityIDSubSet.add(entityID);
                if (++idx <= 200) continue;
                idx = -1;
                this.populateLoadResult(result, query, entityIDSubSet);
            }
            this.populateLoadResult(result, query, entityIDSubSet);
        }
        return result;
    }

    private void populateLoadResult(Collection<E> result, Query query, Set<Long> entityIDSubSet) {
        if (entityIDSubSet.isEmpty()) {
            return;
        }
        Collection c = (Collection)query.execute(entityIDSubSet);
        result.addAll(c);
        query.closeAll();
        entityIDSubSet.clear();
    }

    protected <T extends Dao<?, ?>> T getDao(Class<T> daoClass) {
        AssertUtil.assertNotNull((String)"daoClass", daoClass);
        DaoProvider daoProvider = this.getDaoProvider();
        if (daoProvider != null) {
            return (T)((Dao)daoProvider.getDao(daoClass));
        }
        Dao dao = (Dao)daoClass.cast(this.daoClass2DaoInstance.get(daoClass));
        if (dao == null) {
            try {
                dao = (Dao)daoClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            dao.setPersistenceManager(this.pm);
            this.daoClass2DaoInstance.put(daoClass, dao);
        }
        return (T)dao;
    }
}

