/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Modification;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import java.util.Collection;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModificationDao
extends Dao<Modification, ModificationDao> {
    private static final Logger logger = LoggerFactory.getLogger(ModificationDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Modification> getModificationsAfter(RemoteRepository remoteRepository, long localRevision) {
        AssertUtil.assertNotNull((String)"remoteRepository", (Object)remoteRepository);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getModificationsAfter_remoteRepository_localRevision");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection<Modification> modifications = (Collection<Modification>)query.execute((Object)remoteRepository, (Object)localRevision);
            logger.debug("getModificationsAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            modifications = this.load(modifications);
            logger.debug("getModificationsAfter: Loading result-set with {} elements took {} ms.", (Object)modifications.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection<Modification> collection = modifications;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Modification> getModificationsBeforeOrEqual(RemoteRepository remoteRepository, long localRevision) {
        AssertUtil.assertNotNull((String)"remoteRepository", (Object)remoteRepository);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getModificationsBeforeOrEqual_remoteRepository_localRevision");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection<Modification> modifications = (Collection<Modification>)query.execute((Object)remoteRepository, (Object)localRevision);
            logger.debug("getModificationsBeforeOrEqual: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            modifications = this.load(modifications);
            logger.debug("getModificationsBeforeOrEqual: Loading result-set with {} elements took {} ms.", (Object)modifications.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection<Modification> collection = modifications;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public Collection<Modification> getModifications(RemoteRepository remoteRepository) {
        return this.getModificationsAfter(remoteRepository, -1L);
    }
}

