/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.ReadUserIdentityAccessDeniedException;
import org.subshare.core.crypto.KeyFactory;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.dto.UserIdentityPayloadDto;
import org.subshare.core.dto.UserRepoKeyPublicKeyDto;
import org.subshare.core.dto.jaxb.UserIdentityPayloadDtoIo;
import org.subshare.core.pgp.MissingSigningPgpKeyException;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.sign.Signable;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistry;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyPublicKeyDtoWithSignatureConverter;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.local.CryptreeContext;
import org.subshare.local.CryptreeNodeUtil;
import org.subshare.local.PlainUserIdentity;
import org.subshare.local.persistence.InvitationUserRepoKeyPublicKey;
import org.subshare.local.persistence.Permission;
import org.subshare.local.persistence.PermissionDao;
import org.subshare.local.persistence.RepositoryOwner;
import org.subshare.local.persistence.UserIdentity;
import org.subshare.local.persistence.UserIdentityDao;
import org.subshare.local.persistence.UserIdentityLink;
import org.subshare.local.persistence.UserIdentityLinkDao;
import org.subshare.local.persistence.UserRepoKeyPublicKey;
import org.subshare.local.persistence.UserRepoKeyPublicKeyDao;

public class UserRepoKeyPublicKeyHelper {
    private static final Logger logger = LoggerFactory.getLogger(UserRepoKeyPublicKeyHelper.class);
    private final CryptreeContext context;

    public UserRepoKeyPublicKeyHelper(CryptreeContext context) {
        this.context = (CryptreeContext)AssertUtil.assertNotNull((String)"context", (Object)context);
    }

    public CryptreeContext getContext() {
        return this.context;
    }

    public UserRepoKeyPublicKey getUserRepoKeyPublicKeyOrCreate(UserRepoKey.PublicKey publicKey) {
        AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)this.context.transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserRepoKeyPublicKey userRepoKeyPublicKey = urkpkDao.getUserRepoKeyPublicKey(publicKey.getUserRepoKeyId());
        if (userRepoKeyPublicKey == null) {
            userRepoKeyPublicKey = this.createUserRepoKeyPublicKey(publicKey);
        }
        return userRepoKeyPublicKey;
    }

    private UserRepoKeyPublicKey createUserRepoKeyPublicKey(UserRepoKey.PublicKey publicKey) {
        UserRepoKeyPublicKey userRepoKeyPublicKey;
        AssertUtil.assertNotNull((String)"publicKey", (Object)publicKey);
        UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)this.context.transaction.getDao(UserRepoKeyPublicKeyDao.class));
        if (publicKey.isInvitation()) {
            UserRepoKey.PublicKeyWithSignature publicKeyWithSignature = (UserRepoKey.PublicKeyWithSignature)publicKey;
            userRepoKeyPublicKey = (UserRepoKeyPublicKey)urkpkDao.makePersistent(new InvitationUserRepoKeyPublicKey(publicKeyWithSignature));
        } else {
            userRepoKeyPublicKey = (UserRepoKeyPublicKey)urkpkDao.makePersistent(new UserRepoKeyPublicKey(publicKey));
        }
        this.createUserIdentities(userRepoKeyPublicKey);
        return userRepoKeyPublicKey;
    }

    public void createMissingUserIdentities() {
        boolean hasPermission;
        try {
            this.getUserRepoKeyWithReadUserIdentityPermissionOrFail();
            hasPermission = true;
        }
        catch (ReadUserIdentityAccessDeniedException x) {
            hasPermission = false;
        }
        UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)this.context.transaction.getDao(UserRepoKeyPublicKeyDao.class));
        for (UserRepoKeyPublicKey userRepoKeyPublicKey : urkpkDao.getObjects()) {
            UserRepoKey userRepoKey;
            if (!hasPermission && (userRepoKey = this.getContext().userRepoKeyRing.getUserRepoKey(userRepoKeyPublicKey.getUserRepoKeyId())) == null) continue;
            this.createUserIdentities(userRepoKeyPublicKey);
        }
    }

    private void createUserIdentities(UserRepoKeyPublicKey userRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"userRepoKeyPublicKey", (Object)((Object)userRepoKeyPublicKey));
        Set<UserRepoKeyPublicKey> forUserRepoKeyPublicKeys = this.getForUserRepoKeyPublicKeysForUserIdentityLinkCreation(userRepoKeyPublicKey);
        for (UserRepoKeyPublicKey forUserRepoKeyPublicKey : forUserRepoKeyPublicKeys) {
            this.getUserIdentityLinkOrCreate(userRepoKeyPublicKey, forUserRepoKeyPublicKey);
        }
    }

    private Set<UserRepoKeyPublicKey> getForUserRepoKeyPublicKeysForUserIdentityLinkCreation(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        PermissionDao pDao = (PermissionDao)((Object)this.context.transaction.getDao(PermissionDao.class));
        HashSet<UserRepoKeyPublicKey> forUserRepoKeyPublicKeys = new HashSet<UserRepoKeyPublicKey>();
        for (Permission permission : pDao.getNonRevokedPermissions(PermissionType.readUserIdentity)) {
            forUserRepoKeyPublicKeys.add(permission.getUserRepoKeyPublicKey());
        }
        RepositoryOwner repositoryOwner = this.context.getRepositoryOwner();
        if (repositoryOwner != null) {
            forUserRepoKeyPublicKeys.add(repositoryOwner.getUserRepoKeyPublicKey());
        }
        forUserRepoKeyPublicKeys.add(ofUserRepoKeyPublicKey);
        LinkedHashSet<UserRepoKeyPublicKey> result = new LinkedHashSet<UserRepoKeyPublicKey>(forUserRepoKeyPublicKeys.size());
        for (UserRepoKeyPublicKey forUserRepoKeyPublicKey : forUserRepoKeyPublicKeys) {
            if (this.context.userRepoKeyRing.getUserRepoKey(forUserRepoKeyPublicKey.getUserRepoKeyId()) == null) continue;
            result.add(forUserRepoKeyPublicKey);
        }
        result.addAll(forUserRepoKeyPublicKeys);
        return result;
    }

    public UserIdentityLink getUserIdentityLinkOrCreate(UserRepoKeyPublicKey ofUserRepoKeyPublicKey, UserRepoKeyPublicKey forUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"ofUserRepoKeyPublicKey", (Object)((Object)ofUserRepoKeyPublicKey));
        AssertUtil.assertNotNull((String)"forUserRepoKeyPublicKey", (Object)((Object)forUserRepoKeyPublicKey));
        UserIdentityLinkDao uilDao = (UserIdentityLinkDao)((Object)this.context.transaction.getDao(UserIdentityLinkDao.class));
        Collection<UserIdentityLink> userIdentityLinks = uilDao.getUserIdentityLinks(ofUserRepoKeyPublicKey, forUserRepoKeyPublicKey);
        if (!userIdentityLinks.isEmpty()) {
            return userIdentityLinks.iterator().next();
        }
        PlainUserIdentity plainUserIdentity = this.getPlainUserIdentityOrCreate(ofUserRepoKeyPublicKey);
        if (ofUserRepoKeyPublicKey.equals((Object)forUserRepoKeyPublicKey) && !(userIdentityLinks = uilDao.getUserIdentityLinks(ofUserRepoKeyPublicKey, forUserRepoKeyPublicKey)).isEmpty()) {
            return userIdentityLinks.iterator().next();
        }
        return this.createUserIdentityLink(plainUserIdentity, forUserRepoKeyPublicKey);
    }

    private UserIdentityLink createUserIdentityLink(PlainUserIdentity plainUserIdentity, UserRepoKeyPublicKey forUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"plainUserIdentity", (Object)plainUserIdentity);
        AssertUtil.assertNotNull((String)"forUserRepoKeyPublicKey", (Object)((Object)forUserRepoKeyPublicKey));
        UserIdentityLinkDao uilDao = (UserIdentityLinkDao)((Object)this.context.transaction.getDao(UserIdentityLinkDao.class));
        byte[] encryptedUserIdentityKeyData = CryptreeNodeUtil.encrypt(plainUserIdentity.getSharedSecret().getKey(), (CipherParameters)forUserRepoKeyPublicKey.getPublicKey().getPublicKey());
        UserRepoKeyPublicKey ofUserRepoKeyPublicKey = plainUserIdentity.getUserIdentity().getOfUserRepoKeyPublicKey();
        UserRepoKey userRepoKey = this.getContext().userRepoKeyRing.getUserRepoKey(ofUserRepoKeyPublicKey.getUserRepoKeyId());
        UserRepoKey signingUserRepoKey = userRepoKey != null ? userRepoKey : this.getUserRepoKeyWithReadUserIdentityPermissionOrFail();
        UserIdentityLink userIdentityLink = new UserIdentityLink();
        userIdentityLink.setUserIdentity(plainUserIdentity.getUserIdentity());
        userIdentityLink.setForUserRepoKeyPublicKey(forUserRepoKeyPublicKey);
        userIdentityLink.setEncryptedUserIdentityKeyData(encryptedUserIdentityKeyData);
        this.context.getSignableSigner(signingUserRepoKey).sign((Signable)userIdentityLink);
        return (UserIdentityLink)uilDao.makePersistent(userIdentityLink);
    }

    private PlainUserIdentity getPlainUserIdentityOrCreate(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"ofUserRepoKeyPublicKey", (Object)((Object)ofUserRepoKeyPublicKey));
        UserIdentityDao uiDao = (UserIdentityDao)((Object)this.context.transaction.getDao(UserIdentityDao.class));
        Collection<UserIdentity> userIdentities = uiDao.getUserIdentitiesOf(ofUserRepoKeyPublicKey);
        if (userIdentities.isEmpty()) {
            return this.createPlainUserIdentity(ofUserRepoKeyPublicKey);
        }
        UserIdentityLinkDao uilDao = (UserIdentityLinkDao)((Object)this.context.transaction.getDao(UserIdentityLinkDao.class));
        for (UserIdentity userIdentity : userIdentities) {
            Collection<UserIdentityLink> userIdentityLinks = uilDao.getUserIdentityLinksOf(userIdentity);
            for (UserIdentityLink userIdentityLink : userIdentityLinks) {
                UserRepoKey userRepoKey = this.getContext().userRepoKeyRing.getUserRepoKey(userIdentityLink.getForUserRepoKeyPublicKey().getUserRepoKeyId());
                if (userRepoKey == null) continue;
                byte[] userIdentityKeyData = CryptreeNodeUtil.decrypt(userIdentityLink.getEncryptedUserIdentityKeyData(), (CipherParameters)userRepoKey.getKeyPair().getPrivate());
                KeyParameter sharedSecret = new KeyParameter(userIdentityKeyData);
                return new PlainUserIdentity(userIdentity, sharedSecret);
            }
        }
        throw new ReadUserIdentityAccessDeniedException("No UserRepoKey found being able to decrypt the user-identities found: " + userIdentities);
    }

    private PlainUserIdentity createPlainUserIdentity(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"ofUserRepoKeyPublicKey", (Object)((Object)ofUserRepoKeyPublicKey));
        byte[] userIdentityPayloadDtoData = this.createUserIdentityPayloadDtoData(ofUserRepoKeyPublicKey);
        return this.createPlainUserIdentity(ofUserRepoKeyPublicKey, userIdentityPayloadDtoData);
    }

    private PlainUserIdentity createPlainUserIdentity(UserRepoKeyPublicKey ofUserRepoKeyPublicKey, byte[] userIdentityPayloadDtoData) {
        UserIdentityDao uiDao = (UserIdentityDao)((Object)this.context.transaction.getDao(UserIdentityDao.class));
        UserIdentity userIdentity = new UserIdentity();
        userIdentity.setOfUserRepoKeyPublicKey(ofUserRepoKeyPublicKey);
        KeyParameter sharedSecret = KeyFactory.getInstance().createSymmetricKey();
        userIdentity.setEncryptedUserIdentityPayloadDtoData(CryptreeNodeUtil.encrypt(userIdentityPayloadDtoData, (CipherParameters)sharedSecret));
        UserRepoKey userRepoKey = this.getContext().userRepoKeyRing.getUserRepoKey(ofUserRepoKeyPublicKey.getUserRepoKeyId());
        UserRepoKey signingUserRepoKey = userRepoKey != null ? userRepoKey : this.getUserRepoKeyWithReadUserIdentityPermissionOrFail();
        this.context.getSignableSigner(signingUserRepoKey).sign((Signable)userIdentity);
        PlainUserIdentity plainUserIdentity = new PlainUserIdentity((UserIdentity)uiDao.makePersistent(userIdentity), sharedSecret);
        this.createUserIdentityLink(plainUserIdentity, ofUserRepoKeyPublicKey);
        return plainUserIdentity;
    }

    private UserRepoKey getUserRepoKeyWithReadUserIdentityPermissionOrFail() {
        PermissionDao dao = (PermissionDao)((Object)this.context.transaction.getDao(PermissionDao.class));
        for (UserRepoKey userRepoKey : this.context.userRepoKeyRing.getPermanentUserRepoKeys(this.context.serverRepositoryId)) {
            boolean owner = this.isOwner(userRepoKey.getUserRepoKeyId());
            if (owner) {
                return userRepoKey;
            }
            Collection<Permission> permissions = dao.getValidPermissions(PermissionType.readUserIdentity, userRepoKey.getUserRepoKeyId(), new Date());
            if (permissions.isEmpty()) continue;
            return userRepoKey;
        }
        throw new ReadUserIdentityAccessDeniedException("No UserRepoKey found having 'readUserIdentity' permission!");
    }

    private boolean isOwner(Uid userRepoKeyId) {
        AssertUtil.assertNotNull((String)"userRepoKeyId", (Object)userRepoKeyId);
        return userRepoKeyId.equals((Object)this.context.getRepositoryOwnerOrFail().getUserRepoKeyPublicKey().getUserRepoKeyId());
    }

    private byte[] createUserIdentityPayloadDtoData(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        UserIdentityPayloadDto dto = this.getUserIdentityPayloadDto(ofUserRepoKeyPublicKey);
        if (dto == null) {
            dto = this.createUserIdentityPayloadDto(ofUserRepoKeyPublicKey);
        }
        return new UserIdentityPayloadDtoIo().serializeWithGz((Object)dto);
    }

    public UserIdentityPayloadDto getUserIdentityPayloadDto(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        byte[] userIdentityPayloadDtoData = this.getUserIdentityPayloadDtoData(ofUserRepoKeyPublicKey);
        if (userIdentityPayloadDtoData == null) {
            return null;
        }
        UserIdentityPayloadDtoIo userIdentityPayloadDtoIo = new UserIdentityPayloadDtoIo();
        UserIdentityPayloadDto userIdentityPayloadDto = (UserIdentityPayloadDto)userIdentityPayloadDtoIo.deserializeWithGz(userIdentityPayloadDtoData);
        return userIdentityPayloadDto;
    }

    private byte[] getUserIdentityPayloadDtoData(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"ofUserRepoKeyPublicKey", (Object)((Object)ofUserRepoKeyPublicKey));
        UserRepoKeyPublicKeyDao userRepoKeyPublicKeyDao = (UserRepoKeyPublicKeyDao)((Object)this.context.transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserIdentityLinkDao userIdentityLinkDao = (UserIdentityLinkDao)((Object)this.context.transaction.getDao(UserIdentityLinkDao.class));
        for (UserRepoKey userRepoKey : this.context.userRepoKeyRing.getUserRepoKeys(this.context.serverRepositoryId)) {
            Collection<UserIdentityLink> userIdentityLinks;
            UserRepoKeyPublicKey forUserRepoKeyPublicKey = userRepoKeyPublicKeyDao.getUserRepoKeyPublicKey(userRepoKey.getUserRepoKeyId());
            if (forUserRepoKeyPublicKey == null || (userIdentityLinks = userIdentityLinkDao.getUserIdentityLinks(ofUserRepoKeyPublicKey, forUserRepoKeyPublicKey)).isEmpty()) continue;
            UserIdentityLink userIdentityLink = userIdentityLinks.iterator().next();
            byte[] userIdentityKeyData = CryptreeNodeUtil.decrypt(userIdentityLink.getEncryptedUserIdentityKeyData(), (CipherParameters)userRepoKey.getKeyPair().getPrivate());
            KeyParameter userIdentityKey = new KeyParameter(userIdentityKeyData);
            byte[] userIdentityPayloadDtoData = CryptreeNodeUtil.decrypt(userIdentityLink.getUserIdentity().getEncryptedUserIdentityPayloadDtoData(), (CipherParameters)userIdentityKey);
            return userIdentityPayloadDtoData;
        }
        return null;
    }

    private UserIdentityPayloadDto createUserIdentityPayloadDto(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        User user = this.context.getUserRegistry().getUserByUserRepoKeyIdOrFail(ofUserRepoKeyPublicKey.getUserRepoKeyId());
        UserIdentityPayloadDto result = new UserIdentityPayloadDto();
        result.setFirstName(user.getFirstName());
        result.setLastName(user.getLastName());
        result.getEmails().addAll(user.getEmails());
        result.getPgpKeyIds().addAll(user.getPgpKeyIds());
        UserRepoKeyRing userRepoKeyRing = user.getUserRepoKeyRing();
        UserRepoKey.PublicKeyWithSignature publicKey = null;
        if (userRepoKeyRing != null) {
            UserRepoKey userRepoKey = userRepoKeyRing.getUserRepoKeyOrFail(ofUserRepoKeyPublicKey.getUserRepoKeyId());
            publicKey = userRepoKey.getPublicKey();
        } else {
            for (UserRepoKey.PublicKeyWithSignature pk : user.getUserRepoKeyPublicKeys()) {
                if (!ofUserRepoKeyPublicKey.getUserRepoKeyId().equals((Object)pk.getUserRepoKeyId())) continue;
                publicKey = pk;
                break;
            }
        }
        if (publicKey == null) {
            throw new IllegalStateException("publicKey == null");
        }
        UserRepoKeyPublicKeyDtoWithSignatureConverter converter = new UserRepoKeyPublicKeyDtoWithSignatureConverter();
        UserRepoKeyPublicKeyDto userRepoKeyPublicKeyDto = converter.toUserRepoKeyPublicKeyDto(publicKey);
        result.setUserRepoKeyPublicKeyDto(userRepoKeyPublicKeyDto);
        return result;
    }

    public void removeUserIdentityLinksAfterRevokingReadUserIdentityPermission() {
        UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)this.getContext().transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserIdentityDao uiDao = (UserIdentityDao)((Object)this.getContext().transaction.getDao(UserIdentityDao.class));
        HashMap<UserRepoKeyPublicKey, byte[]> ofUserRepoKeyPublicKey2UserIdentityPayloadDtoData = new HashMap<UserRepoKeyPublicKey, byte[]>();
        for (UserRepoKeyPublicKey userRepoKeyPublicKey : urkpkDao.getObjects()) {
            byte[] userIdentityPayloadDtoData = this.getUserIdentityPayloadDtoData(userRepoKeyPublicKey);
            if (userIdentityPayloadDtoData == null) {
                throw new ReadUserIdentityAccessDeniedException("Could not obtain the decrypted userIdentityPayloadDtoData of " + (Object)((Object)userRepoKeyPublicKey));
            }
            ofUserRepoKeyPublicKey2UserIdentityPayloadDtoData.put(userRepoKeyPublicKey, userIdentityPayloadDtoData);
            this.deleteUserIdentityLinksOf(userRepoKeyPublicKey);
        }
        this.getContext().transaction.flush();
        long uiCount = uiDao.getObjectsCount();
        if (uiCount != 0L) {
            throw new IllegalStateException(String.format("WTF?! There are still %s UserIdentity instances in the DB!", uiCount));
        }
        for (Map.Entry me : ofUserRepoKeyPublicKey2UserIdentityPayloadDtoData.entrySet()) {
            UserRepoKeyPublicKey ofUserRepoKeyPublicKey = (UserRepoKeyPublicKey)((Object)me.getKey());
            byte[] userIdentityPayloadDtoData = (byte[])me.getValue();
            Set<UserRepoKeyPublicKey> forUserRepoKeyPublicKeys = this.getForUserRepoKeyPublicKeysForUserIdentityLinkCreation(ofUserRepoKeyPublicKey);
            PlainUserIdentity plainUserIdentity = this.createPlainUserIdentity(ofUserRepoKeyPublicKey, userIdentityPayloadDtoData);
            for (UserRepoKeyPublicKey forUserRepoKeyPublicKey : forUserRepoKeyPublicKeys) {
                this.createUserIdentityLink(plainUserIdentity, forUserRepoKeyPublicKey);
            }
        }
    }

    private void deleteUserIdentityLinksOf(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"ofUserRepoKeyPublicKey", (Object)((Object)ofUserRepoKeyPublicKey));
        UserIdentityLinkDao uilDao = (UserIdentityLinkDao)((Object)this.getContext().transaction.getDao(UserIdentityLinkDao.class));
        Collection<UserIdentityLink> userIdentityLinks = uilDao.getUserIdentityLinksOf(ofUserRepoKeyPublicKey);
        uilDao.deletePersistentAll(userIdentityLinks);
    }

    public void updateUserRepoKeyRingFromUserIdentities() {
        LocalRepoTransaction transaction = this.getContext().transaction;
        UserRepoKeyPublicKeyDao urkpkDao = (UserRepoKeyPublicKeyDao)((Object)transaction.getDao(UserRepoKeyPublicKeyDao.class));
        UserRegistry userRegistry = this.getContext().getUserRegistry();
        for (UserRepoKeyPublicKey userRepoKeyPublicKey : urkpkDao.getObjects()) {
            Uid userRepoKeyId = userRepoKeyPublicKey.getUserRepoKeyId();
            User user = userRegistry.getUserByUserRepoKeyId(userRepoKeyId);
            if (user != null) {
                logger.debug("updateUserRepoKeyRingFromUserIdentities: Skipping {} already associated with {}", (Object)userRepoKeyPublicKey, (Object)user);
                continue;
            }
            UserIdentityPayloadDto userIdentityPayloadDto = this.getUserIdentityPayloadDto(userRepoKeyPublicKey);
            if (userIdentityPayloadDto == null) {
                logger.debug("updateUserRepoKeyRingFromUserIdentities: Skipping {} because of missing permissions!", (Object)userRepoKeyPublicKey);
                continue;
            }
            Collection users = userRegistry.getUsersByPgpKeyIds(new HashSet(userIdentityPayloadDto.getPgpKeyIds()));
            if (users.isEmpty()) {
                user = userRegistry.createUser();
                user.getPgpKeyIds().addAll(userIdentityPayloadDto.getPgpKeyIds());
                user.setFirstName(userIdentityPayloadDto.getFirstName());
                user.setLastName(userIdentityPayloadDto.getLastName());
                user.getEmails().addAll(userIdentityPayloadDto.getEmails());
                userRegistry.addUser(user);
                logger.debug("updateUserRepoKeyRingFromUserIdentities: Created {} for {}", (Object)user, (Object)userRepoKeyPublicKey);
            } else {
                user = (User)users.iterator().next();
                for (PgpKeyId pgpKeyId : userIdentityPayloadDto.getPgpKeyIds()) {
                    if (user.getPgpKeyIds().contains(pgpKeyId)) continue;
                    user.getPgpKeyIds().add(pgpKeyId);
                }
                logger.debug("updateUserRepoKeyRingFromUserIdentities: Found {} via PGP-key[s] for {}", (Object)user, (Object)userRepoKeyPublicKey);
            }
            UserRepoKeyPublicKeyDtoWithSignatureConverter converter = new UserRepoKeyPublicKeyDtoWithSignatureConverter();
            try {
                UserRepoKey.PublicKeyWithSignature pk = converter.fromUserRepoKeyPublicKeyDto(userIdentityPayloadDto.getUserRepoKeyPublicKeyDto());
                user.getUserRepoKeyPublicKeys().add(pk);
            }
            catch (MissingSigningPgpKeyException x) {
                logger.warn("updateUserRepoKeyRingFromUserIdentities: " + (Object)((Object)x));
                for (PgpKeyId pgpKeyId : x.getMissingPgpKeyIds()) {
                    if (user.getPgpKeyIds().contains(pgpKeyId)) continue;
                    user.getPgpKeyIds().add(pgpKeyId);
                }
            }
        }
    }
}

