/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.dto;

import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import org.subshare.core.dto.CryptoConfigPropSetDto;
import org.subshare.local.persistence.CryptoConfigPropSet;
import org.subshare.local.persistence.CryptoConfigPropSetDao;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoKeyDao;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;

public class CryptoConfigPropSetDtoConverter {
    private LocalRepoTransaction transaction;

    public static CryptoConfigPropSetDtoConverter create(LocalRepoTransaction transaction) {
        return (CryptoConfigPropSetDtoConverter)ObjectFactoryUtil.createObject(CryptoConfigPropSetDtoConverter.class, (Object[])new Object[]{transaction});
    }

    protected CryptoConfigPropSetDtoConverter(LocalRepoTransaction transaction) {
        this.transaction = (LocalRepoTransaction)AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
    }

    public CryptoConfigPropSetDto toCryptoConfigPropSetDto(CryptoConfigPropSet cryptoConfigPropSet) {
        AssertUtil.assertNotNull((String)"cryptoConfigPropSet", (Object)((Object)cryptoConfigPropSet));
        CryptoConfigPropSetDto result = new CryptoConfigPropSetDto();
        result.setCryptoRepoFileId(cryptoConfigPropSet.getCryptoRepoFileId());
        result.setCryptoKeyId(((CryptoKey)((Object)AssertUtil.assertNotNull((String)"cryptoConfigPropSet.cryptoKey", (Object)((Object)cryptoConfigPropSet.getCryptoKey())))).getCryptoKeyId());
        result.setConfigPropSetDtoData(cryptoConfigPropSet.getConfigPropSetDtoData());
        result.setSignature(cryptoConfigPropSet.getSignature());
        return result;
    }

    public CryptoConfigPropSet putCryptoConfigPropSetDto(CryptoConfigPropSetDto cryptoConfigPropSetDto) {
        AssertUtil.assertNotNull((String)"cryptoConfigPropSetDto", (Object)cryptoConfigPropSetDto);
        CryptoRepoFileDao crfDao = (CryptoRepoFileDao)((Object)this.transaction.getDao(CryptoRepoFileDao.class));
        CryptoKeyDao ckDao = (CryptoKeyDao)((Object)this.transaction.getDao(CryptoKeyDao.class));
        CryptoConfigPropSetDao ccpsDao = (CryptoConfigPropSetDao)((Object)this.transaction.getDao(CryptoConfigPropSetDao.class));
        CryptoRepoFile cryptoRepoFile = crfDao.getCryptoRepoFileOrFail(cryptoConfigPropSetDto.getCryptoRepoFileId());
        CryptoKey cryptoKey = ckDao.getCryptoKeyOrFail(cryptoConfigPropSetDto.getCryptoKeyId());
        CryptoConfigPropSet result = ccpsDao.getCryptoConfigPropSet(cryptoRepoFile);
        if (result == null) {
            result = new CryptoConfigPropSet(cryptoRepoFile);
        }
        result.setCryptoKey(cryptoKey);
        result.setConfigPropSetDtoData(cryptoConfigPropSetDto.getConfigPropSetDtoData());
        result.setSignature(cryptoConfigPropSetDto.getSignature());
        result = (CryptoConfigPropSet)ccpsDao.makePersistent(result);
        return result;
    }
}

