/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.dto;

import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import org.subshare.core.dto.CurrentHistoCryptoRepoFileDto;
import org.subshare.core.dto.HistoCryptoRepoFileDto;
import org.subshare.local.dto.HistoCryptoRepoFileDtoConverter;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.CurrentHistoCryptoRepoFile;
import org.subshare.local.persistence.CurrentHistoCryptoRepoFileDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.HistoCryptoRepoFileDao;

public class CurrentHistoCryptoRepoFileDtoConverter {
    private final LocalRepoTransaction transaction;

    public static CurrentHistoCryptoRepoFileDtoConverter create(LocalRepoTransaction transaction) {
        return (CurrentHistoCryptoRepoFileDtoConverter)ObjectFactoryUtil.createObject(CurrentHistoCryptoRepoFileDtoConverter.class, (Object[])new Object[]{transaction});
    }

    protected CurrentHistoCryptoRepoFileDtoConverter(LocalRepoTransaction transaction) {
        this.transaction = (LocalRepoTransaction)AssertUtil.assertNotNull((String)"transaction", (Object)transaction);
    }

    public CurrentHistoCryptoRepoFileDto toCurrentHistoCryptoRepoFileDto(CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile, boolean withHistoCryptoRepoFileDto) {
        AssertUtil.assertNotNull((String)"currentHistoCryptoRepoFile", (Object)((Object)currentHistoCryptoRepoFile));
        CurrentHistoCryptoRepoFileDto result = new CurrentHistoCryptoRepoFileDto();
        HistoCryptoRepoFile histoCryptoRepoFile = (HistoCryptoRepoFile)((Object)AssertUtil.assertNotNull((String)"currentHistoCryptoRepoFile.histoCryptoRepoFile", (Object)((Object)currentHistoCryptoRepoFile.getHistoCryptoRepoFile())));
        CryptoRepoFile cryptoRepoFile = (CryptoRepoFile)((Object)AssertUtil.assertNotNull((String)"currentHistoCryptoRepoFile.cryptoRepoFile", (Object)((Object)currentHistoCryptoRepoFile.getCryptoRepoFile())));
        if (withHistoCryptoRepoFileDto) {
            HistoCryptoRepoFileDto histoCryptoRepoFileDto = HistoCryptoRepoFileDtoConverter.create(this.transaction).toHistoCryptoRepoFileDto(histoCryptoRepoFile);
            result.setHistoCryptoRepoFileDto(histoCryptoRepoFileDto);
        } else {
            result.setHistoCryptoRepoFileId(histoCryptoRepoFile.getHistoCryptoRepoFileId());
            result.setCryptoRepoFileId(cryptoRepoFile.getCryptoRepoFileId());
        }
        result.setSignature(currentHistoCryptoRepoFile.getSignature());
        return result;
    }

    public CurrentHistoCryptoRepoFile putCurrentHistoCryptoRepoFile(CurrentHistoCryptoRepoFileDto currentHistoCryptoRepoFileDto) {
        CryptoRepoFile cryptoRepoFile;
        HistoCryptoRepoFile histoCryptoRepoFile;
        AssertUtil.assertNotNull((String)"cryptoRepoFileOnServerDto", (Object)currentHistoCryptoRepoFileDto);
        CurrentHistoCryptoRepoFileDao currentHistoCryptoRepoFileDao = (CurrentHistoCryptoRepoFileDao)((Object)this.transaction.getDao(CurrentHistoCryptoRepoFileDao.class));
        HistoCryptoRepoFileDao histoCryptoRepoFileDao = (HistoCryptoRepoFileDao)((Object)this.transaction.getDao(HistoCryptoRepoFileDao.class));
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)this.transaction.getDao(CryptoRepoFileDao.class));
        HistoCryptoRepoFileDto histoCryptoRepoFileDto = currentHistoCryptoRepoFileDto.getHistoCryptoRepoFileDto();
        if (histoCryptoRepoFileDto != null) {
            histoCryptoRepoFile = HistoCryptoRepoFileDtoConverter.create(this.transaction).putHistoCryptoRepoFile(histoCryptoRepoFileDto);
            cryptoRepoFile = histoCryptoRepoFile.getCryptoRepoFile();
        } else {
            cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFileOrFail(currentHistoCryptoRepoFileDto.getCryptoRepoFileId());
            histoCryptoRepoFile = histoCryptoRepoFileDao.getHistoCryptoRepoFileOrFail(currentHistoCryptoRepoFileDto.getHistoCryptoRepoFileId());
        }
        CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = currentHistoCryptoRepoFileDao.getCurrentHistoCryptoRepoFile(cryptoRepoFile);
        if (currentHistoCryptoRepoFile == null) {
            currentHistoCryptoRepoFile = new CurrentHistoCryptoRepoFile();
            currentHistoCryptoRepoFile.setCryptoRepoFile(cryptoRepoFile);
        } else if (!cryptoRepoFile.equals((Object)currentHistoCryptoRepoFile.getCryptoRepoFile())) {
            throw new IllegalArgumentException(String.format("cryptoRepoFile != currentHistoCryptoRepoFile.cryptoRepoFile :: %s != %s :: %s", new Object[]{cryptoRepoFile, currentHistoCryptoRepoFile.getCryptoRepoFile(), currentHistoCryptoRepoFile}));
        }
        currentHistoCryptoRepoFile.setHistoCryptoRepoFile(histoCryptoRepoFile);
        currentHistoCryptoRepoFile.setSignature(currentHistoCryptoRepoFileDto.getSignature());
        currentHistoCryptoRepoFile = (CurrentHistoCryptoRepoFile)currentHistoCryptoRepoFileDao.makePersistent(currentHistoCryptoRepoFile);
        this.transaction.flush();
        return currentHistoCryptoRepoFile;
    }
}

