/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.key;

import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.wot.internal.Util;
import org.bouncycastle.openpgp.wot.key.PgpKey;
import org.bouncycastle.openpgp.wot.key.PgpUserIdNameHash;

public class PgpUserId {
    private final PgpKey pgpKey;
    private final String userId;
    private final PGPUserAttributeSubpacketVector userAttribute;
    private volatile PgpUserIdNameHash nameHash;

    public PgpUserId(PgpKey pgpKey, String userId) {
        this.pgpKey = Util.assertNotNull("pgpKey", pgpKey);
        this.userId = Util.assertNotNull("userId", userId);
        this.userAttribute = null;
    }

    public PgpUserId(PgpKey pgpKey, PGPUserAttributeSubpacketVector userAttribute) {
        this.pgpKey = Util.assertNotNull("pgpKey", pgpKey);
        this.userId = null;
        this.userAttribute = Util.assertNotNull("userAttribute", userAttribute);
    }

    public PgpKey getPgpKey() {
        return this.pgpKey;
    }

    public String getUserId() {
        return this.userId;
    }

    public PGPUserAttributeSubpacketVector getUserAttribute() {
        return this.userAttribute;
    }

    public PgpUserIdNameHash getNameHash() {
        if (this.nameHash == null) {
            this.nameHash = this.userId != null ? PgpUserIdNameHash.createFromUserId(this.userId) : PgpUserIdNameHash.createFromUserAttribute(this.userAttribute);
        }
        return this.nameHash;
    }

    public String toString() {
        return String.format("%s[pgpKeyId=%s userId=%s userAttribute=%s]", this.getClass().getSimpleName(), this.getPgpKey().getPgpKeyId(), this.userId, this.userAttribute);
    }
}

