/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo.sync;

import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncActivity;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncDaemon;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncDaemonImpl;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncState;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.LocalRepoRegistryImpl;
import org.subshare.core.repo.sync.RepoSyncTimer;

public class RepoSyncTimerImpl
implements RepoSyncTimer {
    private static final Logger logger = LoggerFactory.getLogger(RepoSyncTimerImpl.class);
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Timer timer = new Timer("RepoSyncTimer");
    private TimerTask timerTask;
    private final Map<UUID, Long> localRepositoryId2NextSyncTimestamp = new HashMap<UUID, Long>();
    private final PropertyChangeListener repoSyncDaemonStatesPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RepoSyncTimerImpl.this.scheduleTimerTask();
        }
    };

    protected RepoSyncTimerImpl() {
        PropertyChangeListenerUtil.addWeakPropertyChangeListenerNonTypeSafe((Object)this.getRepoSyncDaemon(), (Object)RepoSyncDaemon.PropertyEnum.states, (PropertyChangeListener)this.repoSyncDaemonStatesPropertyChangeListener);
        this.scheduleTimerTask();
    }

    public static RepoSyncTimer getInstance() {
        return Holder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleTimerTask() {
        this.cancelTimerTask();
        long globalNextSyncTimestamp = Long.MAX_VALUE;
        for (LocalRepo localRepo : LocalRepoRegistryImpl.getInstance().getLocalRepos()) {
            long nextSyncTimestamp = this.calculateNextSyncTimestamp(localRepo);
            globalNextSyncTimestamp = Math.min(nextSyncTimestamp, globalNextSyncTimestamp);
        }
        RepoSyncTimerImpl repoSyncTimerImpl = this;
        synchronized (repoSyncTimerImpl) {
            this.cancelTimerTask();
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    RepoSyncTimerImpl.this.onTimerTaskRun();
                }
            };
            this.timer.schedule(this.timerTask, new Date(globalNextSyncTimestamp));
        }
    }

    private void onTimerTaskRun() {
        this.startSyncs();
        this.scheduleTimerTask();
    }

    private synchronized void cancelTimerTask() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    private void startSyncs() {
        for (LocalRepo localRepo : LocalRepoRegistryImpl.getInstance().getLocalRepos()) {
            long nextSyncTimestamp = this.calculateNextSyncTimestamp(localRepo);
            if (nextSyncTimestamp > System.currentTimeMillis()) continue;
            this.getRepoSyncDaemon().startSync(localRepo.getLocalRoot());
        }
    }

    private long calculateNextSyncTimestamp(LocalRepo localRepo) {
        AssertUtil.assertNotNull((String)"localRepo", (Object)localRepo);
        long now = System.currentTimeMillis();
        long lastSyncTimestamp = this.isSyncQueuedOrInProgress(localRepo) ? now : this.getLastSyncTimestamp(localRepo);
        long syncPeriod = this.getSyncPeriod(localRepo);
        long nextSyncTimestamp = Math.max(lastSyncTimestamp + syncPeriod, now);
        this.setNextSyncTimestamp(localRepo, nextSyncTimestamp);
        return nextSyncTimestamp;
    }

    private long getLastSyncTimestamp(LocalRepo localRepo) {
        UUID localRepositoryId = ((LocalRepo)AssertUtil.assertNotNull((String)"localRepo", (Object)localRepo)).getRepositoryId();
        List states = this.getRepoSyncDaemon().getStates(localRepositoryId);
        long result = 0L;
        for (RepoSyncState repoSyncState : states) {
            Date syncFinished = repoSyncState.getSyncFinished();
            if (syncFinished.getTime() <= result) continue;
            result = syncFinished.getTime();
        }
        return result;
    }

    private boolean isSyncQueuedOrInProgress(LocalRepo localRepo) {
        UUID localRepositoryId = ((LocalRepo)AssertUtil.assertNotNull((String)"localRepo", (Object)localRepo)).getRepositoryId();
        Set activities = this.getRepoSyncDaemon().getActivities(localRepositoryId);
        for (RepoSyncActivity activity : activities) {
            switch (activity.getActivityType()) {
                case IN_PROGRESS: 
                case QUEUED: {
                    return true;
                }
            }
            Exception x = new Exception("Unknown RepoSyncActivityType: " + activity.getActivityType());
            logger.warn("getLastSyncTimestamp: " + x, (Throwable)x);
        }
        return false;
    }

    @Override
    public synchronized long getNextSyncTimestamp(UUID localRepositoryId) {
        AssertUtil.assertNotNull((String)"localRepositoryId", (Object)localRepositoryId);
        Long result = this.localRepositoryId2NextSyncTimestamp.get(localRepositoryId);
        return result == null ? 0L : result;
    }

    protected void setNextSyncTimestamp(LocalRepo localRepo, long lastSyncTimestamp) {
        UUID localRepositoryId = ((LocalRepo)AssertUtil.assertNotNull((String)"localRepo", (Object)localRepo)).getRepositoryId();
        this.setNextSyncTimestamp(localRepositoryId, lastSyncTimestamp);
    }

    protected synchronized void setNextSyncTimestamp(UUID localRepositoryId, long lastSyncTimestamp) {
        AssertUtil.assertNotNull((String)"localRepositoryId", (Object)localRepositoryId);
        this.localRepositoryId2NextSyncTimestamp.put(localRepositoryId, lastSyncTimestamp);
        this.firePropertyChange(RepoSyncTimer.PropertyEnum.nextSyncTimestamps, null, null);
    }

    private long getSyncPeriod(LocalRepo localRepo) {
        Config config = ConfigImpl.getInstanceForDirectory((File)((LocalRepo)AssertUtil.assertNotNull((String)"localRepo", (Object)localRepo)).getLocalRoot());
        long syncPeriod = config.getPropertyAsPositiveOrZeroLong("repo.syncPeriod", 3600000L);
        return syncPeriod;
    }

    private RepoSyncDaemon getRepoSyncDaemon() {
        return RepoSyncDaemonImpl.getInstance();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(RepoSyncTimer.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(RepoSyncTimer.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(RepoSyncTimer.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }

    private static class Holder {
        public static final RepoSyncTimer instance = new RepoSyncTimerImpl();

        private Holder() {
        }
    }
}

