/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.version;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.UrlUtil;
import co.codewizards.cloudstore.core.version.LocalVersionInIdeHelper;
import co.codewizards.cloudstore.core.version.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SsLocalVersionInIdeHelper
extends LocalVersionInIdeHelper {
    protected SsLocalVersionInIdeHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Version getLocalVersionInIde_file() {
        Iterator iterator;
        try {
            File dir = UrlUtil.getFile((URL)this.resource).getCanonicalFile();
            ArrayList<File> buildGradleFiles = new ArrayList<File>();
            while (true) {
                if ((dir = dir.getParentFile()) == null) {
                    iterator = buildGradleFiles.iterator();
                    break;
                }
                File buildGradleFile = dir.createFile(new String[]{"build.gradle"});
                if (!buildGradleFile.exists()) continue;
                buildGradleFiles.add(buildGradleFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (iterator.hasNext()) {
            File buildGradleFile = (File)iterator.next();
            InputStream buildGradleIn = StreamUtil.castStream((IInputStream)buildGradleFile.createInputStream());
            Throwable throwable = null;
            try {
                Version version = this.readVersionFromBuildGradle(buildGradleIn);
                if (version == null) continue;
                Version version2 = version;
                return version2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (buildGradleIn == null) continue;
                if (throwable != null) {
                    try {
                        buildGradleIn.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                buildGradleIn.close();
            }
        }
        throw new IllegalStateException("Could not determine local version!");
    }

    protected Version readVersionFromBuildGradle(InputStream buildGradleIn) throws IOException {
        String line;
        Pattern pattern = Pattern.compile("^\\s*version\\s*=\\s*'([^']*)'.*$");
        BufferedReader reader = new BufferedReader(new InputStreamReader(buildGradleIn, StandardCharsets.UTF_8));
        Matcher matcher = null;
        while (null != (line = reader.readLine())) {
            if (matcher == null) {
                matcher = pattern.matcher(line);
            } else {
                matcher.reset(line);
            }
            if (!matcher.matches()) continue;
            String versionString = matcher.group(1);
            return new Version(versionString);
        }
        return null;
    }

    protected Version getLocalVersionInIde_jar() {
        this.resource = UrlUtil.getFileUrlFromJarUrl((URL)this.resource);
        return this.getLocalVersionInIde_file();
    }
}

