/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.dbrepo.transport;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.dto.ChangeSetDto;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.transport.DeleteModificationCollisionException;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.LocalRepoSync;
import co.codewizards.cloudstore.local.persistence.Directory;
import co.codewizards.cloudstore.local.persistence.Entity;
import co.codewizards.cloudstore.local.persistence.FileChunk;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import co.codewizards.cloudstore.local.persistence.Symlink;
import co.codewizards.cloudstore.local.transport.FileRepoTransport;
import java.util.Collection;
import java.util.Date;
import java.util.TreeMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.dto.CurrentHistoCryptoRepoFileDto;
import org.subshare.core.dto.SsDeleteModificationDto;
import org.subshare.core.dto.SsDirectoryDto;
import org.subshare.core.dto.SsNormalFileDto;
import org.subshare.core.dto.SsRepoFileDto;
import org.subshare.core.dto.SsSymlinkDto;
import org.subshare.core.repo.transport.CryptreeServerFileRepoTransport;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.dto.CurrentHistoCryptoRepoFileDtoConverter;
import org.subshare.local.persistence.CurrentHistoCryptoRepoFile;
import org.subshare.local.persistence.FileChunkPayload;
import org.subshare.local.persistence.FileChunkPayloadDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.HistoCryptoRepoFileDao;
import org.subshare.local.persistence.HistoFileChunk;
import org.subshare.local.persistence.HistoFileChunkDao;
import org.subshare.local.persistence.SsDirectory;
import org.subshare.local.persistence.SsNormalFile;
import org.subshare.local.persistence.SsSymlink;
import org.subshare.local.persistence.TempFileChunk;
import org.subshare.local.persistence.TempFileChunkDao;

public class DbFileRepoTransportImpl
extends FileRepoTransport
implements CryptreeServerFileRepoTransport {
    private static final Logger logger = LoggerFactory.getLogger(DbFileRepoTransportImpl.class);

    public void delete(SsDeleteModificationDto deleteModificationDto) {
        AssertUtil.assertNotNull((String)"deleteModificationDto", (Object)deleteModificationDto);
        UUID clientRepositoryId = (UUID)AssertUtil.assertNotNull((String)"clientRepositoryId", (Object)this.getClientRepositoryId());
        LocalRepoManager localRepoManager = this.getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();){
            String path = deleteModificationDto.getServerPath();
            File file = this.getFile(path);
            RepoFile repoFile = ((RepoFileDao)transaction.getDao(RepoFileDao.class)).getRepoFile(this.getLocalRepoManager().getLocalRoot(), file);
            if (repoFile == null) {
                return;
            }
            Cryptree cryptree = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail().getCryptreeOrCreate(transaction, clientRepositoryId);
            cryptree.assertSignatureOk((WriteProtected)deleteModificationDto);
            boolean collision = this.detectFileCollisionRecursively(transaction, clientRepositoryId, file);
            if (collision) {
                throw new DeleteModificationCollisionException(String.format("Collision in repository %s: The file/directory '%s' cannot be deleted, because it was modified by someone else in the meantime.", localRepoManager.getRepositoryId(), path));
            }
            LocalRepoSync localRepoSync = LocalRepoSync.create((LocalRepoTransaction)transaction);
            localRepoSync.deleteRepoFile(repoFile, false);
            transaction.commit();
        }
    }

    public void delete(String path) {
        throw new IllegalStateException("This method should only be invoked on the client!");
    }

    public void makeDirectory(String path, Date lastModified) {
        throw new IllegalStateException("This method should not be invoked on the server!");
    }

    public void makeDirectory(String path, SsDirectoryDto directoryDto, CurrentHistoCryptoRepoFileDto currentHistoCryptoRepoFileDto) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        AssertUtil.assertNotNull((String)"directoryDto", (Object)directoryDto);
        AssertUtil.assertNotNull((String)"currentHistoCryptoRepoFileDto", (Object)currentHistoCryptoRepoFileDto);
        AssertUtil.assertNotNull((String)"currentHistoCryptoRepoFileDto.histoCryptoRepoFileDto", (Object)currentHistoCryptoRepoFileDto.getHistoCryptoRepoFileDto());
        path = this.prefixPath(path);
        File file = this.getFile(path);
        File parentFile = file.getParentFile();
        File localRoot = this.getLocalRepoManager().getLocalRoot();
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        this.assertThatUnsignedPathMatchesSignedSsRepoFileDto(path, file, parentFile, (SsRepoFileDto)directoryDto);
        boolean isRoot = file.equals(localRoot);
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            SsDirectory directory;
            RepoFile repoFile;
            RepoFile parentRepoFile;
            RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
            RepoFile repoFile2 = parentRepoFile = isRoot ? null : repoFileDao.getRepoFile(localRoot, parentFile);
            if (!isRoot) {
                AssertUtil.assertNotNull((String)"parentRepoFile", (Object)parentRepoFile);
                if (!(parentRepoFile instanceof Directory)) {
                    throw new IllegalStateException("parentRepoFile is no Directory! " + parentRepoFile);
                }
            }
            if ((repoFile = repoFileDao.getRepoFile(localRoot, file)) != null && !(repoFile instanceof Directory)) {
                repoFileDao.deletePersistent(repoFile);
                repoFile = null;
            }
            if ((directory = (SsDirectory)repoFile) == null) {
                directory = (SsDirectory)ObjectFactoryUtil.createObject(SsDirectory.class);
                repoFile = directory;
                directory.setParent(parentRepoFile);
                directory.setName(directoryDto.getName());
            }
            directory.setLastModified(SsRepoFileDto.DUMMY_LAST_MODIFIED);
            directory.setLastSyncFromRepositoryId(clientRepositoryId);
            directory.setSignature(directoryDto.getSignature());
            repoFileDao.makePersistent((Entity)directory);
            CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = CurrentHistoCryptoRepoFileDtoConverter.create((LocalRepoTransaction)transaction).putCurrentHistoCryptoRepoFile(currentHistoCryptoRepoFileDto);
            currentHistoCryptoRepoFile.setLastSyncFromRepositoryId(clientRepositoryId);
            transaction.commit();
        }
    }

    private void assertThatUnsignedPathMatchesSignedSsRepoFileDto(String path, File file, File parentFile, SsRepoFileDto repoFileDto) {
        File localRoot = this.getLocalRepoManager().getLocalRoot();
        if (file.equals(localRoot) || parentFile.equals(localRoot)) {
            if (!StringUtil.isEmpty((String)repoFileDto.getParentName())) {
                throw new IllegalStateException(String.format("path references localRoot, but repoFileDto.parentName is not empty! repoFileDto.parentName='%s' repoFileDto.name='%s' path='%s'", repoFileDto.getParentName(), repoFileDto.getName(), path));
            }
        } else if (!repoFileDto.getParentName().equals(parentFile.getName())) {
            throw new IllegalStateException(String.format("path does not match repoFileDto.parentName! repoFileDto.parentName='%s' parentFile.name='%s' repoFileDto.name='%s' path='%s'", repoFileDto.getParentName(), parentFile.getName(), repoFileDto.getName(), path));
        }
        if (file.equals(localRoot)) {
            if (!StringUtil.isEmpty((String)repoFileDto.getName())) {
                throw new IllegalStateException(String.format("path references localRoot, but repoFileDto.name is not empty! repoFileDto.name='%s' path='%s'", repoFileDto.getName(), path));
            }
        } else if (!repoFileDto.getName().equals(file.getName())) {
            throw new IllegalStateException(String.format("path does not match repoFileDto.name! repoFileDto.name='%s' file.name='%s' path='%s'", repoFileDto.getName(), file.getName(), path));
        }
    }

    public void makeSymlink(String path, String target, Date lastModified) {
        throw new IllegalStateException("This method should not be invoked on the server!");
    }

    public void makeSymlink(String path, SsSymlinkDto symlinkDto, CurrentHistoCryptoRepoFileDto currentHistoCryptoRepoFileDto) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        AssertUtil.assertNotNull((String)"symlinkDto", (Object)symlinkDto);
        AssertUtil.assertNotNull((String)"currentHistoCryptoRepoFileDto", (Object)currentHistoCryptoRepoFileDto);
        AssertUtil.assertNotNull((String)"currentHistoCryptoRepoFileDto.histoCryptoRepoFileDto", (Object)currentHistoCryptoRepoFileDto.getHistoCryptoRepoFileDto());
        path = this.prefixPath(path);
        File file = this.getFile(path);
        File parentFile = file.getParentFile();
        File localRoot = this.getLocalRepoManager().getLocalRoot();
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        this.assertThatUnsignedPathMatchesSignedSsRepoFileDto(path, file, parentFile, (SsRepoFileDto)symlinkDto);
        boolean isRoot = file.equals(localRoot);
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            SsSymlink symlink;
            RepoFile repoFile;
            RepoFile parentRepoFile;
            RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
            RepoFile repoFile2 = parentRepoFile = isRoot ? null : repoFileDao.getRepoFile(localRoot, parentFile);
            if (!isRoot) {
                AssertUtil.assertNotNull((String)"parentRepoFile", (Object)parentRepoFile);
                if (!(parentRepoFile instanceof Directory)) {
                    throw new IllegalStateException("parentRepoFile is no Directory! " + parentRepoFile);
                }
            }
            if ((repoFile = repoFileDao.getRepoFile(localRoot, file)) != null && !(repoFile instanceof Symlink)) {
                repoFileDao.deletePersistent(repoFile);
                repoFile = null;
            }
            if ((symlink = (SsSymlink)repoFile) == null) {
                symlink = (SsSymlink)ObjectFactoryUtil.createObject(SsSymlink.class);
                repoFile = symlink;
                symlink.setParent(parentRepoFile);
                symlink.setName(symlinkDto.getName());
            }
            symlink.setLastModified(new Date(0L));
            symlink.setTarget(symlinkDto.getTarget());
            symlink.setLastSyncFromRepositoryId(clientRepositoryId);
            symlink.setSignature(symlinkDto.getSignature());
            repoFileDao.makePersistent((Entity)symlink);
            CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = CurrentHistoCryptoRepoFileDtoConverter.create((LocalRepoTransaction)transaction).putCurrentHistoCryptoRepoFile(currentHistoCryptoRepoFileDto);
            currentHistoCryptoRepoFile.setLastSyncFromRepositoryId(clientRepositoryId);
            transaction.commit();
        }
    }

    public void beginPutFile(String path) {
        throw new IllegalStateException("This method should not be invoked on the server!");
    }

    public void beginPutFile(String path, SsNormalFileDto normalFileDto) {
        AssertUtil.assertNotNull((String)"normalFileDto", (Object)normalFileDto);
        path = this.prefixPath(path);
        File file = this.getFile(path);
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        File parentFile = file.getParentFile();
        File localRoot = this.getLocalRepoManager().getLocalRoot();
        this.assertThatUnsignedPathMatchesSignedSsRepoFileDto(path, file, parentFile, (SsRepoFileDto)normalFileDto);
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            SsNormalFile normalFile;
            this.assertNoDeleteModificationCollision(transaction, clientRepositoryId, path);
            RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
            RepoFile parentRepoFile = repoFileDao.getRepoFile(localRoot, parentFile);
            AssertUtil.assertNotNull((String)"parentRepoFile", (Object)parentRepoFile);
            if (!(parentRepoFile instanceof Directory)) {
                throw new IllegalStateException("parentRepoFile is no Directory! " + parentRepoFile);
            }
            RepoFile repoFile = repoFileDao.getRepoFile(localRoot, file);
            if (repoFile != null && !(repoFile instanceof NormalFile)) {
                repoFileDao.deletePersistent(repoFile);
                repoFile = null;
            }
            if ((normalFile = (SsNormalFile)repoFile) == null) {
                normalFile = (SsNormalFile)ObjectFactoryUtil.createObject(SsNormalFile.class);
                repoFile = normalFile;
                normalFile.setParent(parentRepoFile);
                normalFile.setName(normalFileDto.getName());
            }
            normalFile.setLength(normalFileDto.getLength());
            normalFile.setSha1("X");
            normalFile.setLastModified(normalFileDto.getLastModified());
            normalFile.setSignature(normalFileDto.getSignature());
            normalFile.setLastSyncFromRepositoryId(clientRepositoryId);
            normalFile.setInProgress(true);
            repoFileDao.makePersistent((Entity)normalFile);
            transaction.commit();
        }
    }

    public void putFileData(String path, long offset, byte[] fileData) {
        path = this.prefixPath(path);
        logger.info("putFileData: path='{}' offset={}", (Object)path, (Object)offset);
        File file = this.getFile(path);
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        File localRoot = this.getLocalRepoManager().getLocalRoot();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
            TempFileChunkDao tempFileChunkDao = (TempFileChunkDao)transaction.getDao(TempFileChunkDao.class);
            FileChunkPayloadDao fileChunkPayloadDao = (FileChunkPayloadDao)transaction.getDao(FileChunkPayloadDao.class);
            RepoFile repoFile = repoFileDao.getRepoFile(localRoot, file);
            AssertUtil.assertNotNull((String)"repoFile", (Object)repoFile);
            NormalFile normalFile = (NormalFile)repoFile;
            TempFileChunk tempFileChunk = tempFileChunkDao.getTempFileChunk(normalFile, clientRepositoryId, offset);
            if (tempFileChunk == null) {
                tempFileChunk = new TempFileChunk();
                tempFileChunk.setNormalFile(normalFile);
                tempFileChunk.setRemoteRepositoryId(clientRepositoryId);
                tempFileChunk.setRole(TempFileChunk.Role.RECEIVING);
                tempFileChunk.setOffset(offset);
                tempFileChunk.setLength(fileData.length);
                tempFileChunk = (TempFileChunk)tempFileChunkDao.makePersistent((Entity)tempFileChunk);
            } else {
                tempFileChunk.setLength(fileData.length);
            }
            FileChunkPayload fileChunkPayload = fileChunkPayloadDao.getFileChunkPayload(tempFileChunk);
            if (fileChunkPayload == null) {
                fileChunkPayload = new FileChunkPayload();
                fileChunkPayload.setTempFileChunk(tempFileChunk);
            }
            fileChunkPayload.setFileData(fileData);
            fileChunkPayloadDao.makePersistent((Entity)fileChunkPayload);
            transaction.commit();
        }
    }

    public byte[] getFileData(String path, long offset, int length) {
        path = this.prefixPath(path);
        logger.info("getFileData: path='{}' offset={}", (Object)path, (Object)offset);
        File file = this.getFile(path);
        File localRoot = this.getLocalRepoManager().getLocalRoot();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginReadTransaction();){
            RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
            FileChunkPayloadDao fileChunkPayloadDao = (FileChunkPayloadDao)transaction.getDao(FileChunkPayloadDao.class);
            RepoFile repoFile = repoFileDao.getRepoFile(localRoot, file);
            AssertUtil.assertNotNull((String)"repoFile", (Object)repoFile);
            SsNormalFile normalFile = (SsNormalFile)repoFile;
            FileChunkPayload fileChunkPayload = fileChunkPayloadDao.getFileChunkPayloadOfFileChunk((NormalFile)normalFile, offset);
            byte[] fileData = fileChunkPayload == null ? null : fileChunkPayload.getFileData();
            transaction.commit();
            byte[] byArray = fileData;
            return byArray;
        }
    }

    public byte[] getHistoFileData(Uid histoCryptoRepoFileId, long offset) {
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginReadTransaction();){
            HistoCryptoRepoFileDao hcrfDao = (HistoCryptoRepoFileDao)transaction.getDao(HistoCryptoRepoFileDao.class);
            HistoCryptoRepoFile histoCryptoRepoFile = hcrfDao.getHistoCryptoRepoFileOrFail(histoCryptoRepoFileId);
            FileChunkPayloadDao fcpDao = (FileChunkPayloadDao)transaction.getDao(FileChunkPayloadDao.class);
            FileChunkPayload fileChunkPayload = fcpDao.getFileChunkPayloadOfHistoFileChunk(histoCryptoRepoFile, offset);
            byte[] fileData = fileChunkPayload == null ? null : fileChunkPayload.getFileData();
            transaction.commit();
            byte[] byArray = fileData;
            return byArray;
        }
    }

    public void endPutFile(String path, Date lastModified, long length, String sha1) {
        throw new IllegalStateException("This method should not be invoked on the server!");
    }

    public void endPutFile(String path, SsNormalFileDto normalFileDto, CurrentHistoCryptoRepoFileDto currentHistoCryptoRepoFileDto) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        AssertUtil.assertNotNull((String)"normalFileDto", (Object)normalFileDto);
        AssertUtil.assertNotNull((String)"currentHistoCryptoRepoFileDto", (Object)currentHistoCryptoRepoFileDto);
        AssertUtil.assertNotNull((String)"currentHistoCryptoRepoFileDto.histoCryptoRepoFileDto", (Object)currentHistoCryptoRepoFileDto.getHistoCryptoRepoFileDto());
        path = this.prefixPath(path);
        File file = this.getFile(path);
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        File localRoot = this.getLocalRepoManager().getLocalRoot();
        try (LocalRepoTransaction transaction = this.getLocalRepoManager().beginWriteTransaction();){
            RepoFileDao repoFileDao = (RepoFileDao)transaction.getDao(RepoFileDao.class);
            TempFileChunkDao tempFileChunkDao = (TempFileChunkDao)transaction.getDao(TempFileChunkDao.class);
            HistoFileChunkDao histoFileChunkDao = (HistoFileChunkDao)transaction.getDao(HistoFileChunkDao.class);
            FileChunkPayloadDao fileChunkPayloadDao = (FileChunkPayloadDao)transaction.getDao(FileChunkPayloadDao.class);
            RepoFile repoFile = repoFileDao.getRepoFile(localRoot, file);
            AssertUtil.assertNotNull((String)"repoFile", (Object)repoFile);
            SsNormalFile normalFile = (SsNormalFile)repoFile;
            TreeMap<Long, Object> offset2FileChunk = new TreeMap<Long, Object>();
            for (Object fileChunk : normalFile.getFileChunks()) {
                offset2FileChunk.put(fileChunk.getOffset(), fileChunk);
            }
            Collection tempFileChunks = tempFileChunkDao.getTempFileChunks((NormalFile)normalFile, clientRepositoryId);
            for (TempFileChunk tempFileChunk : tempFileChunks) {
                FileChunkPayload oldFileChunkPayload;
                FileChunkPayload fileChunkPayload = fileChunkPayloadDao.getFileChunkPayload(tempFileChunk);
                if (fileChunkPayload == null) {
                    logger.warn("endPutFile: fileChunkPayload == null for {}", (Object)tempFileChunk);
                    continue;
                }
                FileChunk fileChunk = (FileChunk)offset2FileChunk.get(tempFileChunk.getOffset());
                if (fileChunk == null) {
                    fileChunk = (FileChunk)ObjectFactoryUtil.createObject(FileChunk.class);
                    fileChunk.setNormalFile((NormalFile)normalFile);
                    fileChunk.setOffset(tempFileChunk.getOffset());
                    fileChunk.setLength(0);
                    fileChunk.setSha1("X");
                    offset2FileChunk.put(fileChunk.getOffset(), fileChunk);
                    normalFile.getFileChunks().add(fileChunk);
                }
                if ((oldFileChunkPayload = fileChunkPayloadDao.getFileChunkPayload(fileChunk)) != null) {
                    if (histoFileChunkDao.getHistoFileChunkCount(oldFileChunkPayload) == 0L) {
                        fileChunkPayloadDao.deletePersistent((Entity)oldFileChunkPayload);
                    } else {
                        oldFileChunkPayload.setFileChunk(null);
                    }
                    transaction.flush();
                }
                fileChunkPayload.setTempFileChunk(null);
                fileChunkPayload.setFileChunk(fileChunk);
            }
            tempFileChunkDao.deletePersistentAll(tempFileChunks);
            CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = CurrentHistoCryptoRepoFileDtoConverter.create((LocalRepoTransaction)transaction).putCurrentHistoCryptoRepoFile(currentHistoCryptoRepoFileDto);
            currentHistoCryptoRepoFile.setLastSyncFromRepositoryId(clientRepositoryId);
            HistoCryptoRepoFile histoCryptoRepoFile = currentHistoCryptoRepoFile.getHistoCryptoRepoFile();
            for (FileChunk fileChunk : offset2FileChunk.values()) {
                if (fileChunk.getOffset() < normalFileDto.getLength()) continue;
                normalFile.getFileChunks().remove(fileChunk);
            }
            for (FileChunk fileChunk : normalFile.getFileChunks()) {
                FileChunkPayload fileChunkPayload = fileChunkPayloadDao.getFileChunkPayload(fileChunk);
                HistoFileChunk histoFileChunk = new HistoFileChunk();
                histoFileChunk.setHistoCryptoRepoFile(histoCryptoRepoFile);
                histoFileChunk.setOffset(fileChunk.getOffset());
                histoFileChunk.setLength(fileChunk.getLength());
                histoFileChunk.setFileChunkPayload(fileChunkPayload);
                histoFileChunkDao.makePersistent((Entity)histoFileChunk);
            }
            normalFile.setInProgress(false);
            transaction.commit();
        }
    }

    protected void detectAndHandleFileCollision(LocalRepoTransaction transaction, UUID fromRepositoryId, File file, RepoFile normalFileOrSymlink) {
        super.detectAndHandleFileCollision(transaction, fromRepositoryId, file, normalFileOrSymlink);
    }

    public ChangeSetDto getChangeSetDto(boolean localSync) {
        return super.getChangeSetDto(false);
    }
}

