/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.oio;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.FileFilter;
import co.codewizards.cloudstore.core.oio.FileFilterWrapper;
import co.codewizards.cloudstore.core.oio.IoFileRelativePathUtil;
import co.codewizards.cloudstore.core.oio.IoFileUtil;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoFile
implements File {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(IoFile.class);
    protected final java.io.File ioFile;

    protected IoFile(String pathname) {
        this.ioFile = new java.io.File(pathname);
    }

    protected IoFile(File parent, String child) {
        java.io.File ioParent = parent.getIoFile();
        this.ioFile = new java.io.File(ioParent, child);
    }

    protected IoFile(String parent, String child) {
        this.ioFile = new java.io.File(parent, child);
    }

    protected IoFile(URI uri) {
        this.ioFile = new java.io.File(uri);
    }

    protected IoFile(java.io.File ioFile) {
        this.ioFile = ioFile;
    }

    @Override
    public File getParentFile() {
        java.io.File parentFile = this.ioFile.getParentFile();
        return parentFile != null ? new IoFile(parentFile) : null;
    }

    @Override
    public String[] list() {
        return this.ioFile.list();
    }

    @Override
    public String[] list(FilenameFilter filenameFilter) {
        return this.ioFile.list(filenameFilter);
    }

    @Override
    public File[] listFiles() {
        java.io.File[] ioFiles = this.ioFile.listFiles();
        return IoFileUtil.convert(ioFiles);
    }

    @Override
    public File[] listFiles(java.io.FileFilter fileFilter) {
        java.io.File[] ioFiles = this.ioFile.listFiles(fileFilter);
        return IoFileUtil.convert(ioFiles);
    }

    @Override
    public File[] listFiles(FileFilter fileFilter) {
        java.io.File[] ioFiles = this.ioFile.listFiles(new FileFilterWrapper(fileFilter));
        return IoFileUtil.convert(ioFiles);
    }

    @Override
    public File[] listFiles(FilenameFilter fileFilter) {
        java.io.File[] ioFiles = this.ioFile.listFiles(fileFilter);
        return IoFileUtil.convert(ioFiles);
    }

    @Override
    public File getAbsoluteFile() {
        return new IoFile(this.ioFile.getAbsoluteFile());
    }

    @Override
    public boolean exists() {
        return this.ioFile.exists();
    }

    @Override
    public boolean existsNoFollow() {
        return this.ioFile.exists();
    }

    @Override
    public boolean createNewFile() throws IOException {
        return this.ioFile.createNewFile();
    }

    @Override
    public boolean canExecute() {
        return this.ioFile.canExecute();
    }

    @Override
    public boolean canRead() {
        return this.ioFile.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.ioFile.canWrite();
    }

    @Override
    public boolean setExecutable(boolean executable) {
        return this.ioFile.setExecutable(executable);
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return this.ioFile.setExecutable(executable, ownerOnly);
    }

    @Override
    public boolean setReadable(boolean readable) {
        return this.ioFile.setReadable(readable);
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return this.ioFile.setReadable(readable, ownerOnly);
    }

    @Override
    public boolean setWritable(boolean writable) {
        return this.ioFile.setWritable(writable);
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return this.ioFile.setWritable(writable, ownerOnly);
    }

    @Override
    public int compareTo(File otherFile) {
        return this.ioFile.compareTo(otherFile.getIoFile());
    }

    @Override
    public boolean delete() {
        return this.ioFile.delete();
    }

    @Override
    public void deleteOnExit() {
        this.ioFile.deleteOnExit();
    }

    @Override
    public void deleteRecursively() {
        IoFileUtil.deleteRecursively(this);
    }

    @Override
    public String getAbsolutePath() {
        return this.ioFile.getAbsolutePath();
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return new IoFile(this.ioFile.getCanonicalFile());
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.ioFile.getCanonicalPath();
    }

    @Override
    public long getFreeSpace() {
        return this.ioFile.getFreeSpace();
    }

    @Override
    public long length() {
        return this.ioFile.length();
    }

    @Override
    public boolean isRegularFileNoFollowLinks() {
        return this.ioFile.isFile();
    }

    @Override
    public boolean isRegularFileFollowLinks() {
        return this.ioFile.isFile();
    }

    @Override
    public boolean isDirectoryNoFollowSymLinks() {
        return this.ioFile.isDirectory();
    }

    @Override
    public boolean isDirectoryFollowSymLinks() {
        return this.ioFile.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public String readSymbolicLinkToPathString() throws IOException {
        throw new IllegalStateException("Impossible operation within this implementation: check use method 'isSymbolicLink' before!");
    }

    @Override
    public long getLastModifiedNoFollow() {
        return this.lastModified();
    }

    @Override
    public boolean renameTo(File dest) {
        return this.ioFile.renameTo(dest.getIoFile());
    }

    @Override
    public boolean setLastModified(long lastModified) {
        return this.ioFile.setLastModified(lastModified);
    }

    @Override
    public IOutputStream createOutputStream() throws FileNotFoundException {
        return StreamUtil.castStream(new FileOutputStream(this.ioFile));
    }

    @Override
    public IInputStream createInputStream() throws FileNotFoundException {
        return StreamUtil.castStream(new FileInputStream(this.ioFile));
    }

    @Override
    public IOutputStream createOutputStream(boolean append) throws FileNotFoundException {
        return StreamUtil.castStream(new FileOutputStream(this.ioFile, append));
    }

    @Override
    public String getName() {
        return this.ioFile.getName();
    }

    @Override
    public void createSymbolicLink(String targetPath) throws IOException {
        throw new IllegalStateException("Impossible operation within this implementation. Check whether symlinks are available here!");
    }

    @Override
    public long lastModified() {
        long result = this.ioFile.lastModified();
        return result;
    }

    @Override
    public boolean isAbsolute() {
        return this.ioFile.isAbsolute();
    }

    @Override
    public String getPath() {
        return this.ioFile.getPath();
    }

    @Override
    public boolean mkdir() {
        return this.ioFile.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this.ioFile.mkdirs();
    }

    @Override
    public boolean isDirectory() {
        return this.ioFile.isDirectory();
    }

    @Override
    public void move(File toFile) throws IOException {
        if (toFile.exists()) {
            throw new IOException("toFile file did already exists!");
        }
        if (!this.ioFile.exists()) {
            throw new IllegalArgumentException("Source file did not exists!");
        }
        if (this.ioFile.getCanonicalPath().equals(toFile.getCanonicalPath())) {
            return;
        }
        boolean renameTo = this.ioFile.renameTo(toFile.getIoFile());
        if (renameTo) {
            return;
        }
        if (this.ioFile.isFile()) {
            IOUtil.copyFile(this, toFile);
            boolean delete = this.delete();
            if (!delete) {
                throw new IllegalStateException("Problem on moving file from '" + this.ioFile.getCanonicalPath() + "' to " + toFile.getIoFile().getCanonicalPath());
            }
        } else if (this.ioFile.isDirectory()) {
            if (this.ioFile.listFiles().length == 0) {
                throw new IllegalArgumentException("Should not occure!");
            }
            IoFileUtil.moveRecursively(this, toFile);
        }
    }

    @Override
    public void copyToCopyAttributes(File toFile) throws IOException {
        if (toFile.exists()) {
            throw new IOException("toFile file did already exists!");
        }
        if (!this.ioFile.exists()) {
            throw new IllegalArgumentException("Source file did not exists!");
        }
        if (this.ioFile.getCanonicalPath().equals(toFile.getCanonicalPath())) {
            return;
        }
        if (this.ioFile.isFile()) {
            IOUtil.copyFile(this, toFile);
        } else {
            boolean mkdir = toFile.mkdir();
            if (!mkdir) {
                throw new IllegalStateException("Problem on moving directory from '" + this.ioFile.getCanonicalPath() + "'! Could not create directory " + toFile.getIoFile().getCanonicalPath());
            }
        }
    }

    @Override
    public RandomAccessFile createRandomAccessFile(String mode) throws FileNotFoundException {
        return new RandomAccessFile(this.ioFile, mode);
    }

    @Override
    public URI toURI() {
        return this.ioFile.toURI();
    }

    @Override
    public boolean isFile() {
        return this.ioFile.isFile();
    }

    @Override
    public void setLastModifiedNoFollow(long lastModified) {
        this.ioFile.setLastModified(lastModified);
    }

    @Override
    public String relativize(File target) throws IOException {
        return IoFileRelativePathUtil.getRelativePath(this.ioFile, target.getIoFile());
    }

    @Override
    public long getUsableSpace() {
        return this.ioFile.getUsableSpace();
    }

    @Override
    public java.io.File getIoFile() {
        return this.ioFile;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IoFile)) {
            return false;
        }
        IoFile ioFile = (IoFile)obj;
        return this.ioFile.equals(ioFile.ioFile);
    }

    public int hashCode() {
        return this.ioFile.hashCode();
    }

    public String toString() {
        return this.ioFile.toString();
    }

    @Override
    public File createFile(String ... children) {
        return OioFileFactory.createFile(this, children);
    }
}

