/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.oio;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.IoFile;
import co.codewizards.cloudstore.core.oio.IoFileRelativePathUtil;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(IoFileUtil.class);

    private IoFileUtil() {
    }

    public static File createTempDirectory(String prefix) throws IOException {
        String checkedPrefix = prefix == null ? "" : prefix;
        java.io.File javaIoTmpDir = new java.io.File(System.getProperty("java.io.tmpdir"));
        String baseName = checkedPrefix + System.currentTimeMillis();
        int attempts = 1000;
        for (int i = 0; i < 1000; ++i) {
            java.io.File tmpDir = new java.io.File(javaIoTmpDir, baseName + i);
            if (!tmpDir.mkdir()) continue;
            return OioFileFactory.createFile(tmpDir);
        }
        throw new IllegalStateException("Could not create a tmpDir in the directory '" + javaIoTmpDir + "'!");
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return OioFileFactory.createFile(java.io.File.createTempFile(prefix, suffix));
    }

    public static File createTempFile(String prefix, String suffix, File dir) throws IOException {
        return OioFileFactory.createFile(java.io.File.createTempFile(prefix, suffix, IoFileUtil.castOrFail((File)dir).ioFile));
    }

    public static java.io.File getIoFile(File file) {
        return IoFileUtil.castOrFail((File)file).ioFile;
    }

    public static File[] listRoots() {
        java.io.File[] roots = java.io.File.listRoots();
        AssertUtil.assertNotNull("java.io.File.listRoots()", roots);
        File[] result = new File[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            result[i] = OioFileFactory.createFile(roots[i]);
        }
        return result;
    }

    public static IoFile castOrFail(File file) {
        if (file instanceof IoFile) {
            return (IoFile)file;
        }
        throw new IllegalArgumentException("Could not cast file: " + file.getClass().getCanonicalName());
    }

    static File[] convert(java.io.File[] ioFilesListFiles) {
        if (ioFilesListFiles == null) {
            return null;
        }
        File[] listFiles = new File[ioFilesListFiles.length];
        for (int i = 0; i < ioFilesListFiles.length; ++i) {
            listFiles[i] = OioFileFactory.createFile(ioFilesListFiles[i]);
        }
        return listFiles;
    }

    static boolean deleteRecursively(File dir) {
        LinkedList<File> stack = new LinkedList<File>();
        stack.addFirst(dir);
        while (!stack.isEmpty()) {
            File stackElement = (File)stack.getFirst();
            File[] currList = stackElement.listFiles();
            if (null != currList && currList.length > 0) {
                for (File curr : currList) {
                    try {
                        boolean delete = curr.delete();
                        if (delete) continue;
                        stack.addFirst(curr);
                    }
                    catch (SecurityException e) {
                        logger.warn("Problem on delete of '{}'! ", (Object)curr, (Object)e.getMessage());
                    }
                }
                continue;
            }
            if (stackElement != stack.removeFirst()) {
                throw new IllegalStateException("WTF?!");
            }
            IoFileUtil.deleteOrLog(stackElement);
        }
        return !dir.exists();
    }

    private static void deleteOrLog(File file) {
        try {
            file.delete();
        }
        catch (SecurityException e) {
            logger.warn("Problem on delete of '{}'! ", (Object)file, (Object)e.getMessage());
        }
    }

    public static void moveRecursively(File fromDir, File toDir) throws IOException {
        File[] listFiles;
        IoFileUtil.checkRenameDir(fromDir, toDir);
        boolean mkdir = toDir.mkdir();
        if (!mkdir) {
            throw new IOException("Could not create directory toDir, aborting move!");
        }
        for (File file : listFiles = fromDir.listFiles()) {
            File newFileName = IoFileUtil.newFileNameForRenameTo(fromDir, toDir, file);
            if (file.isDirectory()) {
                newFileName.mkdir();
                IoFileUtil.moveRecursively(file, newFileName);
                continue;
            }
            if (!file.isFile()) continue;
            file.renameTo(newFileName);
        }
        boolean delete = fromDir.delete();
        if (!delete) {
            throw new IOException("Could not delete directory, which should be empty, aborting move! file=" + fromDir.getAbsolutePath());
        }
    }

    public static File newFileNameForRenameTo(File fromDir, File toDir, File current) throws IOException {
        String newParentDirName = toDir.getAbsolutePath() + OioFileFactory.FILE_SEPARATOR_CHAR + IoFileRelativePathUtil.getRelativePath(fromDir.getAbsolutePath(), current.getAbsolutePath(), true, OioFileFactory.FILE_SEPARATOR_CHAR);
        return OioFileFactory.createFile(newParentDirName);
    }

    protected static void checkRenameDir(File fromDir, File toDir) throws IOException {
        if (!fromDir.isDirectory()) {
            throw new IOException("fromDir must be directory, aborting move!");
        }
        File f = OioFileFactory.createFile(fromDir.getParentFile(), Long.toString(System.currentTimeMillis()));
        boolean mkdir = f.mkdir();
        if (!mkdir) {
            throw new IOException("Can not create mkdir, aborting move!");
        }
        boolean renameTo = f.renameTo(toDir);
        if (!renameTo) {
            throw new IOException("Rename would not work, aborting move!");
        }
        boolean delete = toDir.delete();
        if (!delete) {
            throw new IOException("Could not delete, right after renaming!!!");
        }
    }
}

