/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.transport;

import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class RepoTransportFactoryRegistry {
    private List<RepoTransportFactory> repoTransportFactories;

    public static RepoTransportFactoryRegistry getInstance() {
        return RepoTransportFactoryRegistryHolder.instance;
    }

    protected RepoTransportFactoryRegistry() {
    }

    public RepoTransportFactory getRepoTransportFactoryOrFail(URL remoteRoot) {
        RepoTransportFactory repoTransportFactory = this.getRepoTransportFactory(remoteRoot);
        if (repoTransportFactory == null) {
            throw new IllegalStateException("There is no RepoTransportFactory supporting this URL: " + remoteRoot);
        }
        return repoTransportFactory;
    }

    public RepoTransportFactory getRepoTransportFactory(URL remoteRoot) {
        for (RepoTransportFactory factory : this.getRepoTransportFactories()) {
            if (!factory.isSupported(remoteRoot)) continue;
            return factory;
        }
        return null;
    }

    public List<RepoTransportFactory> getRepoTransportFactories(URL remoteRoot) {
        ArrayList<RepoTransportFactory> result = new ArrayList<RepoTransportFactory>();
        for (RepoTransportFactory factory : this.getRepoTransportFactories()) {
            if (!factory.isSupported(remoteRoot)) continue;
            result.add(factory);
        }
        return Collections.unmodifiableList(result);
    }

    public synchronized List<RepoTransportFactory> getRepoTransportFactories() {
        List<RepoTransportFactory> repoTransportFactories = this.repoTransportFactories;
        if (repoTransportFactories == null) {
            repoTransportFactories = RepoTransportFactoryRegistry.loadRepoTransportFactoriesViaServiceLoader();
            RepoTransportFactoryRegistry.sortRepoTransportFactories(repoTransportFactories);
            this.repoTransportFactories = repoTransportFactories = Collections.unmodifiableList(repoTransportFactories);
        }
        return repoTransportFactories;
    }

    private static List<RepoTransportFactory> loadRepoTransportFactoriesViaServiceLoader() {
        ArrayList<RepoTransportFactory> repoTransportFactories = new ArrayList<RepoTransportFactory>();
        ServiceLoader<RepoTransportFactory> sl = ServiceLoader.load(RepoTransportFactory.class);
        Iterator<RepoTransportFactory> it = sl.iterator();
        while (it.hasNext()) {
            repoTransportFactories.add(it.next());
        }
        repoTransportFactories.trimToSize();
        return repoTransportFactories;
    }

    protected static int _compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static void sortRepoTransportFactories(List<RepoTransportFactory> repoTransportFactories) {
        Collections.sort(repoTransportFactories, new Comparator<RepoTransportFactory>(){

            @Override
            public int compare(RepoTransportFactory o1, RepoTransportFactory o2) {
                String name2;
                int result = -1 * RepoTransportFactoryRegistry._compare(o1.getPriority(), o2.getPriority());
                if (result != 0) {
                    return result;
                }
                String name1 = o1.getName() == null ? "" : o1.getName();
                result = name1.compareTo(name2 = o2.getName() == null ? "" : o2.getName());
                if (result != 0) {
                    return result;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
    }

    public <F extends RepoTransportFactory> F getRepoTransportFactoryOrFail(Class<F> factoryClass) {
        F repoTransportFactory = this.getRepoTransportFactory(factoryClass);
        if (repoTransportFactory == null) {
            throw new IllegalArgumentException("There is no factory registered implementing this interface or extending this class: " + factoryClass.getName());
        }
        return repoTransportFactory;
    }

    public <F extends RepoTransportFactory> F getRepoTransportFactory(Class<F> factoryClass) {
        AssertUtil.assertNotNull("factoryClass", factoryClass);
        List<RepoTransportFactory> repoTransportFactories = this.getRepoTransportFactories();
        for (RepoTransportFactory repoTransportFactory : repoTransportFactories) {
            if (!factoryClass.isInstance(repoTransportFactory)) continue;
            return (F)((RepoTransportFactory)factoryClass.cast(repoTransportFactory));
        }
        return null;
    }

    private static class RepoTransportFactoryRegistryHolder {
        public static final RepoTransportFactoryRegistry instance = new RepoTransportFactoryRegistry();

        private RepoTransportFactoryRegistryHolder() {
        }
    }
}

