/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.version;

import co.codewizards.cloudstore.core.dto.VersionInfoDto;
import co.codewizards.cloudstore.core.util.AssertUtil;

public class VersionCompatibilityException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final VersionInfoDto clientVersionInfoDto;
    private final VersionInfoDto serverVersionInfoDto;

    public VersionCompatibilityException(VersionInfoDto clientVersionInfoDto, VersionInfoDto serverVersionInfoDto, String message) {
        super(message);
        this.clientVersionInfoDto = AssertUtil.assertNotNull("clientVersionInfoDto", clientVersionInfoDto);
        this.serverVersionInfoDto = AssertUtil.assertNotNull("serverVersionInfoDto", serverVersionInfoDto);
        AssertUtil.assertNotNull("clientVersionInfoDto.localVersion", clientVersionInfoDto.getLocalVersion());
        AssertUtil.assertNotNull("clientVersionInfoDto.minimumRemoteVersion", clientVersionInfoDto.getMinimumRemoteVersion());
        AssertUtil.assertNotNull("serverVersionInfoDto.localVersion", serverVersionInfoDto.getLocalVersion());
        AssertUtil.assertNotNull("serverVersionInfoDto.minimumRemoteVersion", serverVersionInfoDto.getMinimumRemoteVersion());
    }

    public VersionInfoDto getClientVersionInfoDto() {
        return this.clientVersionInfoDto;
    }

    public VersionInfoDto getServerVersionInfoDto() {
        return this.serverVersionInfoDto;
    }
}

