/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.server;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.updater.CloudStoreUpdaterCore;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStoreUpdaterTimer {
    public static final long DEFAULT_TIMER_PERIOD = 900000L;
    public static final String CONFIG_KEY_TIMER_PERIOD = "updater.timer.period";
    private static final long ON_START_TIMER_PERIOD = 60000L;
    private static final Logger logger = LoggerFactory.getLogger(CloudStoreUpdaterTimer.class);
    private Timer timer;
    private TimerTask timerTask;

    public synchronized void start() {
        if (this.timer == null) {
            this.schedule(true);
        }
    }

    public synchronized void stop() {
        this.cancelTimerTask();
        this.cancelTimer();
    }

    protected synchronized void schedule(boolean onStart) {
        Date nextRun;
        this.cancelTimerTask();
        long timerPeriod = this.getTimerPeriod();
        if (timerPeriod <= 0L) {
            logger.info("schedule: timerPeriod={}. Disabling this timer!", (Object)timerPeriod);
            this.cancelTimer();
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer("CloudStoreUpdaterTimer");
        }
        if (this.timerTask != null) {
            throw new IllegalStateException("timerTask != null");
        }
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    CloudStoreUpdaterTimer.this.run();
                    CloudStoreUpdaterTimer.this.schedule(false);
                }
                catch (Exception x) {
                    logger.error("timerTask.run: " + x, (Throwable)x);
                }
            }
        };
        if (onStart) {
            nextRun = new Date(System.currentTimeMillis() + 60000L);
            logger.info("schedule: onStart=true nextRun={}", (Object)nextRun);
        } else {
            nextRun = new Date(System.currentTimeMillis() + timerPeriod);
            logger.info("schedule: timerPeriod={} nextRun={}", (Object)timerPeriod, (Object)nextRun);
        }
        this.timer.schedule(this.timerTask, nextRun);
    }

    protected synchronized void cancelTimerTask() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    protected synchronized void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected long getTimerPeriod() {
        Config config = ConfigImpl.getInstance();
        return config.getPropertyAsLong(CONFIG_KEY_TIMER_PERIOD, 900000L);
    }

    protected void run() {
        boolean updateNeeded = new CloudStoreUpdaterCore().createUpdaterDirIfUpdateNeeded();
        if (updateNeeded) {
            System.exit(0);
        }
    }
}

