/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke.refjanitor;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.core.invoke.ObjectManager;
import co.codewizards.cloudstore.ls.core.invoke.filter.ExtMethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.refjanitor.ReferenceJanitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceJanitorRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceJanitorRegistry.class);
    private final ObjectManager objectManager;
    private final List<ReferenceJanitor> referenceJanitors;

    public ReferenceJanitorRegistry(ObjectManager objectManager) {
        this.objectManager = (ObjectManager)AssertUtil.assertNotNull((String)"objectManager", (Object)objectManager);
        this.referenceJanitors = this.loadReferenceJanitors();
    }

    private List<ReferenceJanitor> loadReferenceJanitors() {
        ArrayList<ReferenceJanitor> result = new ArrayList<ReferenceJanitor>();
        Iterator<ReferenceJanitor> it = ServiceLoader.load(ReferenceJanitor.class).iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        Collections.sort(result, new Comparator<ReferenceJanitor>(){

            @Override
            public int compare(ReferenceJanitor o1, ReferenceJanitor o2) {
                int result = -1 * Integer.compare(o1.getPriority(), o2.getPriority());
                if (result != 0) {
                    return result;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
        result.trimToSize();
        return result;
    }

    public void cleanUp() {
        for (ReferenceJanitor referenceJanitor : this.referenceJanitors) {
            try {
                referenceJanitor.cleanUp();
            }
            catch (Exception x) {
                logger.error("cleanUp: " + x, (Throwable)x);
            }
        }
    }

    public void preInvoke(ExtMethodInvocationRequest extMethodInvocationRequest) {
        for (ReferenceJanitor referenceJanitor : this.referenceJanitors) {
            try {
                referenceJanitor.preInvoke(extMethodInvocationRequest);
            }
            catch (Exception x) {
                logger.error("preInvoke: " + x, (Throwable)x);
            }
        }
    }

    public void postInvoke(ExtMethodInvocationRequest extMethodInvocationRequest, Object resultObject, Throwable error) {
        for (ReferenceJanitor referenceJanitor : this.referenceJanitors) {
            try {
                referenceJanitor.postInvoke(extMethodInvocationRequest, resultObject, error);
            }
            catch (Exception x) {
                logger.error("preInvoke: " + x, (Throwable)x);
            }
        }
    }
}

