/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.dto.DateTime;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.server.service.AbstractServiceWithRepoToRepoAuth;
import co.codewizards.cloudstore.rest.server.webdav.COPY;
import co.codewizards.cloudstore.rest.server.webdav.MKCOL;
import co.codewizards.cloudstore.rest.server.webdav.MOVE;
import co.codewizards.cloudstore.rest.server.webdav.PROPFIND;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="{repositoryName:[^_/][^/]*}")
public class WebDavService
extends AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(WebDavService.class);

    public WebDavService() {
        logger.debug("<init>: created new instance");
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/octet-stream"})
    public byte[] getFileData(@PathParam(value="path") String path, @QueryParam(value="offset") long offset, @QueryParam(value="length") @DefaultValue(value="-1") int length) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            path = repoTransport.unprefixPath(path);
            byte[] byArray = repoTransport.getFileData(path, offset, length);
            return byArray;
        }
    }

    @MKCOL
    @Path(value="{path:.*}")
    public void mkcol(@PathParam(value="path") String path, @QueryParam(value="lastModified") DateTime lastModified) {
        throw new UnsupportedOperationException("NYI");
    }

    @DELETE
    @Path(value="{path:.*}")
    public void delete(@PathParam(value="path") String path) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            path = repoTransport.unprefixPath(path);
            repoTransport.delete(path);
        }
    }

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"application/octet-stream"})
    public void putFileData(@PathParam(value="path") String path, @QueryParam(value="offset") long offset, byte[] fileData) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            path = repoTransport.unprefixPath(path);
            repoTransport.putFileData(path, offset, fileData);
        }
    }

    @GET
    @Produces(value={"text/html"})
    public String browse() {
        return this.browse("");
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"text/html"})
    public String browse(@PathParam(value="path") String path) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        try (RepoTransport repoTransport = this.authenticateWithLdap();){
            path = repoTransport.unprefixPath(path);
            RepoFileDto dto = repoTransport.getRepoFileDto(path);
            String string = "<html><body>" + dto.toString() + "</body></html>";
            return string;
        }
    }

    @COPY
    @Path(value="{path:.*}")
    public void copy(@PathParam(value="path") String path, @HeaderParam(value="DESTINATION") String destination) {
        throw new UnsupportedOperationException("NYI");
    }

    @MOVE
    @Path(value="{path:.*}")
    public void move(@PathParam(value="path") String path, @HeaderParam(value="DESTINATION") String destination) {
        throw new UnsupportedOperationException("NYI");
    }

    @PROPFIND
    @Path(value="{path:.*}")
    public void propfind(@HeaderParam(value="CONTENT_LENGTH") long contentLength) {
        throw new UnsupportedOperationException("NYI");
    }
}

