/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.state.RelationshipManagerImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ManagedRelationsHandler {
    private boolean performChecks = false;
    private boolean executing = false;
    private Map<ObjectProvider, RelationshipManager> managedRelationDetails = null;

    public ManagedRelationsHandler(boolean performChecks) {
        this.performChecks = performChecks;
        this.managedRelationDetails = new ConcurrentHashMap<ObjectProvider, RelationshipManager>();
    }

    public void setPerformChecks(boolean checks) {
        this.performChecks = checks;
    }

    public RelationshipManager getRelationshipManagerForObjectProvider(ObjectProvider op) {
        RelationshipManager relMgr = this.managedRelationDetails.get(op);
        if (relMgr == null) {
            relMgr = new RelationshipManagerImpl(op);
            this.managedRelationDetails.put(op, relMgr);
        }
        return relMgr;
    }

    public void clear() {
        this.managedRelationDetails.clear();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void addRelationshipManagerForObjectProvider(ObjectProvider op, RelationshipManager relMgr) {
        this.managedRelationDetails.put(op, relMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.managedRelationDetails.isEmpty()) {
            return;
        }
        try {
            LifeCycleState lc;
            ObjectProvider op;
            this.executing = true;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("013000"));
            }
            if (this.performChecks) {
                for (Map.Entry<ObjectProvider, RelationshipManager> managedRelEntry : this.managedRelationDetails.entrySet()) {
                    op = managedRelEntry.getKey();
                    lc = op.getLifecycleState();
                    if (lc == null || lc.isDeleted()) continue;
                    managedRelEntry.getValue().checkConsistency();
                }
            }
            for (Map.Entry<ObjectProvider, RelationshipManager> managedRelEntry : this.managedRelationDetails.entrySet()) {
                op = managedRelEntry.getKey();
                lc = op.getLifecycleState();
                if (lc == null || lc.isDeleted()) continue;
                RelationshipManager relMgr = managedRelEntry.getValue();
                relMgr.process();
                relMgr.clearFields();
            }
            this.managedRelationDetails.clear();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("013001"));
            }
        }
        finally {
            this.executing = false;
        }
    }
}

