/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.welcome.identity;

import java.util.Objects;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.welcome.IdentityData;

public class IdentityPane
extends GridPane {
    private final IdentityData identityData;
    @FXML
    private Text headerText;
    @FXML
    protected Label firstNameLabel;
    @FXML
    protected TextField firstNameTextField;
    @FXML
    protected Label lastNameLabel;
    @FXML
    protected TextField lastNameTextField;
    @FXML
    protected Label emailLabel;
    @FXML
    protected TextField emailTextField;
    @FXML
    protected CheckBox importBackupCheckBox;

    public IdentityPane(IdentityData identityData) {
        this.identityData = Objects.requireNonNull(identityData, "identityData");
        FxmlUtil.loadDynamicComponentFxml(IdentityPane.class, this);
        this.firstNameTextField.textProperty().bindBidirectional((Property)identityData.firstNameProperty());
        this.lastNameTextField.textProperty().bindBidirectional((Property)identityData.lastNameProperty());
        this.emailTextField.textProperty().bindBidirectional((Property)identityData.getPgpUserId().emailProperty());
        this.importBackupCheckBox.selectedProperty().bindBidirectional((Property)identityData.importBackupProperty());
        this.firstNameLabel.disableProperty().bind((ObservableValue)this.importBackupCheckBox.selectedProperty());
        this.firstNameTextField.disableProperty().bind((ObservableValue)this.importBackupCheckBox.selectedProperty());
        this.lastNameLabel.disableProperty().bind((ObservableValue)this.importBackupCheckBox.selectedProperty());
        this.lastNameTextField.disableProperty().bind((ObservableValue)this.importBackupCheckBox.selectedProperty());
        this.emailLabel.disableProperty().bind((ObservableValue)this.importBackupCheckBox.selectedProperty());
        this.emailTextField.disableProperty().bind((ObservableValue)this.importBackupCheckBox.selectedProperty());
    }

    public void requestFocus() {
        super.requestFocus();
        this.firstNameTextField.requestFocus();
    }
}

