/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.dto;

import co.codewizards.cloudstore.core.dto.RepoFileDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class RepoFileDtoTreeNode
implements Iterable<RepoFileDtoTreeNode> {
    private static final Comparator<RepoFileDtoTreeNode> nodeComparatorByNameOnly = new Comparator<RepoFileDtoTreeNode>(){

        @Override
        public int compare(RepoFileDtoTreeNode node0, RepoFileDtoTreeNode node1) {
            String name0 = node0.getRepoFileDto().getName();
            String name1 = node1.getRepoFileDto().getName();
            return name0.compareTo(name1);
        }
    };
    private RepoFileDtoTreeNode parent;
    private final RepoFileDto repoFileDto;
    private final SortedSet<RepoFileDtoTreeNode> children = new TreeSet<RepoFileDtoTreeNode>(nodeComparatorByNameOnly);
    private List<RepoFileDtoTreeNode> flattenedTreeList;

    public static RepoFileDtoTreeNode createTree(Collection<RepoFileDto> repoFileDtos) throws IllegalArgumentException {
        Objects.requireNonNull(repoFileDtos, "repoFileDtos");
        if (repoFileDtos.isEmpty()) {
            return null;
        }
        HashMap<Long, RepoFileDtoTreeNode> id2RepoFileDtoTreeNode = new HashMap<Long, RepoFileDtoTreeNode>();
        for (RepoFileDto repoFileDto : repoFileDtos) {
            id2RepoFileDtoTreeNode.put(repoFileDto.getId(), new RepoFileDtoTreeNode(repoFileDto));
        }
        RepoFileDtoTreeNode rootNode = null;
        for (RepoFileDtoTreeNode node : id2RepoFileDtoTreeNode.values()) {
            Long parentId = node.getRepoFileDto().getParentId();
            if (parentId == null) {
                if (rootNode != null) {
                    throw new IllegalArgumentException("Multiple root nodes!");
                }
                rootNode = node;
                continue;
            }
            RepoFileDtoTreeNode parentNode = (RepoFileDtoTreeNode)id2RepoFileDtoTreeNode.get(parentId);
            if (parentNode == null) {
                throw new IllegalArgumentException("parentEntityID unknown: " + parentId);
            }
            parentNode.addChild(node);
        }
        if (rootNode == null) {
            throw new IllegalArgumentException("There is no root node!");
        }
        return rootNode;
    }

    protected RepoFileDtoTreeNode(RepoFileDto repoFileDto) {
        this.repoFileDto = Objects.requireNonNull(repoFileDto, "repoFileDto");
    }

    public RepoFileDto getRepoFileDto() {
        return this.repoFileDto;
    }

    public RepoFileDtoTreeNode getParent() {
        return this.parent;
    }

    protected void setParent(RepoFileDtoTreeNode parent) {
        this.parent = parent;
    }

    public Set<RepoFileDtoTreeNode> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    protected void addChild(RepoFileDtoTreeNode child) {
        child.setParent(this);
        this.children.add(child);
    }

    public String getPath() {
        RepoFileDtoTreeNode parent = this.getParent();
        if (parent == null) {
            return this.getRepoFileDto().getName();
        }
        return parent.getPath() + '/' + this.getRepoFileDto().getName();
    }

    public List<RepoFileDtoTreeNode> getLeafs() {
        ArrayList<RepoFileDtoTreeNode> leafs = new ArrayList<RepoFileDtoTreeNode>();
        this.populateLeafs(this, leafs);
        return leafs;
    }

    private void populateLeafs(RepoFileDtoTreeNode node, List<RepoFileDtoTreeNode> leafs) {
        if (node.getChildren().isEmpty()) {
            leafs.add(node);
        }
        for (RepoFileDtoTreeNode child : node.getChildren()) {
            this.populateLeafs(child, leafs);
        }
    }

    @Override
    public Iterator<RepoFileDtoTreeNode> iterator() {
        return new MyIterator(this.getFlattenedTreeList().iterator());
    }

    public int size() {
        return this.getFlattenedTreeList().size();
    }

    private List<RepoFileDtoTreeNode> getFlattenedTreeList() {
        if (this.flattenedTreeList == null) {
            LinkedList<RepoFileDtoTreeNode> list = new LinkedList<RepoFileDtoTreeNode>();
            this.flattenTree(list, this);
            this.flattenedTreeList = list;
        }
        return this.flattenedTreeList;
    }

    private void flattenTree(List<RepoFileDtoTreeNode> result, RepoFileDtoTreeNode node) {
        result.add(node);
        for (RepoFileDtoTreeNode child : node.getChildren()) {
            this.flattenTree(result, child);
        }
    }

    public RepoFileDtoTreeNode getRoot() {
        RepoFileDtoTreeNode parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return parent.getRoot();
    }

    private class MyIterator
    implements Iterator<RepoFileDtoTreeNode> {
        private final Iterator<RepoFileDtoTreeNode> delegate;
        private RepoFileDtoTreeNode current;

        public MyIterator(Iterator<RepoFileDtoTreeNode> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public RepoFileDtoTreeNode next() {
            this.current = this.delegate.next();
            return this.current;
        }

        @Override
        public void remove() {
            RepoFileDtoTreeNode p;
            if (this.current != null && (p = this.current.getParent()) != null && p.children != null) {
                p.children.remove(this.current);
            }
            this.delegate.remove();
        }
    }
}

