/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.io.TimeoutException;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.progress.SubProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.CreateRepositoryContext;
import co.codewizards.cloudstore.core.repo.local.FileAlreadyRepositoryException;
import co.codewizards.cloudstore.core.repo.local.FileNoDirectoryException;
import co.codewizards.cloudstore.core.repo.local.FileNoRepositoryException;
import co.codewizards.cloudstore.core.repo.local.FileNotFoundException;
import co.codewizards.cloudstore.core.repo.local.LocalRepoHelper;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerCloseEvent;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerCloseListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerException;
import co.codewizards.cloudstore.core.repo.local.LocalRepoMetaData;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.repo.local.RepositoryCorruptException;
import co.codewizards.cloudstore.core.util.DerbyUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.LocalRepoMetaDataImpl;
import co.codewizards.cloudstore.local.LocalRepoSync;
import co.codewizards.cloudstore.local.LocalRepoTransactionImpl;
import co.codewizards.cloudstore.local.PersistencePropertiesEnum;
import co.codewizards.cloudstore.local.PersistencePropertiesProvider;
import co.codewizards.cloudstore.local.db.DatabaseAdapter;
import co.codewizards.cloudstore.local.db.DatabaseAdapterFactoryRegistry;
import co.codewizards.cloudstore.local.dbupdate.DbUpdateManager;
import co.codewizards.cloudstore.local.dbupdate.DbUpdateStepRegistry;
import co.codewizards.cloudstore.local.persistence.CloudStorePersistenceCapableClassesProvider;
import co.codewizards.cloudstore.local.persistence.Directory;
import co.codewizards.cloudstore.local.persistence.LocalRepository;
import co.codewizards.cloudstore.local.persistence.LocalRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryRequest;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryRequestDao;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalRepoManagerImpl
implements LocalRepoManager {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepoManagerImpl.class);
    protected final String id = Integer.toHexString(System.identityHashCode(this));
    private long closeDeferredMillis = Long.MIN_VALUE;
    private static final long lockTimeoutMillis = 30000L;
    private static final long remoteRepositoryRequestExpiryAge = 86400000L;
    private final File localRoot;
    private LockFile lockFile;
    private UUID repositoryId;
    private Properties repositoryProperties;
    private PersistenceManagerFactory persistenceManagerFactory;
    private final AtomicInteger openReferenceCounter = new AtomicInteger();
    private final List<LocalRepoManagerCloseListener> localRepoManagerCloseListeners = new CopyOnWriteArrayList<LocalRepoManagerCloseListener>();
    private String connectionURL;
    private boolean deleteMetaDir;
    private int closeDeferredTimerSerial;
    private Timer closeDeferredTimer;
    private TimerTask closeDeferredTimerTask;
    private final Lock lock = new ReentrantLock();
    private final long created = System.currentTimeMillis();
    private LocalRepoMetaDataImpl localRepoMetaDataImpl;
    private final Timer deleteExpiredRemoteRepositoryRequestsTimer = new Timer("deleteExpiredRemoteRepositoryRequestsTimer-" + this.id, true);
    private final TimerTask deleteExpiredRemoteRepositoryRequestsTimeTask = new TimerTask(){

        @Override
        public void run() {
            if (LocalRepoManagerImpl.this.isOpen()) {
                LocalRepoManagerImpl.this.deleteExpiredRemoteRepositoryRequests();
            }
        }
    };
    private byte[] privateKey;
    private byte[] publicKey;
    private boolean closing;
    private boolean closeAbortable;
    private static final String KEY_STORE_PASSWORD_STRING = "CloudStore-key-store";
    private static final char[] KEY_STORE_PASSWORD_CHAR_ARRAY = "CloudStore-key-store".toCharArray();
    private final SecureRandom random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocalRepoManagerImpl(File localRoot, boolean createRepository) throws LocalRepoManagerException {
        this.deleteExpiredRemoteRepositoryRequestsTimer.schedule(this.deleteExpiredRemoteRepositoryRequestsTimeTask, 3600000L, 3600000L);
        this.closeAbortable = true;
        this.random = new SecureRandom();
        logger.info("[{}]<init>: localRoot='{}'", (Object)this.id, (Object)localRoot);
        this.localRoot = this.assertValidLocalRoot(localRoot);
        boolean releaseLockFile = true;
        this.deleteMetaDir = false;
        try {
            if (createRepository) {
                this.repositoryId = (UUID)CreateRepositoryContext.repositoryIdThreadLocal.get();
                if (this.repositoryId == null) {
                    this.repositoryId = UUID.randomUUID();
                }
            }
            this.initMetaDir(createRepository);
            this.initPersistenceManagerFactory(createRepository);
            this.deleteExpiredRemoteRepositoryRequests();
            this.syncWithLocalRepoRegistry();
            this.updateRepositoryPropertiesFile();
            releaseLockFile = false;
            this.deleteMetaDir = false;
        }
        finally {
            if (releaseLockFile && this.lockFile != null) {
                this.lockFile.release();
            }
            if (this.deleteMetaDir) {
                IOUtil.deleteDirectoryRecursively((File)this.getMetaDir());
            }
        }
    }

    private UUID readRepositoryIdFromRepositoryPropertiesFile() {
        File repositoryPropertiesFile = OioFileFactory.createFile((File)this.getMetaDir(), (String[])new String[]{REPOSITORY_PROPERTIES_FILE_NAME});
        try {
            Properties repositoryProperties = new Properties();
            try (InputStream in = StreamUtil.castStream((IInputStream)repositoryPropertiesFile.createInputStream());){
                repositoryProperties.load(in);
            }
            String repositoryIdStr = repositoryProperties.getProperty("repository.id");
            if (StringUtil.isEmpty((String)repositoryIdStr)) {
                throw new IllegalStateException("repositoryProperties.getProperty(PROP_REPOSITORY_ID) is empty!");
            }
            UUID repositoryId = UUID.fromString(repositoryIdStr);
            return repositoryId;
        }
        catch (Exception x) {
            throw new RuntimeException("Reading readRepositoryId from '" + repositoryPropertiesFile.getAbsolutePath() + "' failed: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRepositoryAlias(String repositoryAlias) {
        Objects.requireNonNull(repositoryAlias, "repositoryAlias");
        LocalRepoTransactionImpl transaction = this.beginWriteTransaction();
        try {
            LocalRepository localRepository = transaction.getDao(LocalRepositoryDao.class).getLocalRepositoryOrFail();
            if (!localRepository.getAliases().contains(repositoryAlias)) {
                localRepository.getAliases().add(repositoryAlias);
            }
            LocalRepoRegistryImpl.getInstance().putRepositoryAlias(repositoryAlias, this.repositoryId);
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryAlias(String repositoryAlias) {
        Objects.requireNonNull(repositoryAlias, "repositoryAlias");
        LocalRepoTransactionImpl transaction = this.beginWriteTransaction();
        try {
            LocalRepository localRepository = transaction.getDao(LocalRepositoryDao.class).getLocalRepositoryOrFail();
            localRepository.getAliases().remove(repositoryAlias);
            LocalRepoRegistryImpl.getInstance().removeRepositoryAlias(repositoryAlias);
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
    }

    private File assertValidLocalRoot(File localRoot) {
        Objects.requireNonNull(localRoot, "localRoot");
        if (!localRoot.isAbsolute()) {
            throw new IllegalArgumentException("localRoot is not absolute.");
        }
        if (!localRoot.exists()) {
            throw new FileNotFoundException(localRoot);
        }
        if (!localRoot.isDirectory()) {
            throw new FileNoDirectoryException(localRoot);
        }
        this.assertNotInsideOtherRepository(localRoot);
        this.assertNotContainingOtherRepository(localRoot);
        return localRoot;
    }

    private void assertNotInsideOtherRepository(File localRoot) {
        File localRootFound = LocalRepoHelper.getLocalRootContainingFile((File)localRoot);
        if (localRootFound != null && !localRootFound.equals(localRoot)) {
            throw new FileAlreadyRepositoryException(localRoot);
        }
    }

    private void assertNotContainingOtherRepository(File localRoot) {
        File localRootFound = LocalRepoHelper.getLocalRootContainingFile((File)localRoot);
        if (localRootFound != null && localRootFound.equals(localRoot)) {
            return;
        }
        Collection localRootsFound = LocalRepoHelper.getLocalRootsContainedInDirectory((File)localRoot);
        if (!localRootsFound.isEmpty()) {
            throw new FileAlreadyRepositoryException(localRoot);
        }
    }

    private void initMetaDir(boolean createRepository) throws LocalRepoManagerException {
        block19: {
            File metaDir = this.getMetaDir();
            if (createRepository) {
                if (metaDir.exists()) {
                    throw new FileAlreadyRepositoryException(this.localRoot);
                }
                this.deleteMetaDir = true;
                metaDir.mkdir();
                this.initLockFile();
                try (DatabaseAdapter databaseAdapter = DatabaseAdapterFactoryRegistry.getInstance().createDatabaseAdapter();){
                    databaseAdapter.setRepositoryId(Objects.requireNonNull(this.repositoryId, "repositoryId"));
                    databaseAdapter.setLocalRoot(Objects.requireNonNull(this.localRoot, "localRoot"));
                    this.createRepositoryPropertiesFile(databaseAdapter);
                    databaseAdapter.createPersistencePropertiesFileAndDatabase();
                    break block19;
                }
                catch (Exception x) {
                    throw new LocalRepoManagerException((Throwable)x);
                }
            }
            if (!metaDir.exists()) {
                throw new FileNoRepositoryException(this.localRoot);
            }
            this.initLockFile();
            try {
                this.repositoryId = this.readRepositoryIdFromRepositoryPropertiesFile();
                try (DatabaseAdapter databaseAdapter = DatabaseAdapterFactoryRegistry.getInstance().createDatabaseAdapter();){
                    databaseAdapter.setRepositoryId(Objects.requireNonNull(this.repositoryId, "repositoryId"));
                    databaseAdapter.setLocalRoot(Objects.requireNonNull(this.localRoot, "localRoot"));
                    this.checkRepositoryPropertiesFile(databaseAdapter, true);
                }
            }
            catch (Exception x) {
                throw new LocalRepoManagerException((Throwable)x);
            }
        }
    }

    private void initLockFile() {
        File lock = OioFileFactory.createFile((File)this.getMetaDir(), (String[])new String[]{REPOSITORY_LOCK_FILE_NAME});
        try {
            this.lockFile = LockFileFactory.getInstance().acquire(lock, 100L);
        }
        catch (TimeoutException x) {
            logger.warn("[{}]initLockFile: Repository '{}' is currently locked by another process. Will wait {} ms for it...", new Object[]{this.id, this.localRoot, 30000L});
        }
        if (this.lockFile == null) {
            this.lockFile = LockFileFactory.getInstance().acquire(lock, 30000L);
        }
        logger.info("[{}]initLockFile: Repository '{}' locked successfully.", (Object)this.id, (Object)this.localRoot);
    }

    private void createRepositoryPropertiesFile(DatabaseAdapter databaseAdapter) {
        Objects.requireNonNull(databaseAdapter, "databaseAdapter");
        DbUpdateStepRegistry dbUpdateStepRegistry = new DbUpdateStepRegistry();
        int version = dbUpdateStepRegistry.getCurrentVersion();
        File repositoryPropertiesFile = OioFileFactory.createFile((File)this.getMetaDir(), (String[])new String[]{REPOSITORY_PROPERTIES_FILE_NAME});
        try {
            this.repositoryProperties = new Properties();
            this.repositoryProperties.setProperty("repository.id", Objects.requireNonNull(this.repositoryId, "repositoryId").toString());
            this.repositoryProperties.setProperty("repository.version", Integer.valueOf(version).toString());
            PropertiesUtil.store((File)repositoryPropertiesFile, (Properties)this.repositoryProperties, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkRepositoryPropertiesFile(DatabaseAdapter databaseAdapter, boolean update) throws LocalRepoManagerException {
        int currentVersion;
        DbUpdateStepRegistry dbUpdateStepRegistry = new DbUpdateStepRegistry();
        DbUpdateManager dbUpdateManager = new DbUpdateManager(this.localRoot, dbUpdateStepRegistry, databaseAdapter);
        this.repositoryProperties = dbUpdateManager.readRepositoryProperties();
        int ver = dbUpdateManager.readRepositoryVersion();
        if (ver > (currentVersion = dbUpdateStepRegistry.getCurrentVersion())) {
            throw new RepositoryCorruptException(this.localRoot, String.format("DB is too new: Repository is version %d and thus newer than expected version %d!", ver, currentVersion));
        }
        if (ver < currentVersion) {
            if (update) {
                dbUpdateManager.performUpdate();
                this.checkRepositoryPropertiesFile(databaseAdapter, false);
            } else {
                throw new RepositoryCorruptException(this.localRoot, String.format("DB-update failed: Repository is version %d and not expected version %d!", ver, currentVersion));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncWithLocalRepoRegistry() {
        Objects.requireNonNull(this.repositoryId, "repositoryId");
        LocalRepoRegistry localRepoRegistry = LocalRepoRegistryImpl.getInstance();
        localRepoRegistry.putRepository(this.repositoryId, this.localRoot);
        LocalRepoTransactionImpl transaction = this.beginWriteTransaction();
        try {
            LocalRepository localRepository = transaction.getDao(LocalRepositoryDao.class).getLocalRepositoryOrFail();
            for (String repositoryAlias : new ArrayList<String>(localRepository.getAliases())) {
                UUID repositoryIdInRegistry = localRepoRegistry.getRepositoryId(repositoryAlias);
                if (repositoryIdInRegistry == null) {
                    localRepoRegistry.putRepositoryAlias(repositoryAlias, this.repositoryId);
                    logger.info("syncWithLocalRepoRegistry: Alias '{}' of repository '{}' copied from repo to repoRegistry.", (Object)repositoryAlias, (Object)this.repositoryId);
                    continue;
                }
                if (this.repositoryId.equals(repositoryIdInRegistry)) {
                    logger.debug("syncWithLocalRepoRegistry: Alias '{}' of repository '{}' already in-sync.", (Object)repositoryAlias, (Object)this.repositoryId);
                    continue;
                }
                localRepository.getAliases().remove(repositoryAlias);
                logger.warn("syncWithLocalRepoRegistry: Alias '{}' removed from repository '{}', because of conflicting entry (repository '{}') in localRepoRegistry.", new Object[]{repositoryAlias, this.repositoryId, repositoryIdInRegistry});
            }
            Collection repositoryAliases = localRepoRegistry.getRepositoryAliases(this.repositoryId.toString());
            if (repositoryAliases != null) {
                for (String repositoryAlias : repositoryAliases) {
                    if (localRepository.getAliases().contains(repositoryAlias)) continue;
                    localRepository.getAliases().add(repositoryAlias);
                    logger.info("syncWithLocalRepoRegistry: Alias '{}' of repository '{}' copied from repoRegistry to repo.", (Object)repositoryAlias, (Object)this.repositoryId);
                }
            }
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRepositoryPropertiesFile() {
        Objects.requireNonNull(this.repositoryProperties, "repositoryProperties");
        File repositoryPropertiesFile = OioFileFactory.createFile((File)this.getMetaDir(), (String[])new String[]{REPOSITORY_PROPERTIES_FILE_NAME});
        try {
            boolean store = false;
            String repositoryId = Objects.requireNonNull(this.getRepositoryId(), "repositoryId").toString();
            if (!repositoryId.equals(this.repositoryProperties.getProperty("repository.id"))) {
                this.repositoryProperties.setProperty("repository.id", repositoryId);
                store = true;
            }
            LocalRepoTransactionImpl transaction = this.beginReadTransaction();
            try {
                LocalRepository localRepository = transaction.getDao(LocalRepositoryDao.class).getLocalRepositoryOrFail();
                TreeSet<String> repositoryAliases = new TreeSet<String>(localRepository.getAliases());
                String aliasesString = this.repositoryAliasesToString(repositoryAliases);
                if (!aliasesString.equals(this.repositoryProperties.getProperty("repository.aliases"))) {
                    this.repositoryProperties.setProperty("repository.aliases", aliasesString);
                    store = true;
                }
                transaction.commit();
            }
            finally {
                transaction.rollbackIfActive();
            }
            if (store) {
                PropertiesUtil.store((File)repositoryPropertiesFile, (Properties)this.repositoryProperties, null);
            }
            this.repositoryProperties = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String repositoryAliasesToString(Set<String> repositoryAliases) {
        Objects.requireNonNull(repositoryAliases, "repositoryAliases");
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        for (String repositoryAlias : repositoryAliases) {
            sb.append(repositoryAlias);
            sb.append('/');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPersistenceManagerFactory(boolean createRepository) throws LocalRepoManagerException {
        logger.debug("[{}]initPersistenceManagerFactory: Starting up PersistenceManagerFactory...", (Object)this.id);
        long beginTimestamp = System.currentTimeMillis();
        this.initPersistenceManagerFactoryAndPersistenceCapableClasses(createRepository);
        PersistenceManager pm = this.persistenceManagerFactory.getPersistenceManager();
        try {
            pm.currentTransaction().begin();
            if (createRepository) {
                this.createAndPersistLocalRepository(pm);
            } else {
                this.assertSinglePersistentLocalRepository(pm);
            }
            logger.info("[{}]initPersistenceManagerFactory: repositoryId={}", (Object)this.id, (Object)this.repositoryId);
            pm.currentTransaction().commit();
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
        logger.info("[{}]initPersistenceManagerFactory: Started up PersistenceManagerFactory successfully in {} ms.", (Object)this.id, (Object)(System.currentTimeMillis() - beginTimestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExpiredRemoteRepositoryRequests() {
        this.lock.lock();
        try {
            PersistenceManager pm = this.persistenceManagerFactory.getPersistenceManager();
            try {
                pm.currentTransaction().begin();
                RemoteRepositoryRequestDao dao = (RemoteRepositoryRequestDao)new RemoteRepositoryRequestDao().persistenceManager(pm);
                Collection<RemoteRepositoryRequest> expiredRequests = dao.getRemoteRepositoryRequestsChangedBefore(new Date(System.currentTimeMillis() - 86400000L));
                pm.deletePersistentAll(expiredRequests);
                pm.currentTransaction().commit();
            }
            finally {
                if (pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                }
                pm.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPersistenceManagerFactoryAndPersistenceCapableClasses(boolean createRepository) {
        Map<String, String> persistenceProperties = this.getPersistenceProperties(createRepository);
        this.persistenceManagerFactory = JDOHelper.getPersistenceManagerFactory(persistenceProperties);
        try (PersistenceManager pm = this.persistenceManagerFactory.getPersistenceManager();){
            try {
                this.initPersistenceCapableClasses(pm);
            }
            catch (Exception x) {
                if (x instanceof RuntimeException) {
                    throw (RuntimeException)x;
                }
                throw new RuntimeException(x);
            }
        }
    }

    private void initPersistenceCapableClasses(PersistenceManager pm) {
        ServiceLoader<CloudStorePersistenceCapableClassesProvider> sl = ServiceLoader.load(CloudStorePersistenceCapableClassesProvider.class);
        for (CloudStorePersistenceCapableClassesProvider provider : sl) {
            Class<?>[] classes = provider.getPersistenceCapableClasses();
            if (classes == null) continue;
            for (Class<?> clazz : classes) {
                Class c = ObjectFactoryUtil.getExtendingClass(clazz);
                pm.getExtent(c);
            }
        }
    }

    private void assertSinglePersistentLocalRepository(PersistenceManager pm) {
        try {
            LocalRepository localRepository = ((LocalRepositoryDao)new LocalRepositoryDao().persistenceManager(pm)).getLocalRepositoryOrFail();
            this.readRepositoryMainProperties(localRepository);
        }
        catch (IllegalStateException x) {
            throw new RepositoryCorruptException(this.localRoot, x.getMessage());
        }
    }

    private void createAndPersistLocalRepository(PersistenceManager pm) {
        LocalRepository localRepository = (LocalRepository)ObjectFactoryUtil.createObject(LocalRepository.class, (Object[])new Object[]{Objects.requireNonNull(this.repositoryId, "repositoryId")});
        Directory root = (Directory)ObjectFactoryUtil.createObject(Directory.class);
        root.setName("");
        root.setLastModified(new Date(this.localRoot.lastModified()));
        localRepository.setRoot(root);
        this.generatePublicPrivateKey(localRepository);
        localRepository = (LocalRepository)pm.makePersistent((Object)localRepository);
        this.readRepositoryMainProperties(localRepository);
    }

    private void readRepositoryMainProperties(LocalRepository localRepository) {
        Objects.requireNonNull(localRepository, "localRepository");
        this.repositoryId = Objects.requireNonNull(localRepository.getRepositoryId(), "localRepository.repositoryId");
        this.publicKey = Objects.requireNonNull(localRepository.getPublicKey(), "localRepository.publicKey");
        this.privateKey = Objects.requireNonNull(localRepository.getPrivateKey(), "localRepository.privateKey");
    }

    private void generatePublicPrivateKey(LocalRepository localRepository) {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, KEY_STORE_PASSWORD_CHAR_ARRAY);
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(this.getKeySize(), this.random);
            KeyPair pair = keyGen.generateKeyPair();
            localRepository.setPrivateKey(pair.getPrivate().getEncoded());
            localRepository.setPublicKey(pair.getPublic().getEncoded());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File getMetaDir() {
        return OioFileFactory.createFile((File)this.localRoot, (String[])new String[]{META_DIR_NAME});
    }

    private Map<String, String> getPersistenceProperties(boolean createRepository) {
        Map<String, String> persistenceProperties = new PersistencePropertiesProvider(this.repositoryId, this.localRoot).getPersistenceProperties();
        this.connectionURL = persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_URL.key);
        return persistenceProperties;
    }

    public File getLocalRoot() {
        return this.localRoot;
    }

    protected PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void addLocalRepoManagerCloseListener(LocalRepoManagerCloseListener listener) {
        this.localRepoManagerCloseListeners.add(listener);
    }

    public void removeLocalRepoManagerCloseListener(LocalRepoManagerCloseListener listener) {
        this.localRepoManagerCloseListeners.remove(listener);
    }

    protected boolean open() {
        boolean result;
        this.lock.lock();
        try {
            logger.debug("[{}]open: closing={} closeAbortable={}", new Object[]{this.id, this.closing, this.closeAbortable});
            boolean bl = result = !this.closing || this.closeAbortable;
            if (result) {
                this.closing = false;
                this.closeAbortable = true;
                if (this.closeDeferredTimerTask != null) {
                    this.closeDeferredTimerTask.cancel();
                    this.closeDeferredTimerTask = null;
                }
                if (this.closeDeferredTimer != null) {
                    this.closeDeferredTimer.cancel();
                    this.closeDeferredTimer = null;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (result) {
            this.openReferenceCounter.incrementAndGet();
        }
        return result;
    }

    protected long getCloseDeferredMillis() {
        if (this.closeDeferredMillis < 0L) {
            long closeDeferredMillis = PropertiesUtil.getSystemPropertyValueAsLong((String)SYSTEM_PROPERTY_CLOSE_DEFERRED_MILLIS, (long)-1L);
            if (closeDeferredMillis < 0L) {
                closeDeferredMillis = ConfigImpl.getInstance().getPropertyAsPositiveOrZeroLong("localRepoManager.closeDeferredMillis", 20000L);
            }
            this.closeDeferredMillis = closeDeferredMillis;
            logger.info("[{}]getCloseDeferredMillis: closeDeferredMillis={}", (Object)this.id, (Object)closeDeferredMillis);
        }
        return this.closeDeferredMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        this.lock.lock();
        try {
            this.closing = true;
        }
        finally {
            this.lock.unlock();
        }
        int openReferenceCounterValue = this.openReferenceCounter.decrementAndGet();
        if (openReferenceCounterValue > 0) {
            logger.debug("[{}]close: leaving with openReferenceCounterValue={}", (Object)this.id, (Object)openReferenceCounterValue);
            return;
        }
        if (openReferenceCounterValue < 0) {
            throw new IllegalStateException("openReferenceCounterValue < 0");
        }
        long closeDeferredMillis = this.getCloseDeferredMillis();
        if (closeDeferredMillis > 0L) {
            logger.info("[{}]close: Deferring shut down of real LocalRepoManager {} ms.", (Object)this.id, (Object)closeDeferredMillis);
            this.lock.lock();
            try {
                if (this.closeDeferredTimer == null) {
                    this.closeDeferredTimer = new Timer("closeDeferredTimer-" + this.id + '-' + Integer.toString(++this.closeDeferredTimerSerial, 36), true);
                }
                if (this.closeDeferredTimerTask != null) return;
                this.closeDeferredTimerTask = new CloseTimerTask();
                this.closeDeferredTimer.schedule(this.closeDeferredTimerTask, closeDeferredMillis);
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            logger.info("[{}]close: Closing real LocalRepoManager immediately.", (Object)this.id, (Object)closeDeferredMillis);
            this._close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _close() {
        LocalRepoManagerCloseEvent event;
        block19: {
            this.lock.lock();
            try {
                if (!this.closing) {
                    logger.info("[{}]_close: Closing was aborted. Returning immediately.", (Object)this.id);
                    return;
                }
                this.closeAbortable = false;
                if (this.closeDeferredTimerTask != null) {
                    this.closeDeferredTimerTask.cancel();
                    this.closeDeferredTimerTask = null;
                }
            }
            finally {
                this.lock.unlock();
            }
            logger.info("[{}]_close: Shutting down real LocalRepoManager.", (Object)this.id);
            event = new LocalRepoManagerCloseEvent((Object)this, (LocalRepoManager)this, true);
            for (LocalRepoManagerCloseListener listener : this.localRepoManagerCloseListeners) {
                listener.preClose(event);
            }
            this.deleteExpiredRemoteRepositoryRequestsTimer.cancel();
            this.lock.lock();
            try {
                if (this.persistenceManagerFactory != null) {
                    try {
                        this.persistenceManagerFactory.close();
                    }
                    catch (Exception x) {
                        logger.warn("Closing PersistenceManagerFactory failed: " + x, (Throwable)x);
                    }
                    this.persistenceManagerFactory = null;
                    try {
                        DerbyUtil.shutdownDerbyDatabase((String)this.connectionURL);
                    }
                    catch (Exception x) {
                        logger.warn("Shutting down Derby database failed: " + x, (Throwable)x);
                    }
                }
                if (this.lockFile == null) break block19;
                try {
                    this.lockFile.release();
                }
                catch (Exception x) {
                    logger.warn("Releasing LockFile failed: " + x, (Throwable)x);
                }
                this.lockFile = null;
            }
            finally {
                this.lock.unlock();
            }
        }
        for (LocalRepoManagerCloseListener listener : this.localRepoManagerCloseListeners) {
            listener.postClose(event);
        }
    }

    public UUID getRepositoryId() {
        return this.repositoryId;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRemoteRepositoryPublicKeyOrFail(UUID repositoryId) {
        byte[] result;
        LocalRepoTransactionImpl transaction = this.beginReadTransaction();
        try {
            RemoteRepository remoteRepository = transaction.getDao(RemoteRepositoryDao.class).getRemoteRepositoryOrFail(repositoryId);
            result = remoteRepository.getPublicKey();
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
        return result;
    }

    public boolean isOpen() {
        this.lock.lock();
        try {
            boolean bl = this.persistenceManagerFactory != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void assertOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("This LocalRepoManagerImpl is closed!");
        }
    }

    public LocalRepoTransactionImpl beginReadTransaction() {
        this.lock.lock();
        try {
            this.assertOpen();
            LocalRepoTransactionImpl localRepoTransactionImpl = new LocalRepoTransactionImpl(this, false);
            return localRepoTransactionImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public LocalRepoTransactionImpl beginWriteTransaction() {
        this.lock.lock();
        try {
            this.assertOpen();
            LocalRepoTransactionImpl localRepoTransactionImpl = new LocalRepoTransactionImpl(this, true);
            return localRepoTransactionImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localSync(ProgressMonitor monitor) {
        monitor.beginTask("Local sync...", 100);
        try {
            LocalRepoTransactionImpl transaction = this.beginWriteTransaction();
            try {
                monitor.worked(1);
                LocalRepoSync.create(transaction).ignoreRulesEnabled(true).sync((ProgressMonitor)new SubProgressMonitor(monitor, 98));
                transaction.commit();
                monitor.worked(1);
            }
            finally {
                transaction.rollbackIfActive();
            }
        }
        finally {
            monitor.done();
        }
    }

    public Map<UUID, URL> getRemoteRepositoryId2RemoteRootMap() {
        Map<UUID, URL> result;
        try (LocalRepoTransactionImpl transaction = this.beginReadTransaction();){
            result = ((RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryId2RemoteRootMap();
            transaction.commit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRemoteRepository(UUID repositoryId, URL remoteRoot, byte[] publicKey, String localPathPrefix) {
        Objects.requireNonNull(repositoryId, "repositoryId");
        Objects.requireNonNull(publicKey, "publicKey");
        LocalRepoTransactionImpl transaction = this.beginWriteTransaction();
        try {
            RemoteRepository otherRepoWithSameRemoteRoot;
            RemoteRepositoryDao remoteRepositoryDao = transaction.getDao(RemoteRepositoryDao.class);
            if (remoteRoot != null && (otherRepoWithSameRemoteRoot = remoteRepositoryDao.getRemoteRepository(remoteRoot)) != null && !repositoryId.equals(otherRepoWithSameRemoteRoot.getRepositoryId())) {
                throw new IllegalStateException(String.format("Duplicate remoteRoot! The RemoteRepository '%s' already has the same remoteRoot '%s'! The remoteRoot must be unique!", otherRepoWithSameRemoteRoot.getRepositoryId(), remoteRoot));
            }
            RemoteRepository remoteRepository = remoteRepositoryDao.getRemoteRepository(repositoryId);
            if (remoteRepository == null) {
                remoteRepository = (RemoteRepository)ObjectFactoryUtil.createObject(RemoteRepository.class, (Object[])new Object[]{repositoryId});
                remoteRepository.setRevision(-1L);
            }
            remoteRepository.setRemoteRoot(remoteRoot);
            remoteRepository.setPublicKey(publicKey);
            remoteRepository.setLocalPathPrefix(localPathPrefix);
            remoteRepositoryDao.makePersistent(remoteRepository);
            RemoteRepositoryRequestDao remoteRepositoryRequestDao = transaction.getDao(RemoteRepositoryRequestDao.class);
            RemoteRepositoryRequest remoteRepositoryRequest = remoteRepositoryRequestDao.getRemoteRepositoryRequest(repositoryId);
            if (remoteRepositoryRequest != null) {
                remoteRepositoryRequestDao.deletePersistent(remoteRepositoryRequest);
            }
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRemoteRepository(UUID repositoryId) {
        Objects.requireNonNull(repositoryId, "entityID");
        LocalRepoTransactionImpl transaction = this.beginWriteTransaction();
        try {
            RemoteRepositoryDao remoteRepositoryDao = transaction.getDao(RemoteRepositoryDao.class);
            RemoteRepository remoteRepository = remoteRepositoryDao.getRemoteRepository(repositoryId);
            if (remoteRepository != null) {
                remoteRepositoryDao.deletePersistent(remoteRepository);
            }
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
    }

    protected int getKeySize() {
        int keySize = PropertiesUtil.getSystemPropertyValueAsInt((String)SYSTEM_PROPERTY_KEY_SIZE, (int)4096);
        if (keySize < 1024) {
            logger.warn("System property '{}': keySize {} is out of range! Using default {} instead!", new Object[]{SYSTEM_PROPERTY_KEY_SIZE, keySize, 4096});
            return 4096;
        }
        return keySize;
    }

    public Lock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalPathPrefixOrFail(URL remoteRoot) {
        String localPathPrefix;
        LocalRepoTransactionImpl transaction = this.beginReadTransaction();
        try {
            RemoteRepository remoteRepository = ((RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(remoteRoot);
            localPathPrefix = remoteRepository.getLocalPathPrefix();
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
        return localPathPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalPathPrefixOrFail(UUID repositoryId) {
        String localPathPrefix;
        LocalRepoTransactionImpl transaction = this.beginReadTransaction();
        try {
            RemoteRepository clientRemoteRepository = ((RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(repositoryId);
            localPathPrefix = clientRemoteRepository.getLocalPathPrefix();
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
        return localPathPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getRemoteRepositoryIdOrFail(URL remoteRoot) {
        UUID remoteRepositoryId;
        LocalRepoTransactionImpl transaction = this.beginReadTransaction();
        try {
            RemoteRepository remoteRepository = ((RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class)).getRemoteRepositoryOrFail(remoteRoot);
            remoteRepositoryId = remoteRepository.getRepositoryId();
            transaction.commit();
        }
        finally {
            transaction.rollbackIfActive();
        }
        return remoteRepositoryId;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public LocalRepoMetaData getLocalRepoMetaData() {
        this.lock.lock();
        try {
            if (this.localRepoMetaDataImpl == null) {
                this.localRepoMetaDataImpl = (LocalRepoMetaDataImpl)ObjectFactoryUtil.createObject(LocalRepoMetaDataImpl.class);
                this.localRepoMetaDataImpl.setLocalRepoManager(this);
            }
            LocalRepoMetaDataImpl localRepoMetaDataImpl = this.localRepoMetaDataImpl;
            return localRepoMetaDataImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class CloseTimerTask
    extends TimerTask {
        private volatile boolean cancelled;

        private CloseTimerTask() {
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            LocalRepoManagerImpl.this._close();
        }

        @Override
        public boolean cancel() {
            this.cancelled = true;
            boolean result = super.cancel();
            return result;
        }
    }
}

