/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.dbupdate;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.local.db.DatabaseAdapter;
import co.codewizards.cloudstore.local.dbupdate.DbUpdateStep;
import java.sql.Connection;
import java.util.Objects;

public abstract class AbstractDbUpdateStep
implements DbUpdateStep {
    private DatabaseAdapter databaseAdapter;

    @Override
    public int getOrderHint() {
        return 1000;
    }

    @Override
    public DatabaseAdapter getDatabaseAdapter() {
        return this.databaseAdapter;
    }

    @Override
    public void setDatabaseAdapter(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    protected DatabaseAdapter getDatabaseAdapterOrFail() {
        return Objects.requireNonNull(this.getDatabaseAdapter(), "databaseAdapter");
    }

    protected File getLocalRoot() {
        return this.getDatabaseAdapterOrFail().getLocalRoot();
    }

    protected File getMetaDir() {
        return this.getLocalRoot().createFile(new String[]{LocalRepoManager.META_DIR_NAME});
    }

    protected File getPersistencePropertiesFile() {
        File persistencePropertiesFile = this.getMetaDir().createFile(new String[]{LocalRepoManager.PERSISTENCE_PROPERTIES_FILE_NAME});
        if (!persistencePropertiesFile.isFile()) {
            throw new IllegalStateException("The persistencePropertiesFile does not exist or is not a file: " + persistencePropertiesFile.getAbsolutePath());
        }
        return persistencePropertiesFile;
    }

    protected Connection createConnection() throws Exception {
        return this.getDatabaseAdapterOrFail().createConnection();
    }
}

