/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;

public class StringTrim3Method
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args != null && args.size() > 1) {
            throw new NucleusException("TRIM has incorrect number of args");
        }
        SQLExpression trimCharExpr = null;
        if (args != null && args.size() > 0) {
            trimCharExpr = args.get(0);
        }
        ArrayList<SQLExpression> trimArgs = new ArrayList<SQLExpression>();
        if (trimCharExpr == null) {
            trimArgs.add(expr);
        } else {
            StringExpression argExpr = new StringExpression(stmt, expr.getJavaTypeMapping(), "NULL", null);
            SQLText sql = argExpr.toSQLText();
            sql.clearStatement();
            sql.append(this.getTrimSpecKeyword() + " ");
            sql.append(trimCharExpr);
            sql.append(" FROM ");
            sql.append(expr);
            trimArgs.add(argExpr);
        }
        StringExpression trimExpr = new StringExpression(stmt, expr.getJavaTypeMapping(), "TRIM", trimArgs);
        return trimExpr;
    }

    protected String getTrimSpecKeyword() {
        return "BOTH";
    }
}

