/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.welcome;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.util.DateUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpOwnerTrust;
import org.subshare.core.pgp.man.PgpPrivateKeyPassphraseStore;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRegistry;
import org.subshare.gui.backup.BackupImporter;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.ls.PgpPrivateKeyPassphraseManagerLs;
import org.subshare.gui.ls.UserRegistryLs;
import org.subshare.gui.welcome.IdentityData;
import org.subshare.gui.welcome.Messages;
import org.subshare.gui.welcome.first.FirstWizardPage;
import org.subshare.gui.welcome.identity.IdentityWizardPage;
import org.subshare.gui.wizard.DefaultFinishingPage;
import org.subshare.gui.wizard.Wizard;

public class IdentityWizard
extends Wizard {
    private final IdentityData identityData = new IdentityData();
    private final Pgp pgp = PgpLs.getPgpOrFail();
    private final PgpPrivateKeyPassphraseStore pgpPrivateKeyPassphraseStore = PgpPrivateKeyPassphraseManagerLs.getPgpPrivateKeyPassphraseStore();
    private boolean needed;
    private User user;

    public IdentityWizard() {
        super(new FirstWizardPage());
        Date now = DateUtil.now();
        ArrayList<PgpKey> usableMasterKeys = new ArrayList<PgpKey>();
        for (PgpKey pgpKey : this.pgp.getMasterKeysWithSecretKey()) {
            PgpKeyId pgpKeyId;
            if (pgpKey.isRevoked() || !pgpKey.isValid(now) || !this.pgpPrivateKeyPassphraseStore.hasPassphrase(pgpKeyId = pgpKey.getPgpKeyId())) continue;
            usableMasterKeys.add(pgpKey);
        }
        if (usableMasterKeys.isEmpty()) {
            this.needed = true;
            this.getFirstPage().setNextPage(new IdentityWizardPage(this.identityData));
        }
    }

    public IdentityData getIdentityData() {
        return this.identityData;
    }

    @Override
    public String getTitle() {
        return Messages.getString("IdentityWizard.title");
    }

    public boolean isNeeded() {
        return this.needed;
    }

    @Override
    protected void finishing() {
        this.identityData.getCreatePgpKeyParam().getUserIds().removeIf(pgpUserId -> pgpUserId.isEmpty());
        if (this.identityData.importBackupProperty().get()) {
            ((DefaultFinishingPage)this.getFinishingPage()).getHeaderText().setText("Importing data from backup...");
        } else {
            ((DefaultFinishingPage)this.getFinishingPage()).getHeaderText().setText(String.format(Messages.getString("IdentityWizard.finishingPage.headerText.text"), new Object[]{this.identityData.getPgpUserId()}));
        }
        super.finishing();
    }

    @Override
    protected void finish(ProgressMonitor monitor) throws Exception {
        if (this.identityData.importBackupProperty().get()) {
            File backupFile = this.identityData.getImportBackupData().getImportBackupFile();
            new BackupImporter().importBackup(backupFile);
        } else {
            this.createUserIfNeeded();
            this.createPgpKey();
        }
    }

    private void createUserIfNeeded() {
        if (this.user != null) {
            return;
        }
        UserRegistry userRegistry = UserRegistryLs.getUserRegistry();
        User user = userRegistry.createUser();
        user.setFirstName((String)this.identityData.firstNameProperty().get());
        user.setLastName((String)this.identityData.lastNameProperty().get());
        String email = this.identityData.getPgpUserId().getEmail();
        if (!StringUtil.isEmpty((String)email)) {
            user.getEmails().add(email);
        }
        userRegistry.addUser(user);
        this.user = user;
    }

    private void createPgpKey() {
        PgpPrivateKeyPassphraseStore pgpPrivateKeyPassphraseStore = PgpPrivateKeyPassphraseManagerLs.getPgpPrivateKeyPassphraseStore();
        PgpKey pgpKey = this.pgp.createPgpKey(this.identityData.getCreatePgpKeyParam().toPortable());
        this.user.getPgpKeyIds().add(pgpKey.getPgpKeyId());
        pgpPrivateKeyPassphraseStore.putPassphrase(pgpKey.getPgpKeyId(), this.identityData.getCreatePgpKeyParam().getPassphrase());
        this.pgp.setOwnerTrust(pgpKey, PgpOwnerTrust.ULTIMATE);
        this.pgp.updateTrustDb();
    }
}

