/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.local.db.Column;
import co.codewizards.cloudstore.local.db.ExternalJdbcDatabaseAdapter;
import co.codewizards.cloudstore.local.db.Table;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.SortedMap;

public class PostgresqlDatabaseAdapter
extends ExternalJdbcDatabaseAdapter {
    @Override
    public boolean passivateIdentityColumn(Connection connection, Table table, SortedMap<String, Column> columnName2Column) throws Exception {
        Column idCol = (Column)columnName2Column.get("ID");
        if (idCol == null) {
            return false;
        }
        return Boolean.TRUE.equals(idCol.autoIncrement);
    }

    @Override
    public void activateIdentityColumn(Connection connection, Table table, SortedMap<String, Column> columnName2Column) throws Exception {
        String sequenceName = table.name + "_id_seq";
        try (Statement statement = connection.createStatement();){
            long nextId;
            String sql = String.format("select max(id) from %s", table.name);
            try (ResultSet rs = statement.executeQuery(sql);){
                if (!rs.next()) {
                    throw new IllegalStateException("SELECT MAX(...) returned no row! Table: " + table.name);
                }
                nextId = rs.getLong(1);
                nextId = rs.wasNull() ? 1L : ++nextId;
                if (rs.next()) {
                    throw new IllegalStateException("SELECT MAX(...) returned multiple rows! Table: " + table.name);
                }
            }
            sql = String.format("alter sequence %s restart with %s", sequenceName, nextId);
            statement.executeUpdate(sql);
        }
    }
}

